/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.io.File;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class DiskChecker {
    public static boolean mkdirsWithExistsCheck(File dir) {
        if (dir.mkdir() || dir.exists()) {
            return true;
        }
        File canonDir = null;
        try {
            canonDir = dir.getCanonicalFile();
        }
        catch (IOException e) {
            return false;
        }
        String parent = canonDir.getParent();
        return parent != null && DiskChecker.mkdirsWithExistsCheck(new File(parent)) && (canonDir.mkdir() || canonDir.exists());
    }

    public static void checkDir(File dir) throws DiskErrorException {
        if (!DiskChecker.mkdirsWithExistsCheck(dir)) {
            throw new DiskErrorException("Can not create directory: " + dir.toString());
        }
        if (!dir.isDirectory()) {
            throw new DiskErrorException("Not a directory: " + dir.toString());
        }
        if (!dir.canRead()) {
            throw new DiskErrorException("Directory is not readable: " + dir.toString());
        }
        if (!dir.canWrite()) {
            throw new DiskErrorException("Directory is not writable: " + dir.toString());
        }
        if (!dir.canExecute()) {
            throw new DiskErrorException("Directory is not executable: " + dir.toString());
        }
    }

    public static void mkdirsWithExistsAndPermissionCheck(LocalFileSystem localFS, Path dir, FsPermission expected) throws IOException {
        File directory = localFS.pathToFile(dir);
        boolean created = false;
        if (!directory.exists()) {
            created = DiskChecker.mkdirsWithExistsCheck(directory);
        }
        if (created || !localFS.getFileStatus(dir).getPermission().equals(expected)) {
            localFS.setPermission(dir, expected);
        }
    }

    public static void checkDir(LocalFileSystem localFS, Path dir, FsPermission expected) throws DiskErrorException, IOException {
        DiskChecker.mkdirsWithExistsAndPermissionCheck(localFS, dir, expected);
        FileStatus stat = localFS.getFileStatus(dir);
        FsPermission actual = stat.getPermission();
        if (!stat.isDirectory()) {
            throw new DiskErrorException("not a directory: " + dir.toString());
        }
        FsAction user = actual.getUserAction();
        if (!user.implies(FsAction.READ)) {
            throw new DiskErrorException("directory is not readable: " + dir.toString());
        }
        if (!user.implies(FsAction.WRITE)) {
            throw new DiskErrorException("directory is not writable: " + dir.toString());
        }
        if (!user.implies(FsAction.EXECUTE)) {
            throw new DiskErrorException("directory is not listable: " + dir.toString());
        }
    }

    public static class DiskOutOfSpaceException
    extends IOException {
        public DiskOutOfSpaceException(String msg) {
            super(msg);
        }
    }

    public static class DiskErrorException
    extends IOException {
        public DiskErrorException(String msg) {
            super(msg);
        }
    }
}

