/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.schema.ldif.extractor.impl;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceMap {
    public static Map<String, Boolean> getResources(Pattern pattern) {
        String[] classPathElements;
        HashMap<String, Boolean> retval = new HashMap<String, Boolean>();
        String classPath = System.getProperty("java.class.path", ".");
        for (String element : classPathElements = classPath.split(File.pathSeparator)) {
            ResourceMap.getResources(retval, element, pattern);
        }
        return retval;
    }

    private static void getResources(HashMap<String, Boolean> map, String element, Pattern pattern) {
        File file = new File(element);
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            ResourceMap.getResourcesFromDirectory(map, file, pattern);
        } else {
            ResourceMap.getResourcesFromJarFile(map, file, pattern);
        }
    }

    private static void getResourcesFromJarFile(HashMap<String, Boolean> map, File file, Pattern pattern) {
        ZipFile zf;
        try {
            zf = new ZipFile(file);
        }
        catch (ZipException e) {
            throw new Error(e);
        }
        catch (IOException e) {
            throw new Error(e);
        }
        Enumeration<? extends ZipEntry> e = zf.entries();
        while (e.hasMoreElements()) {
            ZipEntry ze = e.nextElement();
            String fileName = ze.getName();
            boolean accept = pattern.matcher(fileName).matches();
            if (!accept) continue;
            map.put(fileName, Boolean.TRUE);
        }
        try {
            zf.close();
        }
        catch (IOException e1) {
            throw new Error(e1);
        }
    }

    private static void getResourcesFromDirectory(HashMap<String, Boolean> map, File directory, Pattern pattern) {
        File[] fileList;
        for (File file : fileList = directory.listFiles()) {
            if (file.isDirectory()) {
                ResourceMap.getResourcesFromDirectory(map, file, pattern);
                continue;
            }
            try {
                String fileName = file.getCanonicalPath();
                boolean accept = pattern.matcher(fileName).matches();
                if (!accept) continue;
                map.put(fileName, Boolean.FALSE);
            }
            catch (IOException e) {
                throw new Error(e);
            }
        }
    }
}

