/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.directory.server.core.configuration.StartupConfiguration;
import org.apache.directory.server.ldap.ExtendedOperationHandler;
import org.apache.directory.server.ldap.SessionRegistry;
import org.apache.directory.server.ldap.support.AbandonHandler;
import org.apache.directory.server.ldap.support.AddHandler;
import org.apache.directory.server.ldap.support.BindHandler;
import org.apache.directory.server.ldap.support.CompareHandler;
import org.apache.directory.server.ldap.support.DeleteHandler;
import org.apache.directory.server.ldap.support.ExtendedHandler;
import org.apache.directory.server.ldap.support.LdapMessageHandler;
import org.apache.directory.server.ldap.support.ModifyDnHandler;
import org.apache.directory.server.ldap.support.ModifyHandler;
import org.apache.directory.server.ldap.support.SearchHandler;
import org.apache.directory.server.ldap.support.UnbindHandler;
import org.apache.directory.shared.asn1.codec.Asn1CodecDecoder;
import org.apache.directory.shared.asn1.codec.Asn1CodecEncoder;
import org.apache.directory.shared.asn1.codec.stateful.StatefulDecoder;
import org.apache.directory.shared.asn1.codec.stateful.StatefulEncoder;
import org.apache.directory.shared.ldap.exception.LdapNamingException;
import org.apache.directory.shared.ldap.message.AbandonRequest;
import org.apache.directory.shared.ldap.message.AbandonRequestImpl;
import org.apache.directory.shared.ldap.message.AddRequest;
import org.apache.directory.shared.ldap.message.AddRequestImpl;
import org.apache.directory.shared.ldap.message.BindRequest;
import org.apache.directory.shared.ldap.message.BindRequestImpl;
import org.apache.directory.shared.ldap.message.CompareRequest;
import org.apache.directory.shared.ldap.message.CompareRequestImpl;
import org.apache.directory.shared.ldap.message.Control;
import org.apache.directory.shared.ldap.message.DeleteRequest;
import org.apache.directory.shared.ldap.message.DeleteRequestImpl;
import org.apache.directory.shared.ldap.message.ExtendedRequest;
import org.apache.directory.shared.ldap.message.ExtendedRequestImpl;
import org.apache.directory.shared.ldap.message.MessageDecoder;
import org.apache.directory.shared.ldap.message.MessageEncoder;
import org.apache.directory.shared.ldap.message.ModifyDnRequest;
import org.apache.directory.shared.ldap.message.ModifyDnRequestImpl;
import org.apache.directory.shared.ldap.message.ModifyRequest;
import org.apache.directory.shared.ldap.message.ModifyRequestImpl;
import org.apache.directory.shared.ldap.message.Request;
import org.apache.directory.shared.ldap.message.ResponseCarryingMessageException;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.message.ResultResponse;
import org.apache.directory.shared.ldap.message.ResultResponseRequest;
import org.apache.directory.shared.ldap.message.SearchRequest;
import org.apache.directory.shared.ldap.message.SearchRequestImpl;
import org.apache.directory.shared.ldap.message.UnbindRequest;
import org.apache.directory.shared.ldap.message.UnbindRequestImpl;
import org.apache.directory.shared.ldap.message.extended.NoticeOfDisconnect;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoFilterChain;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoSession;
import org.apache.mina.filter.SSLFilter;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.codec.ProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolEncoder;
import org.apache.mina.handler.demux.DemuxingIoHandler;
import org.apache.mina.util.SessionLog;

public class LdapProtocolProvider {
    public static final String SERVICE_NAME = "ldap";
    private static final Map DEFAULT_HANDLERS;
    private static final Set SUPPORTED_CONTROLS;
    private final ProtocolCodecFactory codecFactory;
    private final LdapProtocolHandler handler = new LdapProtocolHandler();

    public LdapProtocolProvider(StartupConfiguration cfg, Hashtable env) throws LdapNamingException {
        Hashtable copy = (Hashtable)env.clone();
        copy.put("java.naming.provider.url", "");
        SessionRegistry.releaseSingleton();
        new SessionRegistry(copy);
        Iterator requestTypes = DEFAULT_HANDLERS.keySet().iterator();
        while (requestTypes.hasNext()) {
            LdapMessageHandler handler = null;
            String type = (String)requestTypes.next();
            Class<?> clazz = null;
            if (copy.containsKey(type)) {
                try {
                    clazz = Class.forName((String)copy.get(type));
                }
                catch (ClassNotFoundException e) {
                    String msg = "failed to load class " + clazz;
                    msg = msg + " for processing " + type + " objects.";
                    LdapNamingException lne = new LdapNamingException(msg, ResultCodeEnum.OTHER);
                    lne.setRootCause((Throwable)e);
                    throw lne;
                }
            } else {
                clazz = (Class<?>)DEFAULT_HANDLERS.get(type);
            }
            try {
                Class<?> typeClass = Class.forName(type);
                handler = (LdapMessageHandler)clazz.newInstance();
                handler.init(cfg);
                this.handler.addMessageHandler(typeClass, handler);
            }
            catch (Exception e) {
                String msg = "failed to create handler instance of " + clazz;
                msg = msg + " for processing " + type + " objects.";
                LdapNamingException lne = new LdapNamingException(msg, ResultCodeEnum.OTHER);
                lne.setRootCause((Throwable)e);
                throw lne;
            }
        }
        this.codecFactory = new ProtocolCodecFactoryImpl(copy);
    }

    public String getName() {
        return SERVICE_NAME;
    }

    public ProtocolCodecFactory getCodecFactory() {
        return this.codecFactory;
    }

    public IoHandler getHandler() {
        return this.handler;
    }

    public void addExtendedOperationHandler(ExtendedOperationHandler eoh) {
        ExtendedHandler eh = (ExtendedHandler)this.handler.getMessageHandler(ExtendedRequest.class);
        eh.addHandler(eoh);
        eh = (ExtendedHandler)this.handler.getMessageHandler(ExtendedRequestImpl.class);
        eh.addHandler(eoh);
    }

    public void removeExtendedOperationHandler(String oid) {
        ExtendedHandler eh = (ExtendedHandler)this.handler.getMessageHandler(ExtendedRequest.class);
        eh.removeHandler(oid);
        eh = (ExtendedHandler)this.handler.getMessageHandler(ExtendedRequestImpl.class);
        eh.removeHandler(oid);
    }

    public ExtendedOperationHandler getExtendedOperationHandler(String oid) {
        ExtendedHandler eh = (ExtendedHandler)this.handler.getMessageHandler(ExtendedRequest.class);
        return eh.getHandler(oid);
    }

    public Map getExtendedOperationHandlerMap() {
        ExtendedHandler eh = (ExtendedHandler)this.handler.getMessageHandler(ExtendedRequest.class);
        return eh.getHandlerMap();
    }

    static {
        HashMap<String, Class> map = new HashMap<String, Class>();
        map.put(AbandonRequest.class.getName(), AbandonHandler.class);
        map.put(AbandonRequestImpl.class.getName(), AbandonHandler.class);
        map.put(AddRequest.class.getName(), AddHandler.class);
        map.put(AddRequestImpl.class.getName(), AddHandler.class);
        map.put(BindRequest.class.getName(), BindHandler.class);
        map.put(BindRequestImpl.class.getName(), BindHandler.class);
        map.put(CompareRequest.class.getName(), CompareHandler.class);
        map.put(CompareRequestImpl.class.getName(), CompareHandler.class);
        map.put(DeleteRequest.class.getName(), DeleteHandler.class);
        map.put(DeleteRequestImpl.class.getName(), DeleteHandler.class);
        map.put(ExtendedRequest.class.getName(), ExtendedHandler.class);
        map.put(ExtendedRequestImpl.class.getName(), ExtendedHandler.class);
        map.put(ModifyRequest.class.getName(), ModifyHandler.class);
        map.put(ModifyRequestImpl.class.getName(), ModifyHandler.class);
        map.put(ModifyDnRequest.class.getName(), ModifyDnHandler.class);
        map.put(ModifyDnRequestImpl.class.getName(), ModifyDnHandler.class);
        map.put(SearchRequest.class.getName(), SearchHandler.class);
        map.put(SearchRequestImpl.class.getName(), SearchHandler.class);
        map.put(UnbindRequest.class.getName(), UnbindHandler.class);
        map.put(UnbindRequestImpl.class.getName(), UnbindHandler.class);
        DEFAULT_HANDLERS = Collections.unmodifiableMap(map);
        HashSet<String> set = new HashSet<String>();
        set.add("2.16.840.1.113730.3.4.3");
        set.add("2.16.840.1.113730.3.4.7");
        set.add("2.16.840.1.113730.3.4.2");
        SUPPORTED_CONTROLS = Collections.unmodifiableSet(set);
    }

    private class LdapProtocolHandler
    extends DemuxingIoHandler {
        private LdapProtocolHandler() {
        }

        public void sessionCreated(IoSession session) throws Exception {
            IoFilterChain filters = session.getFilterChain();
            filters.addLast("codec", (IoFilter)new ProtocolCodecFilter(LdapProtocolProvider.this.codecFactory));
        }

        public void sessionClosed(IoSession session) {
            SessionRegistry.getSingleton().remove(session);
        }

        public void messageReceived(IoSession session, Object message) throws Exception {
            ExtendedRequestImpl req;
            if (message == SSLFilter.SESSION_SECURED) {
                req = new ExtendedRequestImpl(0);
                req.setOid("1.3.6.1.4.1.1466.20037");
                req.setPayload("SECURED".getBytes("ISO-8859-1"));
                message = req;
            } else if (message == SSLFilter.SESSION_UNSECURED) {
                req = new ExtendedRequestImpl(0);
                req.setOid("1.3.6.1.4.1.1466.20037");
                req.setPayload("UNSECURED".getBytes("ISO-8859-1"));
                message = req;
            }
            if (((Request)message).getControls().size() > 0 && message instanceof ResultResponseRequest) {
                req = (ResultResponseRequest)message;
                Iterator controls = req.getControls().values().iterator();
                while (controls.hasNext()) {
                    Control control = (Control)controls.next();
                    if (!control.isCritical() || SUPPORTED_CONTROLS.contains(control.getID())) continue;
                    ResultResponse resp = req.getResultResponse();
                    resp.getLdapResult().setErrorMessage("Unsupport critical control: " + control.getID());
                    resp.getLdapResult().setResultCode(ResultCodeEnum.UNAVAILABLECRITICALEXTENSION);
                    session.write((Object)resp);
                    return;
                }
            }
            super.messageReceived(session, message);
        }

        public void exceptionCaught(IoSession session, Throwable cause) {
            if (cause.getCause() instanceof ResponseCarryingMessageException) {
                ResponseCarryingMessageException rcme = (ResponseCarryingMessageException)cause.getCause();
                session.write((Object)rcme.getResponse());
                return;
            }
            SessionLog.warn((IoSession)session, (String)"Unexpected exception forcing session to close: sending disconnect notice to client.", (Throwable)cause);
            session.write((Object)NoticeOfDisconnect.PROTOCOLERROR);
            SessionRegistry.getSingleton().remove(session);
            session.close();
        }
    }

    private static final class ProtocolCodecFactoryImpl
    implements ProtocolCodecFactory {
        final Hashtable env;

        public ProtocolCodecFactoryImpl() {
            this.env = null;
        }

        ProtocolCodecFactoryImpl(Hashtable env) {
            this.env = env;
        }

        public ProtocolEncoder getEncoder() {
            return new Asn1CodecEncoder((StatefulEncoder)new MessageEncoder(this.env));
        }

        public ProtocolDecoder getDecoder() {
            return new Asn1CodecDecoder((StatefulDecoder)new MessageDecoder(this.env));
        }
    }
}

