/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.kdc.preauthentication;

import java.io.IOException;
import org.apache.directory.server.kerberos.kdc.KdcConfiguration;
import org.apache.directory.server.kerberos.kdc.authentication.AuthenticationContext;
import org.apache.directory.server.kerberos.kdc.preauthentication.VerifierBase;
import org.apache.directory.server.kerberos.shared.exceptions.ErrorType;
import org.apache.directory.server.kerberos.shared.exceptions.KerberosException;
import org.apache.directory.server.kerberos.shared.io.decoder.EncryptedDataDecoder;
import org.apache.directory.server.kerberos.shared.messages.KdcRequest;
import org.apache.directory.server.kerberos.shared.messages.value.EncryptedData;
import org.apache.directory.server.kerberos.shared.messages.value.EncryptedTimeStamp;
import org.apache.directory.server.kerberos.shared.messages.value.EncryptionKey;
import org.apache.directory.server.kerberos.shared.messages.value.PreAuthenticationData;
import org.apache.directory.server.kerberos.shared.messages.value.PreAuthenticationDataType;
import org.apache.directory.server.kerberos.shared.service.LockBox;
import org.apache.directory.server.kerberos.shared.store.PrincipalStoreEntry;
import org.apache.mina.common.IoSession;
import org.apache.mina.handler.chain.IoHandlerCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerifyEncryptedTimestamp
extends VerifierBase {
    private static final Logger log = LoggerFactory.getLogger((Class)VerifyEncryptedTimestamp.class);
    static /* synthetic */ Class class$org$apache$directory$server$kerberos$shared$messages$value$EncryptedTimeStamp;

    public void execute(IoHandlerCommand.NextCommand next, IoSession session, Object message) throws Exception {
        AuthenticationContext authContext = (AuthenticationContext)((Object)session.getAttribute(this.getContextKey()));
        if (authContext.getClientKey() != null) {
            next.execute(session, message);
        }
        log.debug("Verifying using encrypted timestamp.");
        KdcConfiguration config = authContext.getConfig();
        KdcRequest request = authContext.getRequest();
        LockBox lockBox = authContext.getLockBox();
        PrincipalStoreEntry clientEntry = authContext.getClientEntry();
        String clientName = clientEntry.getPrincipal().getName();
        EncryptionKey clientKey = null;
        if (clientEntry.getSamType() == null) {
            if (log.isDebugEnabled()) {
                log.debug("entry for client principal " + clientName + " has no SAM type: proceeding with standard pre-authentication");
            }
            if ((clientKey = clientEntry.getEncryptionKey()) == null) {
                throw new KerberosException(ErrorType.KDC_ERR_NULL_KEY);
            }
            if (config.isPaEncTimestampRequired()) {
                PreAuthenticationData[] preAuthData = request.getPreAuthData();
                if (preAuthData == null) {
                    throw new KerberosException(ErrorType.KDC_ERR_PREAUTH_REQUIRED, this.preparePreAuthenticationError());
                }
                EncryptedTimeStamp timestamp = null;
                for (int ii = 0; ii < preAuthData.length; ++ii) {
                    EncryptedData dataValue;
                    if (!preAuthData[ii].getDataType().equals(PreAuthenticationDataType.PA_ENC_TIMESTAMP)) continue;
                    try {
                        dataValue = EncryptedDataDecoder.decode((byte[])preAuthData[ii].getDataValue());
                    }
                    catch (IOException ioe) {
                        throw new KerberosException(ErrorType.KRB_AP_ERR_BAD_INTEGRITY);
                    }
                    catch (ClassCastException cce) {
                        throw new KerberosException(ErrorType.KRB_AP_ERR_BAD_INTEGRITY);
                    }
                    timestamp = (EncryptedTimeStamp)lockBox.unseal(class$org$apache$directory$server$kerberos$shared$messages$value$EncryptedTimeStamp == null ? VerifyEncryptedTimestamp.class$("org.apache.directory.server.kerberos.shared.messages.value.EncryptedTimeStamp") : class$org$apache$directory$server$kerberos$shared$messages$value$EncryptedTimeStamp, clientKey, dataValue);
                }
                if (timestamp == null) {
                    throw new KerberosException(ErrorType.KDC_ERR_PREAUTH_REQUIRED, this.preparePreAuthenticationError());
                }
                if (!timestamp.getTimeStamp().isInClockSkew(config.getClockSkew())) {
                    throw new KerberosException(ErrorType.KDC_ERR_PREAUTH_FAILED);
                }
            }
        }
        authContext.setClientKey(clientKey);
        if (log.isDebugEnabled()) {
            log.debug("Pre-authentication by encrypted timestamp successful for " + clientName + ".");
        }
        next.execute(session, message);
    }
}

