/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.controls.replication.syncRequestValue;

import java.nio.ByteBuffer;
import org.apache.directory.shared.asn1.AbstractAsn1Object;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.asn1.codec.EncoderException;
import org.apache.directory.shared.ldap.message.control.replication.SynchronizationModeEnum;
import org.apache.directory.shared.ldap.util.StringTools;

public class SyncRequestValueControlCodec
extends AbstractAsn1Object {
    private SynchronizationModeEnum mode;
    private byte[] cookie;
    private boolean reloadHint;
    private int syncRequestValueLength;

    public SynchronizationModeEnum getMode() {
        return this.mode;
    }

    public void setMode(SynchronizationModeEnum mode) {
        this.mode = mode;
    }

    public byte[] getCookie() {
        return this.cookie;
    }

    public void setCookie(byte[] cookie) {
        this.cookie = cookie;
    }

    public boolean isReloadHint() {
        return this.reloadHint;
    }

    public void setReloadHint(boolean reloadHint) {
        this.reloadHint = reloadHint;
    }

    public int computeLength() {
        this.syncRequestValueLength = 3;
        if (this.cookie != null) {
            this.syncRequestValueLength += 1 + TLV.getNbBytes(this.cookie.length) + this.cookie.length;
        }
        this.syncRequestValueLength += 3;
        return 1 + TLV.getNbBytes(this.syncRequestValueLength) + this.syncRequestValueLength;
    }

    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        ByteBuffer bb = ByteBuffer.allocate(this.computeLength());
        bb.put((byte)48);
        bb.put(TLV.getBytes(this.syncRequestValueLength));
        bb.put((byte)10);
        bb.put((byte)1);
        bb.put(Value.getBytes(this.mode.getValue()));
        if (this.cookie != null) {
            Value.encode(bb, this.cookie);
        }
        Value.encode(bb, this.reloadHint);
        return bb;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("    SyncRequestValue control :\n");
        sb.append("        mode              : '").append((Object)this.mode).append("'\n");
        sb.append("        cookie            : '").append(StringTools.dumpBytes(this.cookie)).append("'\n");
        sb.append("        refreshAndPersist : '").append(this.reloadHint).append("'\n");
        return sb.toString();
    }
}

