/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.soap.interceptor;

import java.io.InputStream;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.Bus;
import org.apache.cxf.binding.soap.Soap11;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.binding.soap.SoapHeader;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.SoapVersion;
import org.apache.cxf.binding.soap.SoapVersionFactory;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.headers.Header;
import org.apache.cxf.headers.HeaderManager;
import org.apache.cxf.headers.HeaderProcessor;
import org.apache.cxf.message.Message;
import org.apache.cxf.staxutils.PartialXMLStreamReader;
import org.apache.cxf.staxutils.StaxUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ReadHeadersInterceptor
extends AbstractSoapInterceptor {
    private static final Logger LOG = LogUtils.getL7dLogger(ReadHeadersInterceptor.class);
    private Bus bus;

    public ReadHeadersInterceptor(Bus b) {
        super("read");
        this.bus = b;
    }

    public ReadHeadersInterceptor(Bus b, String phase) {
        super(phase);
        this.bus = b;
    }

    public void handleMessage(SoapMessage message) {
        if (this.isGET((Message)message)) {
            LOG.info("ReadHeadersInterceptor skipped in HTTP GET method");
            return;
        }
        XMLStreamReader xmlReader = (XMLStreamReader)message.getContent(XMLStreamReader.class);
        if (xmlReader == null) {
            InputStream in = (InputStream)message.getContent(InputStream.class);
            if (in == null) {
                throw new RuntimeException("Can't find input stream in message");
            }
            xmlReader = StaxUtils.createXMLStreamReader((InputStream)in);
        }
        try {
            if (xmlReader.nextTag() == 1) {
                int i;
                String ns = xmlReader.getNamespaceURI();
                if (ns == null || "".equals(ns)) {
                    throw new SoapFault(new org.apache.cxf.common.i18n.Message("NO_NAMESPACE", LOG, new Object[]{xmlReader.getLocalName()}), Soap11.getInstance().getVersionMismatch());
                }
                SoapVersion soapVersion = SoapVersionFactory.getInstance().getSoapVersion(ns);
                if (soapVersion == null) {
                    throw new SoapFault(new org.apache.cxf.common.i18n.Message("INVALID_VERSION", LOG, new Object[]{ns, xmlReader.getLocalName()}), Soap11.getInstance().getVersionMismatch());
                }
                message.setVersion(soapVersion);
                PartialXMLStreamReader filteredReader = new PartialXMLStreamReader(xmlReader, message.getVersion().getBody());
                Document doc = StaxUtils.read((XMLStreamReader)filteredReader);
                message.setContent(Node.class, doc);
                Element element = doc.getDocumentElement();
                QName header = soapVersion.getHeader();
                NodeList headerEls = element.getElementsByTagNameNS(header.getNamespaceURI(), header.getLocalPart());
                for (i = 0; i < headerEls.getLength(); ++i) {
                    Node currentHead;
                    Node node = currentHead = headerEls.item(i);
                    NodeList heads = node.getChildNodes();
                    int len = heads.getLength();
                    for (int x = 0; x < len; ++x) {
                        node = heads.item(x);
                        if (node.getNodeType() != 1) continue;
                        Element hel = (Element)node;
                        if (currentHead.hasAttributes()) {
                            NamedNodeMap nnp = currentHead.getAttributes();
                            for (int ct = 0; ct < nnp.getLength(); ++ct) {
                                Node headerAttrNode;
                                Node attr = nnp.item(ct);
                                Node node2 = headerAttrNode = hel.hasAttributes() ? hel.getAttributes().getNamedItemNS(attr.getNamespaceURI(), attr.getLocalName()) : null;
                                if (headerAttrNode != null) continue;
                                Attr attribute = hel.getOwnerDocument().createAttributeNS(attr.getNamespaceURI(), attr.getNodeName());
                                attribute.setNodeValue(attr.getNodeValue());
                                hel.setAttributeNodeNS(attribute);
                            }
                        }
                        HeaderProcessor p = ((HeaderManager)this.bus.getExtension(HeaderManager.class)).getHeaderProcessor(hel.getNamespaceURI());
                        DataBinding dataBinding = null;
                        Object obj = p == null || p.getDataBinding() == null ? node : p.getDataBinding().createReader(Node.class).read((Object)node);
                        SoapHeader shead = new SoapHeader(new QName(node.getNamespaceURI(), node.getLocalName()), obj, dataBinding);
                        String mu = hel.getAttributeNS(soapVersion.getNamespace(), soapVersion.getAttrNameMustUnderstand());
                        String act = hel.getAttributeNS(soapVersion.getNamespace(), soapVersion.getAttrNameRole());
                        shead.setActor(act);
                        shead.setMustUnderstand(Boolean.valueOf(mu) != false || "1".equals(mu));
                        shead.setDirection(Header.Direction.DIRECTION_IN);
                        message.getHeaders().add(shead);
                    }
                }
                i = xmlReader.next();
                while (i == 13 || i == 10) {
                    i = xmlReader.next();
                }
            }
        }
        catch (XMLStreamException e) {
            throw new SoapFault(new org.apache.cxf.common.i18n.Message("XML_STREAM_EXC", LOG, new Object[0]), (Throwable)e, message.getVersion().getSender());
        }
    }
}

