/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.runtime;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.FileableCmisObject;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.ItemIterable;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.ObjectType;
import org.apache.chemistry.opencmis.client.api.OperationContext;
import org.apache.chemistry.opencmis.client.api.Policy;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.client.api.TransientFolder;
import org.apache.chemistry.opencmis.client.api.Tree;
import org.apache.chemistry.opencmis.client.runtime.AbstractTransientFileableCmisObject;
import org.apache.chemistry.opencmis.commons.data.Ace;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.FailedToDeleteData;
import org.apache.chemistry.opencmis.commons.enums.UnfileObject;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConstraintException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransientFolderImpl
extends AbstractTransientFileableCmisObject
implements TransientFolder {
    private boolean isMarkedForDeleteTree;
    private boolean deleteTreeAllVersions;
    private UnfileObject deleteTreeUnfile;
    private boolean deleteTreeContinueOnFailure;

    @Override
    protected void initialize(Session session, CmisObject object) {
        super.initialize(session, object);
        this.isMarkedForDeleteTree = false;
    }

    public Document createDocument(Map<String, ?> properties, ContentStream contentStream, VersioningState versioningState, List<Policy> policies, List<Ace> addAces, List<Ace> removeAces, OperationContext context) {
        return ((Folder)this.getCmisObject()).createDocument(properties, contentStream, versioningState, policies, addAces, removeAces, context);
    }

    public Document createDocument(Map<String, ?> properties, ContentStream contentStream, VersioningState versioningState) {
        return ((Folder)this.getCmisObject()).createDocument(properties, contentStream, versioningState);
    }

    public Document createDocumentFromSource(ObjectId source, Map<String, ?> properties, VersioningState versioningState, List<Policy> policies, List<Ace> addAces, List<Ace> removeAces, OperationContext context) {
        return ((Folder)this.getCmisObject()).createDocumentFromSource(source, properties, versioningState, policies, addAces, removeAces, context);
    }

    public Document createDocumentFromSource(ObjectId source, Map<String, ?> properties, VersioningState versioningState) {
        return ((Folder)this.getCmisObject()).createDocumentFromSource(source, properties, versioningState);
    }

    public Folder createFolder(Map<String, ?> properties, List<Policy> policies, List<Ace> addAces, List<Ace> removeAces, OperationContext context) {
        return ((Folder)this.getCmisObject()).createFolder(properties, policies, addAces, removeAces, context);
    }

    public Folder createFolder(Map<String, ?> properties) {
        return ((Folder)this.getCmisObject()).createFolder(properties);
    }

    public Policy createPolicy(Map<String, ?> properties, List<Policy> policies, List<Ace> addAces, List<Ace> removeAces, OperationContext context) {
        return ((Folder)this.getCmisObject()).createPolicy(properties, policies, addAces, removeAces, context);
    }

    public Policy createPolicy(Map<String, ?> properties) {
        return ((Folder)this.getCmisObject()).createPolicy(properties);
    }

    public void deleteTree(boolean allversions, UnfileObject unfile, boolean continueOnFailure) {
        this.deleteTreeAllVersions = allversions;
        this.deleteTreeUnfile = unfile;
        this.deleteTreeContinueOnFailure = continueOnFailure;
        this.isMarkedForDeleteTree = true;
        this.isMarkedForDelete = true;
        this.isModified = true;
    }

    public List<Tree<FileableCmisObject>> getFolderTree(int depth) {
        return ((Folder)this.getCmisObject()).getFolderTree(depth);
    }

    public List<Tree<FileableCmisObject>> getFolderTree(int depth, OperationContext context) {
        return ((Folder)this.getCmisObject()).getFolderTree(depth, context);
    }

    public List<Tree<FileableCmisObject>> getDescendants(int depth) {
        return ((Folder)this.getCmisObject()).getDescendants(depth);
    }

    public List<Tree<FileableCmisObject>> getDescendants(int depth, OperationContext context) {
        return ((Folder)this.getCmisObject()).getDescendants(depth, context);
    }

    public ItemIterable<CmisObject> getChildren() {
        return ((Folder)this.getCmisObject()).getChildren();
    }

    public ItemIterable<CmisObject> getChildren(OperationContext context) {
        return ((Folder)this.getCmisObject()).getChildren(context);
    }

    public boolean isRootFolder() {
        return ((Folder)this.getCmisObject()).isRootFolder();
    }

    public Folder getFolderParent() {
        return ((Folder)this.getCmisObject()).getFolderParent();
    }

    public String getPath() {
        return ((Folder)this.getCmisObject()).getPath();
    }

    public ItemIterable<Document> getCheckedOutDocs() {
        return ((Folder)this.getCmisObject()).getCheckedOutDocs();
    }

    public ItemIterable<Document> getCheckedOutDocs(OperationContext context) {
        return ((Folder)this.getCmisObject()).getCheckedOutDocs();
    }

    public String getParentId() {
        return (String)this.getPropertyValue("cmis:parentId");
    }

    public List<ObjectType> getAllowedChildObjectTypes() {
        ArrayList<ObjectType> result = new ArrayList<ObjectType>();
        List otids = (List)this.getPropertyValue("cmis:allowedChildObjectTypeIds");
        if (otids == null) {
            return result;
        }
        for (String otid : otids) {
            result.add(this.getSession().getTypeDefinition(otid));
        }
        return result;
    }

    public void setAllowedChildObjectTypes(List<ObjectType> types) {
        ArrayList<String> typeIds = new ArrayList<String>();
        if (types != null && !types.isEmpty()) {
            for (ObjectType type : types) {
                if (type == null) continue;
                typeIds.add(type.getId());
            }
        }
        this.setPropertyValue("cmis:allowedChildObjectTypeIds", typeIds);
    }

    @Override
    public ObjectId save() {
        if (!this.isModified()) {
            return this.getObjectId();
        }
        if (this.isMarkedForDeleteTree) {
            FailedToDeleteData ftd = this.getBinding().getObjectService().deleteTree(this.getRepositoryId(), this.getId(), Boolean.valueOf(this.deleteTreeAllVersions), this.deleteTreeUnfile, Boolean.valueOf(this.deleteTreeContinueOnFailure), null);
            if (ftd != null && !ftd.getIds().isEmpty()) {
                throw new CmisConstraintException("deleteTree could not delete all folder children: " + ftd.getIds());
            }
            return null;
        }
        return super.save();
    }
}

