/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.spi.browser;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.chemistry.opencmis.commons.impl.UrlBuilder;

public class RepositoryUrlCache
implements Serializable {
    public static final String CMIS_SELECTOR = "cmisselector";
    public static final String OBJECT_ID = "objectId";
    private static final long serialVersionUID = 1L;
    private final Map<String, String> repositoryUrls;
    private final Map<String, String> rootUrls;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    public RepositoryUrlCache() {
        this.repositoryUrls = new HashMap<String, String>();
        this.rootUrls = new HashMap<String, String>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRepository(String repositoryId, String repositoryUrl, String rootUrl) {
        this.lock.writeLock().lock();
        try {
            this.repositoryUrls.put(repositoryId, repositoryUrl);
            this.rootUrls.put(repositoryId, rootUrl);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRepository(String repositoryId) {
        this.lock.writeLock().lock();
        try {
            this.repositoryUrls.remove(repositoryId);
            this.rootUrls.remove(repositoryId);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRepositoryBaseUrl(String repositoryId) {
        this.lock.readLock().lock();
        try {
            String string = this.repositoryUrls.get(repositoryId);
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRootUrl(String repositoryId) {
        this.lock.readLock().lock();
        try {
            String string = this.rootUrls.get(repositoryId);
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public UrlBuilder getRepositoryUrl(String repositoryId) {
        String base = this.getRepositoryBaseUrl(repositoryId);
        if (base == null) {
            return null;
        }
        return new UrlBuilder(base);
    }

    public UrlBuilder getRepositoryUrl(String repositoryId, String selector) {
        UrlBuilder result = this.getRepositoryUrl(repositoryId);
        if (result == null) {
            return null;
        }
        result.addParameter(CMIS_SELECTOR, (Object)selector);
        return result;
    }

    public UrlBuilder getObjectUrl(String repositoryId, String objectId) {
        String root = this.getRootUrl(repositoryId);
        if (root == null) {
            return null;
        }
        UrlBuilder result = new UrlBuilder(root);
        result.addParameter(OBJECT_ID, (Object)objectId);
        return result;
    }

    public UrlBuilder getObjectUrl(String repositoryId, String objectId, String selector) {
        UrlBuilder result = this.getObjectUrl(repositoryId, objectId);
        if (result == null) {
            return null;
        }
        result.addParameter(CMIS_SELECTOR, (Object)selector);
        return result;
    }
}

