/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils.memory;

import java.lang.reflect.Field;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.Cell;
import org.apache.cassandra.db.CounterCell;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletedCell;
import org.apache.cassandra.db.ExpiringCell;
import org.apache.cassandra.db.NativeCell;
import org.apache.cassandra.db.NativeCounterCell;
import org.apache.cassandra.db.NativeDecoratedKey;
import org.apache.cassandra.db.NativeDeletedCell;
import org.apache.cassandra.db.NativeExpiringCell;
import org.apache.cassandra.utils.concurrent.OpOrder;
import org.apache.cassandra.utils.memory.MemtableAllocator;
import org.apache.cassandra.utils.memory.NativePool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.Unsafe;

public class NativeAllocator
extends MemtableAllocator {
    private static final Logger logger = LoggerFactory.getLogger(NativeAllocator.class);
    private static final int REGION_SIZE = 0x100000;
    private static final int MAX_CLONED_SIZE = 131072;
    private static final ConcurrentLinkedQueue<Region> RACE_ALLOCATED = new ConcurrentLinkedQueue();
    private final AtomicReference<Region> currentRegion = new AtomicReference();
    private final AtomicInteger regionCount = new AtomicInteger(0);
    private final ConcurrentLinkedQueue<Region> regions = new ConcurrentLinkedQueue();
    private AtomicLong unslabbed = new AtomicLong(0L);
    static final Unsafe unsafe;

    protected NativeAllocator(NativePool pool) {
        super(pool.onHeap.newAllocator(), pool.offHeap.newAllocator());
    }

    @Override
    public Cell clone(Cell cell, CFMetaData cfm, OpOrder.Group writeOp) {
        return new NativeCell(this, writeOp, cell);
    }

    @Override
    public CounterCell clone(CounterCell cell, CFMetaData cfm, OpOrder.Group writeOp) {
        return new NativeCounterCell(this, writeOp, cell);
    }

    @Override
    public DeletedCell clone(DeletedCell cell, CFMetaData cfm, OpOrder.Group writeOp) {
        return new NativeDeletedCell(this, writeOp, cell);
    }

    @Override
    public ExpiringCell clone(ExpiringCell cell, CFMetaData cfm, OpOrder.Group writeOp) {
        return new NativeExpiringCell(this, writeOp, cell);
    }

    @Override
    public DecoratedKey clone(DecoratedKey key, OpOrder.Group writeOp) {
        return new NativeDecoratedKey(key.getToken(), this, writeOp, key.getKey());
    }

    @Override
    public MemtableAllocator.DataReclaimer reclaimer() {
        return NO_OP;
    }

    public long allocate(int size, OpOrder.Group opGroup) {
        assert (size >= 0);
        this.offHeap().allocate(size, opGroup);
        if (size > 131072) {
            this.unslabbed.addAndGet(size);
            Region region = new Region(unsafe.allocateMemory(size), size);
            this.regions.add(region);
            long peer = region.allocate(size);
            if (peer == -1L) {
                throw new AssertionError();
            }
            return peer;
        }
        Region region;
        long peer;
        while ((peer = (region = this.getRegion()).allocate(size)) <= 0L) {
            this.currentRegion.compareAndSet(region, null);
        }
        return peer;
    }

    @Override
    public void setDiscarded() {
        for (Region region : this.regions) {
            unsafe.freeMemory(region.peer);
        }
        super.setDiscarded();
    }

    private Region getRegion() {
        Region region;
        while ((region = this.currentRegion.get()) == null) {
            region = RACE_ALLOCATED.poll();
            if (region == null) {
                region = new Region(unsafe.allocateMemory(0x100000L), 0x100000L);
            }
            if (this.currentRegion.compareAndSet(null, region)) {
                this.regions.add(region);
                this.regionCount.incrementAndGet();
                logger.trace("{} regions now allocated in {}", (Object)this.regionCount, (Object)this);
                return region;
            }
            RACE_ALLOCATED.add(region);
        }
        return region;
    }

    static {
        try {
            Field field = Unsafe.class.getDeclaredField("theUnsafe");
            field.setAccessible(true);
            unsafe = (Unsafe)field.get(null);
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    private static class Region {
        private final long peer;
        private final long capacity;
        private AtomicInteger nextFreeOffset = new AtomicInteger(0);
        private AtomicInteger allocCount = new AtomicInteger();

        private Region(long peer, long capacity) {
            this.peer = peer;
            this.capacity = capacity;
        }

        long allocate(int size) {
            int oldOffset;
            do {
                if ((long)((oldOffset = this.nextFreeOffset.get()) + size) <= this.capacity) continue;
                return -1L;
            } while (!this.nextFreeOffset.compareAndSet(oldOffset, oldOffset + size));
            this.allocCount.incrementAndGet();
            return this.peer + (long)oldOffset;
        }

        public String toString() {
            return "Region@" + System.identityHashCode(this) + " allocs=" + this.allocCount.get() + "waste=" + (this.capacity - (long)this.nextFreeOffset.get());
        }
    }
}

