/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.locator;

import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.apache.cassandra.io.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnitchProperties {
    private static final Logger logger = LoggerFactory.getLogger(SnitchProperties.class);
    public static final String RACKDC_PROPERTY_FILENAME = "cassandra-rackdc.properties";
    private Properties properties = new Properties();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SnitchProperties() {
        InputStream stream = null;
        String configURL = System.getProperty(RACKDC_PROPERTY_FILENAME);
        try {
            URL url = configURL == null ? SnitchProperties.class.getClassLoader().getResource(RACKDC_PROPERTY_FILENAME) : new URL(configURL);
            stream = url.openStream();
            this.properties.load(stream);
        }
        catch (Exception e) {
            try {
                logger.warn("Unable to read {}", (Object)(configURL != null ? configURL : RACKDC_PROPERTY_FILENAME));
            }
            catch (Throwable throwable) {
                FileUtils.closeQuietly(stream);
                throw throwable;
            }
            FileUtils.closeQuietly(stream);
        }
        FileUtils.closeQuietly(stream);
    }

    public String get(String propertyName, String defaultValue) {
        return this.properties.getProperty(propertyName, defaultValue);
    }
}

