/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.serializers.AsciiSerializer;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.TypeSerializer;
import org.apache.cassandra.utils.ByteBufferUtil;

public class AsciiType
extends AbstractType<String> {
    public static final AsciiType instance = new AsciiType();
    private final ThreadLocal<CharsetEncoder> encoder = new ThreadLocal<CharsetEncoder>(){

        @Override
        protected CharsetEncoder initialValue() {
            return Charset.forName("US-ASCII").newEncoder();
        }
    };

    AsciiType() {
    }

    @Override
    public int compare(ByteBuffer o1, ByteBuffer o2) {
        return ByteBufferUtil.compareUnsigned(o1, o2);
    }

    @Override
    public ByteBuffer fromString(String source) {
        CharsetEncoder theEncoder = this.encoder.get();
        theEncoder.reset();
        try {
            return theEncoder.encode(CharBuffer.wrap(source));
        }
        catch (CharacterCodingException exc) {
            throw new MarshalException(String.format("Invalid ASCII character in string literal: %s", exc));
        }
    }

    @Override
    public CQL3Type asCQL3Type() {
        return CQL3Type.Native.ASCII;
    }

    @Override
    public TypeSerializer<String> getSerializer() {
        return AsciiSerializer.instance;
    }

    @Override
    public boolean isByteOrderComparable() {
        return true;
    }
}

