/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.DataInput;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.RingPosition;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.io.ISerializer;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.ByteBufferUtil;

public interface RowPosition
extends RingPosition<RowPosition> {
    public static final RowPositionSerializer serializer = new RowPositionSerializer();

    public Kind kind();

    public boolean isMinimum();

    public static class RowPositionSerializer
    implements ISerializer<RowPosition> {
        @Override
        public void serialize(RowPosition pos, DataOutputPlus out) throws IOException {
            Kind kind = pos.kind();
            out.writeByte(kind.ordinal());
            if (kind == Kind.ROW_KEY) {
                ByteBufferUtil.writeWithShortLength(((DecoratedKey)pos).getKey(), out);
            } else {
                Token.serializer.serialize(pos.getToken(), out);
            }
        }

        @Override
        public RowPosition deserialize(DataInput in) throws IOException {
            Kind kind = Kind.fromOrdinal(in.readByte());
            if (kind == Kind.ROW_KEY) {
                ByteBuffer k = ByteBufferUtil.readWithShortLength(in);
                return StorageService.getPartitioner().decorateKey(k);
            }
            Token t = Token.serializer.deserialize(in);
            return kind == Kind.MIN_BOUND ? t.minKeyBound() : t.maxKeyBound();
        }

        @Override
        public long serializedSize(RowPosition pos, TypeSizes typeSizes) {
            Kind kind = pos.kind();
            int size = 1;
            if (kind == Kind.ROW_KEY) {
                int keySize = ((DecoratedKey)pos).getKey().remaining();
                size += typeSizes.sizeof((short)keySize) + keySize;
            } else {
                size = (int)((long)size + Token.serializer.serializedSize(pos.getToken(), typeSizes));
            }
            return size;
        }
    }

    public static final class ForKey {
        public static RowPosition get(ByteBuffer key, IPartitioner p) {
            return key == null || key.remaining() == 0 ? p.getMinimumToken().minKeyBound() : p.decorateKey(key);
        }
    }

    public static enum Kind {
        ROW_KEY,
        MIN_BOUND,
        MAX_BOUND;

        private static final Kind[] allKinds;

        static Kind fromOrdinal(int ordinal) {
            return allKinds[ordinal];
        }

        static {
            allKinds = Kind.values();
        }
    }
}

