/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Map;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.config.IndexType;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.cql3.CFName;
import org.apache.cassandra.cql3.statements.IndexPropDefs;
import org.apache.cassandra.cql3.statements.IndexTarget;
import org.apache.cassandra.cql3.statements.SchemaAlteringStatement;
import org.apache.cassandra.db.marshal.MapType;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.exceptions.UnauthorizedException;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.MigrationManager;
import org.apache.cassandra.thrift.ThriftValidation;
import org.apache.cassandra.transport.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateIndexStatement
extends SchemaAlteringStatement {
    private static final Logger logger = LoggerFactory.getLogger(CreateIndexStatement.class);
    private final String indexName;
    private final IndexTarget.Raw rawTarget;
    private final IndexPropDefs properties;
    private final boolean ifNotExists;

    public CreateIndexStatement(CFName name, String indexName, IndexTarget.Raw target, IndexPropDefs properties, boolean ifNotExists) {
        super(name);
        this.indexName = indexName;
        this.rawTarget = target;
        this.properties = properties;
        this.ifNotExists = ifNotExists;
    }

    @Override
    public void checkAccess(ClientState state) throws UnauthorizedException, InvalidRequestException {
        state.hasColumnFamilyAccess(this.keyspace(), this.columnFamily(), Permission.ALTER);
    }

    @Override
    public void validate(ClientState state) throws RequestValidationException {
        CFMetaData cfm = ThriftValidation.validateColumnFamily(this.keyspace(), this.columnFamily());
        if (cfm.isCounter()) {
            throw new InvalidRequestException("Secondary indexes are not supported on counter tables");
        }
        IndexTarget target = this.rawTarget.prepare(cfm);
        ColumnDefinition cd = cfm.getColumnDefinition(target.column);
        if (cd == null) {
            throw new InvalidRequestException("No column definition found for column " + target.column);
        }
        boolean isMap = cd.type instanceof MapType;
        if (target.isCollectionKeys && !isMap) {
            throw new InvalidRequestException("Cannot create index on keys of column " + target + " with non map type");
        }
        if (cd.getIndexType() != null) {
            boolean previousIsKeys = cd.hasIndexOption("index_keys");
            if (isMap && target.isCollectionKeys != previousIsKeys) {
                String msg = "Cannot create index on %s %s, an index on %s %s already exists and indexing a map on both keys and values at the same time is not currently supported";
                throw new InvalidRequestException(String.format(msg, target.column, target.isCollectionKeys ? "keys" : "values", target.column, previousIsKeys ? "keys" : "values"));
            }
            if (this.ifNotExists) {
                return;
            }
            throw new InvalidRequestException("Index already exists");
        }
        this.properties.validate();
        if (cfm.comparator.isDense() && cd.kind != ColumnDefinition.Kind.REGULAR) {
            throw new InvalidRequestException(String.format("Secondary index on %s column %s is not yet supported for compact table", new Object[]{cd.kind, target.column}));
        }
        if (cd.isStatic()) {
            throw new InvalidRequestException("Secondary indexes are not allowed on static columns");
        }
        if (cd.kind == ColumnDefinition.Kind.PARTITION_KEY && cd.isOnAllComponents()) {
            throw new InvalidRequestException(String.format("Cannot add secondary index to already primarily indexed column %s", target.column));
        }
    }

    @Override
    public boolean announceMigration(boolean isLocalOnly) throws RequestValidationException {
        CFMetaData cfm = Schema.instance.getCFMetaData(this.keyspace(), this.columnFamily()).copy();
        IndexTarget target = this.rawTarget.prepare(cfm);
        logger.debug("Updating column {} definition for index {}", (Object)target.column, (Object)this.indexName);
        ColumnDefinition cd = cfm.getColumnDefinition(target.column);
        if (cd.getIndexType() != null && this.ifNotExists) {
            return false;
        }
        if (this.properties.isCustom) {
            cd.setIndexType(IndexType.CUSTOM, this.properties.getOptions());
        } else if (cfm.comparator.isCompound()) {
            ImmutableMap options = Collections.emptyMap();
            if (cd.type.isCollection()) {
                options = ImmutableMap.of((Object)(target.isCollectionKeys ? "index_keys" : "index_values"), (Object)"");
            }
            cd.setIndexType(IndexType.COMPOSITES, (Map<String, String>)options);
        } else {
            cd.setIndexType(IndexType.KEYS, Collections.emptyMap());
        }
        cd.setIndexName(this.indexName);
        cfm.addDefaultIndexNames();
        MigrationManager.announceColumnFamilyUpdate(cfm, false, isLocalOnly);
        return true;
    }

    @Override
    public Event.SchemaChange changeEvent() {
        return new Event.SchemaChange(Event.SchemaChange.Change.UPDATED, Event.SchemaChange.Target.TABLE, this.keyspace(), this.columnFamily());
    }
}

