/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.config.KSMetaData;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.cql3.UTName;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.AsciiType;
import org.apache.cassandra.db.marshal.BooleanType;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.db.marshal.CounterColumnType;
import org.apache.cassandra.db.marshal.DecimalType;
import org.apache.cassandra.db.marshal.DoubleType;
import org.apache.cassandra.db.marshal.FloatType;
import org.apache.cassandra.db.marshal.InetAddressType;
import org.apache.cassandra.db.marshal.Int32Type;
import org.apache.cassandra.db.marshal.IntegerType;
import org.apache.cassandra.db.marshal.ListType;
import org.apache.cassandra.db.marshal.LongType;
import org.apache.cassandra.db.marshal.MapType;
import org.apache.cassandra.db.marshal.SetType;
import org.apache.cassandra.db.marshal.TimeUUIDType;
import org.apache.cassandra.db.marshal.TimestampType;
import org.apache.cassandra.db.marshal.TupleType;
import org.apache.cassandra.db.marshal.TypeParser;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.db.marshal.UUIDType;
import org.apache.cassandra.db.marshal.UserType;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.SyntaxException;

public interface CQL3Type {
    public boolean isCollection();

    public AbstractType<?> getType();

    public static abstract class Raw {
        protected boolean frozen;

        public boolean isCollection() {
            return false;
        }

        public boolean isCounter() {
            return false;
        }

        public Raw freeze() {
            this.frozen = true;
            return this;
        }

        public abstract CQL3Type prepare(String var1) throws InvalidRequestException;

        public static Raw from(CQL3Type type) {
            return new RawType(type);
        }

        public static Raw userType(UTName name) {
            return new RawUT(name);
        }

        public static Raw map(Raw t1, Raw t2) throws InvalidRequestException {
            if (t1.isCollection() || t2.isCollection()) {
                throw new InvalidRequestException("map type cannot contain another collection");
            }
            if (t1.isCounter() || t2.isCounter()) {
                throw new InvalidRequestException("counters are not allowed inside a collection");
            }
            return new RawCollection(CollectionType.Kind.MAP, t1, t2);
        }

        public static Raw list(Raw t) throws InvalidRequestException {
            if (t.isCollection()) {
                throw new InvalidRequestException("list type cannot contain another collection");
            }
            if (t.isCounter()) {
                throw new InvalidRequestException("counters are not allowed inside a collection");
            }
            return new RawCollection(CollectionType.Kind.LIST, null, t);
        }

        public static Raw set(Raw t) throws InvalidRequestException {
            if (t.isCollection()) {
                throw new InvalidRequestException("set type cannot contain another collection");
            }
            if (t.isCounter()) {
                throw new InvalidRequestException("counters are not allowed inside a collection");
            }
            return new RawCollection(CollectionType.Kind.SET, null, t);
        }

        public static Raw tuple(List<Raw> ts) throws InvalidRequestException {
            for (int i = 0; i < ts.size(); ++i) {
                if (ts.get(i) == null || !ts.get(i).isCounter()) continue;
                throw new InvalidRequestException("counters are not allowed inside tuples");
            }
            return new RawTuple(ts);
        }

        public static Raw frozen(Raw t) throws InvalidRequestException {
            if (t instanceof RawUT) {
                return ((RawUT)t).freeze();
            }
            if (t instanceof RawTuple) {
                return ((RawTuple)t).freeze();
            }
            throw new InvalidRequestException("frozen<> is only currently only allowed on User-Defined and tuple types");
        }

        private static class RawTuple
        extends Raw {
            private final List<Raw> types;

            private RawTuple(List<Raw> types) {
                this.types = types;
            }

            @Override
            public Raw freeze() {
                for (Raw t : this.types) {
                    if (t == null) continue;
                    t.freeze();
                }
                return super.freeze();
            }

            @Override
            public boolean isCollection() {
                return false;
            }

            @Override
            public CQL3Type prepare(String keyspace) throws InvalidRequestException {
                ArrayList ts = new ArrayList(this.types.size());
                for (Raw t : this.types) {
                    ts.add(t.prepare(keyspace).getType());
                }
                if (!this.frozen) {
                    throw new InvalidRequestException("Non-frozen tuples are not supported, please use frozen<>");
                }
                return new Tuple(new TupleType(ts));
            }

            public String toString() {
                StringBuilder sb = new StringBuilder();
                sb.append("tuple<");
                for (int i = 0; i < this.types.size(); ++i) {
                    if (i > 0) {
                        sb.append(", ");
                    }
                    sb.append(this.types.get(i));
                }
                sb.append(">");
                return sb.toString();
            }
        }

        private static class RawUT
        extends Raw {
            private final UTName name;

            private RawUT(UTName name) {
                this.name = name;
            }

            @Override
            public CQL3Type prepare(String keyspace) throws InvalidRequestException {
                KSMetaData ksm;
                if (this.name.hasKeyspace()) {
                    if (!keyspace.equals(this.name.getKeyspace())) {
                        throw new InvalidRequestException(String.format("Statement on keyspace %s cannot refer to a user type in keyspace %s; user types can only be used in the keyspace they are defined in", keyspace, this.name.getKeyspace()));
                    }
                } else {
                    this.name.setKeyspace(keyspace);
                }
                if ((ksm = Schema.instance.getKSMetaData(this.name.getKeyspace())) == null) {
                    throw new InvalidRequestException("Unknown keyspace " + this.name.getKeyspace());
                }
                UserType type = ksm.userTypes.getType(this.name.getUserTypeName());
                if (type == null) {
                    throw new InvalidRequestException("Unknown type " + this.name);
                }
                if (!this.frozen) {
                    throw new InvalidRequestException("Non-frozen User-Defined types are not supported, please use frozen<>");
                }
                return new UserDefined(this.name.toString(), type);
            }

            public boolean isUDT() {
                return true;
            }

            public String toString() {
                return this.name.toString();
            }
        }

        private static class RawCollection
        extends Raw {
            private final CollectionType.Kind kind;
            private final Raw keys;
            private final Raw values;

            private RawCollection(CollectionType.Kind kind, Raw keys, Raw values) {
                this.kind = kind;
                this.keys = keys;
                this.values = values;
            }

            @Override
            public Raw freeze() {
                if (this.keys != null) {
                    this.keys.freeze();
                }
                this.values.freeze();
                return super.freeze();
            }

            @Override
            public boolean isCollection() {
                return true;
            }

            @Override
            public CQL3Type prepare(String keyspace) throws InvalidRequestException {
                switch (this.kind) {
                    case LIST: {
                        return new Collection(ListType.getInstance(this.values.prepare(keyspace).getType()));
                    }
                    case SET: {
                        return new Collection(SetType.getInstance(this.values.prepare(keyspace).getType()));
                    }
                    case MAP: {
                        return new Collection(MapType.getInstance(this.keys.prepare(keyspace).getType(), this.values.prepare(keyspace).getType()));
                    }
                }
                throw new AssertionError();
            }

            public String toString() {
                switch (this.kind) {
                    case LIST: {
                        return "list<" + this.values + ">";
                    }
                    case SET: {
                        return "set<" + this.values + ">";
                    }
                    case MAP: {
                        return "map<" + this.keys + ", " + this.values + ">";
                    }
                }
                throw new AssertionError();
            }
        }

        private static class RawType
        extends Raw {
            private CQL3Type type;

            private RawType(CQL3Type type) {
                this.type = type;
            }

            @Override
            public CQL3Type prepare(String keyspace) throws InvalidRequestException {
                return this.type;
            }

            @Override
            public boolean isCounter() {
                return this.type == Native.COUNTER;
            }

            public String toString() {
                return this.type.toString();
            }
        }
    }

    public static class Tuple
    implements CQL3Type {
        private final TupleType type;

        private Tuple(TupleType type) {
            this.type = type;
        }

        public static Tuple create(TupleType type) {
            return new Tuple(type);
        }

        @Override
        public boolean isCollection() {
            return false;
        }

        @Override
        public AbstractType<?> getType() {
            return this.type;
        }

        public final boolean equals(Object o) {
            if (!(o instanceof Tuple)) {
                return false;
            }
            Tuple that = (Tuple)o;
            return this.type.equals(that.type);
        }

        public final int hashCode() {
            return this.type.hashCode();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("tuple<");
            for (int i = 0; i < this.type.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(this.type.type(i).asCQL3Type());
            }
            sb.append(">");
            return sb.toString();
        }
    }

    public static class UserDefined
    implements CQL3Type {
        private final String name;
        private final UserType type;

        private UserDefined(String name, UserType type) {
            this.name = name;
            this.type = type;
        }

        public static UserDefined create(UserType type) {
            return new UserDefined((String)UTF8Type.instance.compose(type.name), type);
        }

        @Override
        public boolean isCollection() {
            return false;
        }

        @Override
        public AbstractType<?> getType() {
            return this.type;
        }

        public final boolean equals(Object o) {
            if (!(o instanceof UserDefined)) {
                return false;
            }
            UserDefined that = (UserDefined)o;
            return this.type.equals(that.type);
        }

        public final int hashCode() {
            return this.type.hashCode();
        }

        public String toString() {
            return this.name;
        }
    }

    public static class Collection
    implements CQL3Type {
        private final CollectionType type;

        public Collection(CollectionType type) {
            this.type = type;
        }

        @Override
        public AbstractType<?> getType() {
            return this.type;
        }

        @Override
        public boolean isCollection() {
            return true;
        }

        public final boolean equals(Object o) {
            if (!(o instanceof Collection)) {
                return false;
            }
            Collection that = (Collection)o;
            return this.type.equals(that.type);
        }

        public final int hashCode() {
            return this.type.hashCode();
        }

        public String toString() {
            switch (this.type.kind) {
                case LIST: {
                    return "list<" + ((ListType)this.type).elements.asCQL3Type() + ">";
                }
                case SET: {
                    return "set<" + ((SetType)this.type).elements.asCQL3Type() + ">";
                }
                case MAP: {
                    MapType mt = (MapType)this.type;
                    return "map<" + mt.keys.asCQL3Type() + ", " + mt.values.asCQL3Type() + ">";
                }
            }
            throw new AssertionError();
        }
    }

    public static class Custom
    implements CQL3Type {
        private final AbstractType<?> type;

        public Custom(AbstractType<?> type) {
            this.type = type;
        }

        public Custom(String className) throws SyntaxException, ConfigurationException {
            this(TypeParser.parse(className));
        }

        @Override
        public boolean isCollection() {
            return false;
        }

        @Override
        public AbstractType<?> getType() {
            return this.type;
        }

        public final boolean equals(Object o) {
            if (!(o instanceof Custom)) {
                return false;
            }
            Custom that = (Custom)o;
            return this.type.equals(that.type);
        }

        public final int hashCode() {
            return this.type.hashCode();
        }

        public String toString() {
            return "'" + this.type + "'";
        }
    }

    public static enum Native implements CQL3Type
    {
        ASCII(AsciiType.instance),
        BIGINT(LongType.instance),
        BLOB(BytesType.instance),
        BOOLEAN(BooleanType.instance),
        COUNTER(CounterColumnType.instance),
        DECIMAL(DecimalType.instance),
        DOUBLE(DoubleType.instance),
        FLOAT(FloatType.instance),
        INET(InetAddressType.instance),
        INT(Int32Type.instance),
        TEXT(UTF8Type.instance),
        TIMESTAMP(TimestampType.instance),
        UUID(UUIDType.instance),
        VARCHAR(UTF8Type.instance),
        VARINT(IntegerType.instance),
        TIMEUUID(TimeUUIDType.instance);

        private final AbstractType<?> type;

        private Native(AbstractType<?> type) {
            this.type = type;
        }

        @Override
        public boolean isCollection() {
            return false;
        }

        @Override
        public AbstractType<?> getType() {
            return this.type;
        }

        public String toString() {
            return super.toString().toLowerCase();
        }
    }
}

