/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty4.codec;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import org.apache.camel.component.netty4.codec.LineBasedFrameDecoder;

public class DelimiterBasedFrameDecoder
extends io.netty.handler.codec.DelimiterBasedFrameDecoder {
    private final LineBasedFrameDecoder lineBasedFrameDecoder;

    public DelimiterBasedFrameDecoder(int maxFrameLength, boolean stripDelimiter, ByteBuf[] delimiters) {
        super(maxFrameLength, stripDelimiter, delimiters);
        this.lineBasedFrameDecoder = DelimiterBasedFrameDecoder.isLineBased(delimiters) ? new LineBasedFrameDecoder(maxFrameLength, stripDelimiter, true) : null;
    }

    public Object decode(ChannelHandlerContext ctx, ByteBuf in) throws Exception {
        if (this.lineBasedFrameDecoder != null) {
            return this.lineBasedFrameDecoder.decode(ctx, in);
        }
        return super.decode(ctx, in);
    }

    private static boolean isLineBased(ByteBuf[] delimiters) {
        if (delimiters.length != 2) {
            return false;
        }
        ByteBuf a = delimiters[0];
        ByteBuf b = delimiters[1];
        if (a.capacity() < b.capacity()) {
            a = delimiters[1];
            b = delimiters[0];
        }
        return a.capacity() == 2 && b.capacity() == 1 && a.getByte(0) == 13 && a.getByte(1) == 10 && b.getByte(0) == 10;
    }
}

