/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.security;

import java.security.Principal;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.activemq.broker.Broker;
import org.apache.activemq.broker.BrokerFilter;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.command.ConnectionInfo;
import org.apache.activemq.jaas.GroupPrincipal;
import org.apache.activemq.security.SecurityContext;

public class SimpleAuthenticationBroker
extends BrokerFilter {
    private boolean anonymousAccessAllowed = false;
    private String anonymousUser;
    private String anonymousGroup;
    private final Map<String, String> userPasswords;
    private final Map<String, Set<Principal>> userGroups;
    private final CopyOnWriteArrayList<SecurityContext> securityContexts = new CopyOnWriteArrayList();

    public SimpleAuthenticationBroker(Broker next, Map<String, String> userPasswords, Map<String, Set<Principal>> userGroups) {
        super(next);
        this.userPasswords = userPasswords;
        this.userGroups = userGroups;
    }

    public void setAnonymousAccessAllowed(boolean anonymousAccessAllowed) {
        this.anonymousAccessAllowed = anonymousAccessAllowed;
    }

    public void setAnonymousUser(String anonymousUser) {
        this.anonymousUser = anonymousUser;
    }

    public void setAnonymousGroup(String anonymousGroup) {
        this.anonymousGroup = anonymousGroup;
    }

    @Override
    public void addConnection(ConnectionContext context, ConnectionInfo info2) throws Exception {
        SecurityContext s = context.getSecurityContext();
        if (s == null) {
            if (this.anonymousAccessAllowed && info2.getUserName() == null && info2.getPassword() == null) {
                info2.setUserName(this.anonymousUser);
                s = new SecurityContext(info2.getUserName()){

                    @Override
                    public Set<Principal> getPrincipals() {
                        HashSet<Principal> groups = new HashSet<Principal>();
                        groups.add((Principal)new GroupPrincipal(SimpleAuthenticationBroker.this.anonymousGroup));
                        return groups;
                    }
                };
            } else {
                String pw = this.userPasswords.get(info2.getUserName());
                if (pw == null || !pw.equals(info2.getPassword())) {
                    throw new SecurityException("User name [" + info2.getUserName() + "] or password is invalid.");
                }
                final Set<Principal> groups = this.userGroups.get(info2.getUserName());
                s = new SecurityContext(info2.getUserName()){

                    @Override
                    public Set<Principal> getPrincipals() {
                        return groups;
                    }
                };
            }
            context.setSecurityContext(s);
            this.securityContexts.add(s);
        }
        try {
            super.addConnection(context, info2);
        }
        catch (Exception e) {
            this.securityContexts.remove(s);
            context.setSecurityContext(null);
            throw e;
        }
    }

    @Override
    public void removeConnection(ConnectionContext context, ConnectionInfo info2, Throwable error2) throws Exception {
        super.removeConnection(context, info2, error2);
        if (this.securityContexts.remove(context.getSecurityContext())) {
            context.setSecurityContext(null);
        }
    }

    public void refresh() {
        for (SecurityContext sc : this.securityContexts) {
            sc.getAuthorizedReadDests().clear();
            sc.getAuthorizedWriteDests().clear();
        }
    }
}

