/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.test.cluster;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.alfresco.jlan.client.DiskSession;
import org.alfresco.jlan.server.config.InvalidConfigurationException;
import org.alfresco.jlan.test.cluster.BooleanTestResult;
import org.alfresco.jlan.test.cluster.TestResult;
import org.springframework.extensions.config.ConfigElement;

public abstract class Test {
    private static SimpleDateFormat m_dateFormat = new SimpleDateFormat("HH:mm:ss.S");
    private String m_name;
    private int m_iterations;
    private boolean m_verbose;
    private boolean m_cleanup = true;
    private String m_path;

    public Test(String name) {
        this.m_name = name;
    }

    public final String getName() {
        return this.m_name;
    }

    public final String getPath() {
        return this.m_path;
    }

    public final int getIterations() {
        return this.m_iterations;
    }

    public final boolean isVerbose() {
        return this.m_verbose;
    }

    public final boolean hasTestCleanup() {
        return this.m_cleanup;
    }

    public final void setTestCleanup(boolean cleanup) {
        this.m_cleanup = cleanup;
    }

    public final void setPath(String path) {
        this.m_path = path;
        if (this.m_path != null) {
            if (!this.m_path.startsWith("\\")) {
                this.m_path = "\\" + this.m_path;
            }
            if (!this.m_path.endsWith("\\")) {
                this.m_path = this.m_path + "\\";
            }
        }
    }

    public final void setIterations(int iter) {
        this.m_iterations = iter;
    }

    public final void setVerbose(boolean verbose) {
        this.m_verbose = verbose;
    }

    public final String getPerTestFileName(int threadId, int iter) {
        StringBuilder fName = new StringBuilder();
        if (this.getPath() != null) {
            fName.append(this.getPath());
        } else {
            fName.append("\\");
        }
        fName.append(this.getName());
        fName.append("_");
        fName.append(iter);
        fName.append(".txt");
        return fName.toString();
    }

    public final String getPerThreadFileName(int threadId, int iter) {
        StringBuilder fName = new StringBuilder();
        if (this.getPath() != null) {
            fName.append(this.getPath());
        } else {
            fName.append("\\");
        }
        fName.append(this.getName());
        fName.append("_");
        fName.append(threadId);
        fName.append("_");
        fName.append(iter);
        fName.append(".txt");
        return fName.toString();
    }

    public final String getPerTestFolderName(int threadId, int iter) {
        StringBuilder fName = new StringBuilder();
        if (this.getPath() != null) {
            fName.append(this.getPath());
        } else {
            fName.append("\\");
        }
        fName.append(this.getName());
        fName.append("_");
        fName.append(iter);
        return fName.toString();
    }

    public final String getPerThreadFolderName(int threadId, int iter) {
        StringBuilder fName = new StringBuilder();
        if (this.getPath() != null) {
            fName.append(this.getPath());
        } else {
            fName.append("\\");
        }
        fName.append(this.getName());
        fName.append("_");
        fName.append(threadId);
        fName.append("_");
        fName.append(iter);
        return fName.toString();
    }

    public final String getUniqueFileName(int threadId, int iter, DiskSession sess) {
        StringBuilder fName = new StringBuilder();
        if (this.getPath() != null) {
            fName.append(this.getPath());
        } else {
            fName.append("\\");
        }
        fName.append(this.getName());
        fName.append("_");
        fName.append(threadId);
        fName.append("_");
        fName.append(iter);
        fName.append("_");
        fName.append(sess.getServer());
        fName.append(".txt");
        return fName.toString();
    }

    public final String getUniqueFolderName(int threadId, int iter, DiskSession sess) {
        StringBuilder fName = new StringBuilder();
        if (this.getPath() != null) {
            fName.append(this.getPath());
        } else {
            fName.append("\\");
        }
        fName.append(this.getName());
        fName.append("_");
        fName.append(threadId);
        fName.append("_");
        fName.append(iter);
        fName.append("_");
        fName.append(sess.getServer());
        return fName.toString();
    }

    public void configTest(ConfigElement config) throws InvalidConfigurationException {
    }

    public boolean initTest(int threadId, int iter, DiskSession sess) {
        return true;
    }

    public boolean runInit(int threadId, int curIter, DiskSession sess) {
        return true;
    }

    public abstract TestResult runTest(int var1, int var2, DiskSession var3, StringWriter var4);

    public void cleanupTest(int threadId, int iter, DiskSession sess, StringWriter log) throws Exception {
    }

    public TestResult processTestResults(List<TestResult> testResults) {
        int failCnt = 0;
        for (TestResult result : testResults) {
            if (result != null && result.isSuccess()) continue;
            ++failCnt;
        }
        BooleanTestResult finalResult = null;
        if (failCnt == 0) {
            finalResult = new BooleanTestResult(true);
        } else {
            finalResult = new BooleanTestResult(false);
            finalResult.setComment("" + failCnt + "/" + testResults.size() + " failures");
        }
        return finalResult;
    }

    protected String getPrefix() {
        return m_dateFormat.format(new Date()) + " [" + Thread.currentThread().getName() + "] ";
    }

    public void testLog(StringWriter log, String str) {
        if (this.isVerbose()) {
            log.append(this.getPrefix());
            log.append(str);
            log.append("\n");
        }
    }

    public void testLog(StringWriter log, Exception ex) {
        log.append(this.getPrefix());
        log.append(ex.getMessage());
        log.append("\n");
        ex.printStackTrace(new PrintWriter((Writer)log, true));
        log.append("\n");
    }

    protected final void testSleep(long sleepMs) {
        try {
            Thread.sleep(sleepMs);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("[");
        str.append(this.getName());
        str.append(",");
        if (this.getPath() == null) {
            str.append("\\");
        } else {
            str.append(this.getPath());
        }
        str.append(",");
        str.append(this.getIterations());
        str.append(",");
        str.append(this.isVerbose() ? "Verbose" : "Quiet");
        if (!this.hasTestCleanup()) {
            str.append(",NoCleanup");
        }
        str.append("]");
        return str.toString();
    }
}

