/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.smb.dcerpc.info;

import org.alfresco.jlan.smb.dcerpc.DCEBuffer;
import org.alfresco.jlan.smb.dcerpc.DCEBufferException;
import org.alfresco.jlan.smb.dcerpc.DCEReadable;
import org.alfresco.jlan.smb.dcerpc.DCEWriteable;

public class WorkstationInfo
implements DCEWriteable,
DCEReadable {
    public static final int InfoLevel100 = 100;
    private int m_infoLevel;
    private int m_platformId;
    private String m_name;
    private String m_domain;
    private int m_verMajor;
    private int m_verMinor;
    private String m_userName;
    private String m_logonDomain;
    private String m_otherDomain;

    public WorkstationInfo() {
    }

    public WorkstationInfo(int lev) {
        this.m_infoLevel = lev;
    }

    public final int getInformationLevel() {
        return this.m_infoLevel;
    }

    public final String getWorkstationName() {
        return this.m_name;
    }

    public final String getDomain() {
        return this.m_domain;
    }

    public final int getPlatformId() {
        return this.m_platformId;
    }

    public final int getMajorVersion() {
        return this.m_verMajor;
    }

    public final int getMinorVersion() {
        return this.m_verMinor;
    }

    public final String getUserName() {
        return this.m_userName;
    }

    public String getLogonDomain() {
        return this.m_logonDomain;
    }

    public String getOtherDomains() {
        return this.m_otherDomain;
    }

    public void setLogonDomain(String logdom) {
        this.m_logonDomain = logdom;
    }

    public void setOtherDomains(String othdom) {
        this.m_otherDomain = othdom;
    }

    public final void setWorkstationName(String name) {
        this.m_name = name;
    }

    public final void setDomain(String domain) {
        this.m_domain = domain;
    }

    public final void setInformationLevel(int lev) {
        this.m_infoLevel = lev;
    }

    public final void setPlatformId(int id) {
        this.m_platformId = id;
    }

    public final void setVersion(int verMajor, int verMinor) {
        this.m_verMajor = verMajor;
        this.m_verMinor = verMinor;
    }

    public final void setUserName(String user) {
        this.m_userName = user;
    }

    protected final void clearStrings() {
        this.m_userName = null;
        this.m_domain = null;
        this.m_logonDomain = null;
        this.m_otherDomain = null;
    }

    @Override
    public void writeObject(DCEBuffer buf, DCEBuffer strBuf) {
        buf.putInt(this.getInformationLevel());
        buf.putPointer(true);
        switch (this.getInformationLevel()) {
            case 100: {
                buf.putInt(this.getPlatformId());
                buf.putPointer(true);
                buf.putPointer(true);
                buf.putInt(this.getMajorVersion());
                buf.putInt(this.getMinorVersion());
                strBuf.putString(this.getWorkstationName(), 1, true);
                strBuf.putString(this.getDomain() != null ? this.getDomain() : "", 1, true);
                break;
            }
            case 101: {
                break;
            }
        }
    }

    @Override
    public void readObject(DCEBuffer buf) throws DCEBufferException {
        this.clearStrings();
        buf.getInt();
        if (buf.getPointer() == 0) {
            return;
        }
        switch (this.getInformationLevel()) {
            case 100: {
                this.m_platformId = buf.getInt();
                this.m_name = buf.getPointer() != 0 ? "" : null;
                this.m_domain = buf.getPointer() != 0 ? "" : null;
                this.m_verMajor = buf.getInt();
                this.m_verMinor = buf.getInt();
                this.readStrings(buf);
            }
        }
    }

    @Override
    public void readStrings(DCEBuffer buf) throws DCEBufferException {
        switch (this.getInformationLevel()) {
            case 100: {
                if (this.m_name != null) {
                    this.m_name = buf.getString(1);
                }
                if (this.m_domain == null) break;
                this.m_domain = buf.getString(1);
            }
        }
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("[");
        str.append(this.getWorkstationName());
        str.append(":Domain=");
        str.append(this.getDomain());
        str.append(":User=");
        str.append(this.getUserName());
        str.append(":Id=");
        str.append(this.getPlatformId());
        str.append(":v");
        str.append(this.getMajorVersion());
        str.append(".");
        str.append(this.getMinorVersion());
        if (this.getLogonDomain() != null) {
            str.append(":Logon=");
            str.append(this.getLogonDomain());
        }
        if (this.getOtherDomains() != null) {
            str.append(":Other=");
            str.append(this.getOtherDomains());
        }
        str.append("]");
        return str.toString();
    }
}

