/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.smb;

import org.alfresco.jlan.util.DataBuffer;

public class TransactBuffer {
    protected static final int DefaultSetupSize = 32;
    protected static final int DefaultDataSize = 8192;
    protected static final int DefaultParameterSize = 64;
    protected static final int DefaultMaxSetupReturn = 16;
    protected static final int DefaultMaxParameterReturn = 256;
    protected static final int DefaultMaxDataReturn = 65000;
    protected int m_treeId = -1;
    protected int m_type;
    protected int m_func;
    protected String m_name;
    protected DataBuffer m_setupBuf;
    protected DataBuffer m_paramBuf;
    protected DataBuffer m_dataBuf;
    protected boolean m_multi;
    protected boolean m_unicode;
    protected int m_maxSetup = 16;
    protected int m_maxParam = 256;
    protected int m_maxData = 65000;

    public TransactBuffer() {
        this.m_setupBuf = new DataBuffer(32);
        this.m_paramBuf = new DataBuffer(64);
        this.m_dataBuf = new DataBuffer(8192);
    }

    public TransactBuffer(int scnt, int pcnt, int dcnt) {
        if (scnt > 0) {
            this.m_setupBuf = new DataBuffer(scnt);
        }
        if (pcnt > 0) {
            this.m_paramBuf = new DataBuffer(pcnt);
        }
        if (dcnt > 0) {
            this.m_dataBuf = new DataBuffer(dcnt);
        }
        this.m_multi = true;
    }

    public TransactBuffer(int cmd, int scnt, int pcnt, int dcnt) {
        this.setType(cmd);
        if (scnt > 0) {
            this.m_setupBuf = new DataBuffer(scnt);
        }
        if (pcnt > 0) {
            this.m_paramBuf = new DataBuffer(pcnt);
        }
        if (dcnt > 0) {
            this.m_dataBuf = new DataBuffer(dcnt);
        }
        this.m_multi = true;
    }

    public TransactBuffer(int func, String name, int scnt, int pcnt, int dcnt) {
        this.setName(name);
        if (scnt > 0) {
            this.m_setupBuf = new DataBuffer(scnt);
        }
        if (pcnt > 0) {
            this.m_paramBuf = new DataBuffer(pcnt);
        }
        if (dcnt > 0) {
            this.m_dataBuf = new DataBuffer(dcnt);
        }
        this.setFunction(func);
        this.m_multi = true;
    }

    public TransactBuffer(int func, int scnt, int pcnt, byte[] dbuf, int doff, int dlen) {
        if (scnt > 0) {
            this.m_setupBuf = new DataBuffer(scnt);
        }
        if (pcnt > 0) {
            this.m_paramBuf = new DataBuffer(pcnt);
        }
        if (dbuf != null) {
            this.m_dataBuf = new DataBuffer(dbuf, doff, dlen);
            this.m_dataBuf.setPosition(dlen);
        }
        this.setFunction(func);
        this.m_multi = true;
    }

    public final boolean hasTreeId() {
        return this.m_treeId != -1;
    }

    public final int getTreeId() {
        return this.m_treeId;
    }

    public final int isType() {
        return this.m_type;
    }

    public final int getFunction() {
        return this.m_func;
    }

    public final boolean hasName() {
        return this.m_name != null;
    }

    public final String getName() {
        return this.m_name;
    }

    public final boolean isMultiPacket() {
        return this.m_multi;
    }

    public final boolean isUnicode() {
        return this.m_unicode;
    }

    public final boolean hasSetupBuffer() {
        return this.m_setupBuf != null;
    }

    public final DataBuffer getSetupBuffer() {
        return this.m_setupBuf;
    }

    public final boolean hasParameterBuffer() {
        return this.m_paramBuf != null;
    }

    public final DataBuffer getParameterBuffer() {
        return this.m_paramBuf;
    }

    public final boolean hasDataBuffer() {
        return this.m_dataBuf != null;
    }

    public final DataBuffer getDataBuffer() {
        return this.m_dataBuf;
    }

    public final int getReturnSetupLimit() {
        return this.m_maxSetup;
    }

    public final int getReturnParameterLimit() {
        return this.m_maxParam;
    }

    public final int getReturnDataLimit() {
        return this.m_maxData;
    }

    public final void setTreeId(int tid) {
        this.m_treeId = tid;
    }

    public final void setType(int typ) {
        this.m_type = typ;
    }

    public final void setFunction(int func) {
        this.m_func = func;
    }

    public final void setName(String name) {
        this.m_name = name;
    }

    public final void setUnicode(boolean uni) {
        this.m_unicode = uni;
    }

    public final void setReturnSetupLimit(int limit) {
        this.m_maxSetup = limit;
    }

    public final void setReturnParameterLimit(int limit) {
        this.m_maxParam = limit;
    }

    public final void setReturnDataLimit(int limit) {
        this.m_maxData = limit;
    }

    public final void setReturnLimits(int slimit, int plimit, int dlimit) {
        this.setReturnSetupLimit(slimit);
        this.setReturnParameterLimit(plimit);
        this.setReturnDataLimit(dlimit);
    }

    public final void setEndOfBuffer() {
        if (this.m_setupBuf != null) {
            this.m_setupBuf.setEndOfBuffer();
        }
        if (this.m_paramBuf != null) {
            this.m_paramBuf.setEndOfBuffer();
        }
        if (this.m_dataBuf != null) {
            this.m_dataBuf.setEndOfBuffer();
        }
    }

    public final void appendSetup(byte[] buf, int off, int len) {
        this.m_setupBuf.appendData(buf, off, len);
    }

    public final void appendParameter(byte[] buf, int off, int len) {
        this.m_paramBuf.appendData(buf, off, len);
    }

    public final void appendData(byte[] buf, int off, int len) {
        this.m_dataBuf.appendData(buf, off, len);
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("[");
        switch (this.isType()) {
            case 37: {
                str.append("Trans");
                break;
            }
            case 50: {
                str.append("Trans2(");
                str.append(this.getName());
                str.append(")");
                break;
            }
            case 160: {
                str.append("NTTrans");
                break;
            }
            default: {
                str.append("Unknown");
            }
        }
        str.append("-0x");
        str.append(Integer.toHexString(this.getFunction()));
        str.append(": setup=");
        if (this.m_setupBuf != null) {
            str.append(this.m_setupBuf);
        } else {
            str.append("none");
        }
        str.append(",param=");
        if (this.m_paramBuf != null) {
            str.append(this.m_paramBuf);
        } else {
            str.append("none");
        }
        str.append(",data=");
        if (this.m_dataBuf != null) {
            str.append(this.m_dataBuf);
        } else {
            str.append("none");
        }
        str.append("]");
        str.append(",max=");
        str.append(this.getReturnSetupLimit());
        str.append("/");
        str.append(this.getReturnParameterLimit());
        str.append("/");
        str.append(this.getReturnDataLimit());
        return str.toString();
    }
}

