/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.server.filesys.pseudo;

import org.alfresco.jlan.server.filesys.FileInfo;
import org.alfresco.jlan.server.filesys.NetworkFile;
import org.alfresco.jlan.server.filesys.pseudo.MemoryNetworkFile;
import org.alfresco.jlan.server.filesys.pseudo.PseudoFile;
import org.alfresco.jlan.server.filesys.pseudo.PseudoFileInfo;

public class MemoryPseudoFile
extends PseudoFile {
    private byte[] m_data;

    public MemoryPseudoFile(String name, byte[] data) {
        super(name);
        this.m_data = data;
    }

    @Override
    public FileInfo getFileInfo() {
        if (this.getInfo() == null) {
            PseudoFileInfo fInfo = new PseudoFileInfo(this.getFileName(), this.m_data != null ? (long)this.m_data.length : 0L, this.getAttributes());
            fInfo.setCreationDateTime(_creationDateTime);
            fInfo.setModifyDateTime(_creationDateTime);
            fInfo.setChangeDateTime(_creationDateTime);
            fInfo.setAllocationSize(fInfo.getSize() + 512L & 0xFFFFFFFFFFFFFE00L);
            this.setFileInfo(fInfo);
        }
        return this.getInfo();
    }

    @Override
    public NetworkFile getFile(String netPath) {
        FileInfo finfo = this.getFileInfo();
        finfo.setPath(netPath);
        return new MemoryNetworkFile(this.getFileName(), this.m_data, finfo);
    }
}

