/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.server.auth.kerberos;

import java.io.IOException;
import java.util.Iterator;
import org.alfresco.jlan.server.auth.asn.DERBuffer;
import org.alfresco.jlan.server.auth.asn.DERGeneralString;
import org.alfresco.jlan.server.auth.asn.DERInteger;
import org.alfresco.jlan.server.auth.asn.DERObject;
import org.alfresco.jlan.server.auth.asn.DEROctetString;
import org.alfresco.jlan.server.auth.asn.DERSequence;
import org.alfresco.jlan.server.auth.kerberos.PrincipalName;

public class KrbTicket {
    private String m_realm;
    private PrincipalName m_principalName;
    private int m_encType;
    private byte[] m_encPart;
    private int m_encKvno = -1;

    public KrbTicket() {
    }

    public KrbTicket(byte[] blob) throws IOException {
        this.parseTicket(blob);
    }

    public final String getRealm() {
        return this.m_realm;
    }

    public final PrincipalName getPrincipalName() {
        return this.m_principalName;
    }

    public final byte[] getEncryptedPart() {
        return this.m_encPart;
    }

    public final int getEncryptedType() {
        return this.m_encType;
    }

    public final int getEncryptedPartKeyVersion() {
        return this.m_encKvno;
    }

    public final void parseTicket(byte[] blob) throws IOException {
        DERBuffer derBuf = new DERBuffer(blob);
        DERObject derObj = derBuf.unpackObject();
        if (derObj instanceof DERSequence) {
            DERSequence derSeq = (DERSequence)derObj;
            Iterator<DERObject> iterObj = derSeq.getObjects();
            block11: while (iterObj.hasNext()) {
                derObj = iterObj.next();
                if (derObj == null || !derObj.isTagged()) continue;
                switch (derObj.getTagNo()) {
                    case 0: {
                        if (!(derObj instanceof DERInteger)) break;
                        DERInteger derInt = (DERInteger)derObj;
                        if (derInt.intValue() == 5) continue block11;
                        throw new IOException("Unexpected VNO value in Kerberos ticket");
                    }
                    case 1: {
                        if (!(derObj instanceof DERGeneralString)) break;
                        DERGeneralString derStr = (DERGeneralString)derObj;
                        this.m_realm = derStr.getValue();
                        break;
                    }
                    case 2: {
                        if (!(derObj instanceof DERSequence)) break;
                        DERSequence derPrincSeq = (DERSequence)derObj;
                        this.m_principalName = new PrincipalName();
                        this.m_principalName.parsePrincipalName(derPrincSeq);
                        break;
                    }
                    case 3: {
                        if (!(derObj instanceof DERSequence)) break;
                        DERSequence derEncSeq = (DERSequence)derObj;
                        Iterator<DERObject> iterEncSeq = derEncSeq.getObjects();
                        while (iterEncSeq.hasNext()) {
                            derObj = iterEncSeq.next();
                            if (derObj == null || !derObj.isTagged()) continue;
                            switch (derObj.getTagNo()) {
                                case 0: {
                                    if (!(derObj instanceof DERInteger)) break;
                                    DERInteger derInt = (DERInteger)derObj;
                                    this.m_encType = derInt.intValue();
                                    break;
                                }
                                case 1: {
                                    if (!(derObj instanceof DERInteger)) break;
                                    DERInteger derInt = (DERInteger)derObj;
                                    this.m_encKvno = derInt.intValue();
                                    break;
                                }
                                case 2: {
                                    if (!(derObj instanceof DEROctetString)) break;
                                    DEROctetString derOct = (DEROctetString)derObj;
                                    this.m_encPart = derOct.getValue();
                                }
                            }
                        }
                        break;
                    }
                }
            }
        }
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("[KrbTkt Realm=");
        str.append(this.getRealm());
        str.append(",Principal=");
        str.append(this.getPrincipalName());
        str.append(",EncPart=Type=");
        str.append(this.getEncryptedType());
        str.append(",KVNO=");
        str.append(this.getEncryptedPartKeyVersion());
        str.append(",Len=");
        str.append(this.getEncryptedPart() != null ? this.getEncryptedPart().length : 0);
        str.append("]");
        return str.toString();
    }
}

