/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.server.auth.acl;

import java.util.StringTokenizer;
import org.alfresco.jlan.server.SrvSession;
import org.alfresco.jlan.server.auth.acl.AccessControl;
import org.alfresco.jlan.server.auth.acl.AccessControlManager;
import org.alfresco.jlan.server.core.SharedDevice;

public class ProtocolAccessControl
extends AccessControl {
    private static final String[] _protoTypes = new String[]{"SMB", "CIFS", "NFS", "FTP"};
    private String[] m_checkList;

    public ProtocolAccessControl(String protList, String type, int access) {
        super(protList, type, access);
        this.m_checkList = ProtocolAccessControl.listFromString(protList);
    }

    @Override
    public int allowsAccess(SrvSession sess, SharedDevice share, AccessControlManager mgr) {
        String sessProto = null;
        String sessName = sess.getClass().getName();
        if (sessName.endsWith(".SMBSrvSession")) {
            sessProto = "CIFS";
        } else if (sessName.endsWith(".FTPSrvSession")) {
            sessProto = "FTP";
        } else if (sessName.endsWith(".NFSSrvSession")) {
            sessProto = "NFS";
        }
        if (sessProto != null && ProtocolAccessControl.indexFromList(sessProto, this.m_checkList, false) != -1) {
            return this.getAccess();
        }
        return -1;
    }

    public static final boolean validateProtocolList(String protList) {
        if (protList == null || protList.length() == 0) {
            return false;
        }
        StringTokenizer tokens = new StringTokenizer(protList, ",");
        while (tokens.hasMoreTokens()) {
            String name = tokens.nextToken().toUpperCase();
            if (ProtocolAccessControl.indexFromList(name, _protoTypes, false) != -1) continue;
            return false;
        }
        return true;
    }
}

