/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.ftp;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.alfresco.jlan.ftp.FTPAuthenticator;
import org.alfresco.jlan.ftp.FTPSrvSession;
import org.alfresco.jlan.server.auth.ClientInfo;
import org.alfresco.jlan.server.auth.UserAccount;
import org.alfresco.jlan.server.config.InvalidConfigurationException;
import org.alfresco.jlan.server.config.SecurityConfigSection;
import org.alfresco.jlan.server.config.ServerConfiguration;
import org.springframework.extensions.config.ConfigElement;

public class LocalAuthenticator
implements FTPAuthenticator {
    protected ServerConfiguration m_config;
    protected SecurityConfigSection m_securityConfig;
    private boolean m_debug;

    @Override
    public boolean authenticateUser(ClientInfo cInfo, FTPSrvSession sess) {
        UserAccount userAcc = this.getUserDetails(cInfo.getUserName());
        if (userAcc != null) {
            boolean authSts = false;
            if (cInfo.getPassword() != null) {
                if (userAcc.hasMD4Password()) {
                    try {
                        MessageDigest md4 = MessageDigest.getInstance("MD4");
                        md4.update(cInfo.getPassword());
                        byte[] md4Hash = md4.digest();
                        byte[] userMd4 = userAcc.getMD4Password();
                        for (int i = 0; i < userMd4.length; ++i) {
                            if (userMd4[i] == md4Hash[i]) continue;
                            authSts = false;
                        }
                    }
                    catch (NoSuchAlgorithmException ex) {}
                } else {
                    byte[] clientPwd;
                    byte[] userPwd = userAcc.getPassword().getBytes();
                    if (userPwd.length == (clientPwd = cInfo.getPassword()).length) {
                        authSts = true;
                        for (int i = 0; i < userPwd.length; ++i) {
                            if (userPwd[i] == clientPwd[i]) continue;
                            authSts = false;
                        }
                    }
                }
            }
            return authSts;
        }
        return false;
    }

    public final UserAccount getUserDetails(String user) {
        return this.m_securityConfig.getUsersInterface().getUserAccount(user);
    }

    public final boolean hasDebug() {
        return this.m_debug;
    }

    @Override
    public void initialize(ServerConfiguration config, ConfigElement params) throws InvalidConfigurationException {
        this.m_config = config;
        this.m_securityConfig = (SecurityConfigSection)this.m_config.getConfigSection("Security");
        if (params.getChild("Debug") != null) {
            this.m_debug = true;
        }
    }

    @Override
    public void closeAuthenticator() {
    }
}

