/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.debug;

import java.io.FileInputStream;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.alfresco.jlan.debug.DebugInterfaceBase;
import org.alfresco.jlan.server.config.ServerConfiguration;
import org.springframework.extensions.config.ConfigElement;

public class JDKLoggingDebug
extends DebugInterfaceBase {
    private StringBuilder m_printBuf;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void debugPrint(String str, int level) {
        if (level <= this.getLogLevel()) {
            Object object;
            if (this.m_printBuf == null) {
                object = this;
                synchronized (object) {
                    if (this.m_printBuf == null) {
                        this.m_printBuf = new StringBuilder();
                    }
                }
            }
            object = this.m_printBuf;
            synchronized (object) {
                this.m_printBuf.append(str);
            }
        }
    }

    @Override
    public final void debugPrintln(String str, int level) {
        if (level <= this.getLogLevel()) {
            if (this.m_printBuf != null) {
                this.m_printBuf.append(str);
                this.logOutput(this.m_printBuf.toString(), level);
                this.m_printBuf = null;
            } else {
                this.logOutput(str, level);
            }
        }
    }

    @Override
    public void debugPrintln(Exception ex, int level) {
        if (level <= this.getLogLevel()) {
            Level logLevel = Level.OFF;
            switch (level) {
                case 4: {
                    logLevel = Level.FINEST;
                    break;
                }
                case 3: {
                    logLevel = Level.INFO;
                    break;
                }
                case 2: {
                    logLevel = Level.WARNING;
                    break;
                }
                case 0: {
                    logLevel = Level.SEVERE;
                    break;
                }
                case 1: {
                    logLevel = Level.FINEST;
                }
            }
            Logger.global.log(logLevel, "", ex);
        }
    }

    protected void logOutput(String str, int level) {
        Level logLevel = Level.OFF;
        switch (level) {
            case 4: {
                logLevel = Level.FINEST;
                break;
            }
            case 3: {
                logLevel = Level.INFO;
                break;
            }
            case 2: {
                logLevel = Level.WARNING;
                break;
            }
            case 0: {
                logLevel = Level.SEVERE;
                break;
            }
            case 1: {
                logLevel = Level.FINEST;
            }
        }
        Logger.global.log(logLevel, str);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialize(ConfigElement params, ServerConfiguration config) {
        ConfigElement logProps = params.getChild("Properties");
        if (logProps.getValue() != null) {
            FileInputStream logPropsFile = null;
            try {
                logPropsFile = new FileInputStream(logProps.getValue());
                LogManager.getLogManager().readConfiguration(logPropsFile);
            }
            catch (Exception ex) {
            }
            finally {
                if (logPropsFile != null) {
                    try {
                        logPropsFile.close();
                    }
                    catch (Exception ex) {}
                }
            }
        }
    }
}

