/*
 * Decompiled with CFR 0.152.
 */
package nz.net.ultraq.thymeleaf.decorator;

import java.util.Map;
import java.util.Set;
import nz.net.ultraq.thymeleaf.AbstractContentProcessor;
import nz.net.ultraq.thymeleaf.decorator.Decorator;
import nz.net.ultraq.thymeleaf.decorator.HtmlDocumentDecorator;
import nz.net.ultraq.thymeleaf.decorator.XmlDocumentDecorator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.Arguments;
import org.thymeleaf.Configuration;
import org.thymeleaf.Template;
import org.thymeleaf.TemplateProcessingParameters;
import org.thymeleaf.context.IProcessingContext;
import org.thymeleaf.dom.Document;
import org.thymeleaf.dom.Element;
import org.thymeleaf.processor.ProcessorResult;
import org.thymeleaf.standard.fragment.StandardFragment;
import org.thymeleaf.standard.fragment.StandardFragmentProcessor;

public class DecoratorProcessor
extends AbstractContentProcessor {
    private static final Logger logger = LoggerFactory.getLogger(DecoratorProcessor.class);
    private static final String TEMPLATE_MODE_LEGACYHTML5 = "LEGACYHTML5";
    public static final String PROCESSOR_NAME_DECORATOR = "decorator";

    public DecoratorProcessor() {
        super(PROCESSOR_NAME_DECORATOR);
    }

    protected ProcessorResult processAttribute(Arguments arguments, Element element, String attributeName) {
        if (!(element.getParent() instanceof Document) && !arguments.getTemplateResolution().getTemplateMode().equals(TEMPLATE_MODE_LEGACYHTML5)) {
            logger.error("layout:decorator attribute must appear in the root element of your content page");
            throw new IllegalArgumentException("layout:decorator attribute must appear in the root element of your content page");
        }
        Document document = arguments.getDocument();
        StandardFragment fragment = StandardFragmentProcessor.computeStandardFragmentSpec((Configuration)arguments.getConfiguration(), (IProcessingContext)arguments, (String)element.getAttributeValue(attributeName), (String)"layout", (String)"fragment");
        Template decoratortemplate = arguments.getTemplateRepository().getTemplate(new TemplateProcessingParameters(arguments.getConfiguration(), fragment.getTemplateName(), arguments.getContext()));
        element.removeAttribute(attributeName);
        Document decoratordocument = decoratortemplate.getDocument();
        Element decoratorrootelement = decoratordocument.getFirstElementChild();
        Map<String, Object> fragments = DecoratorProcessor.findFragments(document.getElementChildren());
        XmlDocumentDecorator decorator = decoratorrootelement != null && decoratorrootelement.getOriginalName().equals("html") ? new HtmlDocumentDecorator() : new XmlDocumentDecorator();
        ((Decorator)decorator).decorate(decoratorrootelement, document.getFirstElementChild());
        if (!fragments.isEmpty()) {
            Element newrootelement = document.getFirstElementChild();
            Set nodelocalvariables = newrootelement.getNodeLocalVariableNames();
            for (String fragmentname : fragments.keySet()) {
                if (nodelocalvariables.contains(fragmentname)) continue;
                newrootelement.setNodeLocalVariable(fragmentname, fragments.get(fragmentname));
            }
        }
        return ProcessorResult.OK;
    }
}

