/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.plugins.jira.service;

import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import net.thucydides.plugins.jira.client.SOAPSession;
import net.thucydides.plugins.jira.guice.Injectors;
import net.thucydides.plugins.jira.service.JIRAConfiguration;
import thucydides.plugins.jira.soap.JiraSoapService;

public class JIRAConnection {
    private final JIRAConfiguration configuration;
    private SOAPSession soapSession;

    public JIRAConnection() {
        this((JIRAConfiguration)Injectors.getInjector().getInstance(JIRAConfiguration.class));
    }

    public JIRAConnection(JIRAConfiguration configuration) {
        this.configuration = configuration;
    }

    private SOAPSession getSoapSession() throws MalformedURLException, RemoteException {
        if (this.soapSession == null) {
            this.soapSession = SOAPSession.openConnectionTo(new URL(this.getJiraWebserviceUrl())).usingCredentials(this.getJiraUser(), this.getJiraPassword());
        }
        return this.soapSession;
    }

    public JiraSoapService getJiraSoapService() throws MalformedURLException, RemoteException {
        return this.getSoapSession().getJiraSoapService();
    }

    protected JIRAConfiguration getConfiguration() {
        return this.configuration;
    }

    public String getJiraUser() {
        return this.getConfiguration().getJiraUser();
    }

    public String getJiraPassword() {
        return this.getConfiguration().getJiraPassword();
    }

    public String getJiraWebserviceUrl() {
        return this.getConfiguration().getJiraWebserviceUrl();
    }

    public String getAuthenticationToken() throws MalformedURLException, RemoteException {
        return this.getSoapSession().getAuthenticationToken();
    }

    public String getProject() {
        return this.getConfiguration().getProject();
    }

    public void logout() {
        this.soapSession = null;
    }
}

