/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.plugins.jira.model;

import ch.lambdaj.Lambda;
import ch.lambdaj.function.convert.Converter;
import java.util.List;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.TestResult;
import net.thucydides.plugins.jira.model.NamedTestResult;
import net.thucydides.plugins.jira.model.TestResultComment;

public class JIRACommentBuilder {
    private final boolean wikiRendering;
    private final String testRunNumber;
    private final String reportUrl;
    private final List<NamedTestResult> namedTestResults;
    private static final String NEW_LINE = System.getProperty("line.separator");

    public JIRACommentBuilder(boolean wikiRendering) {
        this(wikiRendering, null);
    }

    public JIRACommentBuilder(boolean wikiRendering, String reportUrl) {
        this(wikiRendering, reportUrl, null, null);
    }

    public JIRACommentBuilder(boolean wikiRendering, String reportUrl, List<TestOutcome> testOutcomes) {
        this(wikiRendering, testOutcomes, reportUrl, null);
    }

    public JIRACommentBuilder(boolean wikiRendering, List<TestOutcome> testOutcomes, String reportUrl, String testRunNumber) {
        this(wikiRendering, reportUrl, JIRACommentBuilder.namedTestResultsFrom(testOutcomes), testRunNumber);
    }

    private static List<NamedTestResult> namedTestResultsFrom(List<TestOutcome> testOutcomes) {
        return Lambda.convert(testOutcomes, JIRACommentBuilder.toNamedTestResults());
    }

    private static Converter<TestOutcome, NamedTestResult> toNamedTestResults() {
        return new Converter<TestOutcome, NamedTestResult>(){

            public NamedTestResult convert(TestOutcome from) {
                return new NamedTestResult(from.getTitle(), from.getResult());
            }
        };
    }

    public JIRACommentBuilder(boolean wikiRendering, String reportUrl, List<NamedTestResult> namedTestResults, String testRunNumber) {
        this.reportUrl = reportUrl;
        this.namedTestResults = namedTestResults;
        this.testRunNumber = testRunNumber;
        this.wikiRendering = wikiRendering;
    }

    public String asText() {
        StringBuilder commentBuilder = new StringBuilder();
        this.addLine(commentBuilder, this.bold("Thucydides Test Results"));
        if (this.wikiRendering) {
            this.addLine(commentBuilder, "[Test report|" + this.reportUrl + "]");
        } else {
            this.addLine(commentBuilder, "Test Report: " + this.reportUrl);
        }
        if (this.testRunNumber != null) {
            this.addLine(commentBuilder, "Test Run: " + this.testRunNumber);
        }
        this.addLineForEachTest(commentBuilder);
        return commentBuilder.toString();
    }

    private String bold(String text) {
        return this.wikiRendering ? "*" + text + "*" : text;
    }

    private void addLineForEachTest(StringBuilder commentBuilder) {
        if (this.namedTestResults != null) {
            for (NamedTestResult testResult : this.namedTestResults) {
                this.addLine(commentBuilder, "  - " + testResult.getTestName() + ": " + testResult.getTestResult() + " " + this.resultIconFor(testResult.getTestResult()));
            }
        }
    }

    private String resultIconFor(TestResult testResult) {
        if (!this.wikiRendering) {
            return "";
        }
        switch (testResult) {
            case SUCCESS: {
                return ": (/)";
            }
            case FAILURE: {
                return ": (x)";
            }
            case ERROR: {
                return ": (x)";
            }
            case PENDING: {
                return ": (!)";
            }
            case SKIPPED: {
                return ": (!)";
            }
            case IGNORED: {
                return ": (!)";
            }
        }
        return ": (?)";
    }

    private void addLine(StringBuilder commentBuilder, String line) {
        commentBuilder.append(line).append(NEW_LINE);
    }

    public JIRACommentBuilder withResults(List<TestOutcome> testOutcomes) {
        return new JIRACommentBuilder(this.wikiRendering, this.reportUrl, testOutcomes);
    }

    public JIRACommentBuilder withTestRun(String testRunNumber) {
        return new JIRACommentBuilder(this.wikiRendering, this.reportUrl, this.namedTestResults, testRunNumber);
    }

    public JIRACommentBuilder withReportUrl(String reportUrl) {
        return new JIRACommentBuilder(this.wikiRendering, reportUrl, this.namedTestResults, this.testRunNumber);
    }

    public JIRACommentBuilder withNamedResults(List<NamedTestResult> namedTestResults) {
        return new JIRACommentBuilder(this.wikiRendering, this.reportUrl, namedTestResults, this.testRunNumber);
    }

    public TestResultComment asComment() {
        return new TestResultComment(this.reportUrl, this.testRunNumber, this.namedTestResults, this.wikiRendering);
    }
}

