/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.plugins.jira;

import ch.lambdaj.Lambda;
import ch.lambdaj.function.convert.Converter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentMap;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.TestResult;
import net.thucydides.core.model.TestResultList;

public class TestResultTally {
    private final ConcurrentMap<String, List<TestOutcome>> testOutcomesTally = Maps.newConcurrentMap();

    public synchronized void recordResult(String issueNumber, TestOutcome outcome) {
        this.getTestOutcomeListForIssue(issueNumber).add(outcome);
    }

    public List<TestOutcome> getTestOutcomesForIssue(String issueNumber) {
        return ImmutableList.copyOf(this.getTestOutcomeListForIssue(issueNumber));
    }

    protected List<TestOutcome> getTestOutcomeListForIssue(String issueNumber) {
        List resultTallyForIssue = (List)this.testOutcomesTally.get(issueNumber);
        if (resultTallyForIssue == null) {
            this.testOutcomesTally.putIfAbsent(issueNumber, new Vector());
        }
        return (List)this.testOutcomesTally.get(issueNumber);
    }

    public TestResult getResultForIssue(String issueNumber) {
        List testOutcomesForThisIssue = (List)this.testOutcomesTally.get(issueNumber);
        TestResultList overallResults = TestResultList.of((List)Lambda.convert((Object)testOutcomesForThisIssue, this.toTestResults()));
        return overallResults.getOverallResult();
    }

    private Converter<TestOutcome, TestResult> toTestResults() {
        return new Converter<TestOutcome, TestResult>(){

            public TestResult convert(TestOutcome from) {
                return from.getResult();
            }
        };
    }

    public Set<String> getIssues() {
        return this.testOutcomesTally.keySet();
    }
}

