/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.plugins.jira;

import ch.lambdaj.Lambda;
import ch.lambdaj.function.convert.Converter;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.inject.Inject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.model.DataTable;
import net.thucydides.core.model.Stories;
import net.thucydides.core.model.Story;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.TestResult;
import net.thucydides.core.steps.ExecutedStepDescription;
import net.thucydides.core.steps.StepFailure;
import net.thucydides.core.steps.StepListener;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.plugins.jira.TestResultTally;
import net.thucydides.plugins.jira.guice.Injectors;
import net.thucydides.plugins.jira.model.IssueComment;
import net.thucydides.plugins.jira.model.IssueTracker;
import net.thucydides.plugins.jira.model.TestResultComment;
import net.thucydides.plugins.jira.service.JIRAConfiguration;
import net.thucydides.plugins.jira.service.NoSuchIssueException;
import net.thucydides.plugins.jira.workflow.ClasspathWorkflowLoader;
import net.thucydides.plugins.jira.workflow.Workflow;
import net.thucydides.plugins.jira.workflow.WorkflowLoader;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraListener
implements StepListener {
    private static final String BUILD_ID_PROPERTY = "build.id";
    private final IssueTracker issueTracker;
    private Class<?> currentTestCase;
    public Story currentStory;
    private static final Logger LOGGER = LoggerFactory.getLogger(JiraListener.class);
    private final JIRAConfiguration configuration;
    private Workflow workflow;
    WorkflowLoader loader;
    private final EnvironmentVariables environmentVariables;
    private final String projectPrefix;
    private final TestResultTally resultTally;
    static int DEFAULT_MAX_THREADS = 4;
    private final ListeningExecutorService executorService;
    private final AtomicInteger queueSize = new AtomicInteger(0);

    @Inject
    public JiraListener(IssueTracker issueTracker, EnvironmentVariables environmentVariables, WorkflowLoader loader) {
        this.issueTracker = issueTracker;
        this.environmentVariables = environmentVariables;
        this.projectPrefix = environmentVariables.getProperty(ThucydidesSystemProperty.JIRA_PROJECT.getPropertyName());
        this.configuration = (JIRAConfiguration)Injectors.getInjector().getInstance(JIRAConfiguration.class);
        this.loader = loader;
        this.resultTally = new TestResultTally();
        this.workflow = loader.load();
        this.executorService = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(this.getMaxJobs()));
        this.logStatus(environmentVariables);
    }

    private int getMaxJobs() {
        return this.environmentVariables.getPropertyAsInteger("jira.max.threads", Integer.valueOf(DEFAULT_MAX_THREADS));
    }

    private void logStatus(EnvironmentVariables environmentVariables) {
        String jiraUrl = environmentVariables.getProperty(ThucydidesSystemProperty.JIRA_URL.getPropertyName());
        String reportUrl = environmentVariables.getProperty(ThucydidesSystemProperty.THUCYDIDES_PUBLIC_URL.getPropertyName());
        LOGGER.debug("JIRA LISTENER STATUS");
        LOGGER.debug("JIRA URL: {} ", (Object)jiraUrl);
        LOGGER.debug("REPORT URL: {} ", (Object)reportUrl);
        LOGGER.debug("WORKFLOW ACTIVE: {} ", (Object)this.workflow.isActive());
    }

    protected boolean shouldUpdateIssues() {
        String jiraUrl = this.environmentVariables.getProperty(ThucydidesSystemProperty.JIRA_URL.getPropertyName());
        String reportUrl = this.environmentVariables.getProperty(ThucydidesSystemProperty.THUCYDIDES_PUBLIC_URL.getPropertyName());
        if (this.workflow.isActive()) {
            LOGGER.debug("WORKFLOW TRANSITIONS: {}", (Object)this.workflow.getTransitions());
        }
        return !StringUtils.isEmpty((CharSequence)jiraUrl) && !StringUtils.isEmpty((CharSequence)reportUrl);
    }

    protected boolean shouldUpdateWorkflow() {
        Boolean workflowUpdatesEnabled = Boolean.valueOf(this.environmentVariables.getProperty(ClasspathWorkflowLoader.ACTIVATE_WORKFLOW_PROPERTY));
        return workflowUpdatesEnabled;
    }

    public JiraListener() {
        this((IssueTracker)Injectors.getInjector().getInstance(IssueTracker.class), (EnvironmentVariables)Injectors.getInjector().getProvider(EnvironmentVariables.class).get(), (WorkflowLoader)Injectors.getInjector().getInstance(WorkflowLoader.class));
    }

    protected IssueTracker getIssueTracker() {
        return this.issueTracker;
    }

    protected Workflow getWorkflow() {
        return this.workflow;
    }

    public void testSuiteStarted(Class<?> testCase) {
        this.currentTestCase = testCase;
        this.currentStory = null;
    }

    public void testSuiteStarted(Story story) {
        this.currentStory = story;
        this.currentTestCase = null;
    }

    public void testStarted(String testName) {
    }

    public void testFinished(TestOutcome result) {
        if (this.shouldUpdateIssues()) {
            List<String> issues = this.addPrefixesIfRequired(this.stripInitialHashesFrom(this.issueReferencesIn(result)));
            this.tallyResults(result, issues);
        }
    }

    public void testRetried() {
    }

    private void tallyResults(TestOutcome result, List<String> issues) {
        for (String issue : issues) {
            this.resultTally.recordResult(issue, result);
        }
    }

    public void testSuiteFinished() {
        if (this.shouldUpdateIssues()) {
            Set<String> issues = this.resultTally.getIssues();
            this.updateIssueStatus(issues);
        }
    }

    private void updateIssueStatus(Set<String> issues) {
        this.queueSize.set(issues.size());
        for (final String issue : issues) {
            ListenableFuture future = this.executorService.submit((Callable)new Callable<String>(){

                @Override
                public String call() throws Exception {
                    return issue;
                }
            });
            future.addListener(new Runnable(){

                @Override
                public void run() {
                    JiraListener.this.logIssueTracking(issue);
                    if (!JiraListener.this.dryRun()) {
                        JiraListener.this.updateIssue(issue, JiraListener.this.resultTally.getTestOutcomesForIssue(issue));
                        JiraListener.this.queueSize.decrementAndGet();
                    }
                }
            }, (Executor)MoreExecutors.sameThreadExecutor());
            future.addListener(new Runnable(){

                @Override
                public void run() {
                    JiraListener.this.queueSize.decrementAndGet();
                }
            }, (Executor)this.executorService);
        }
        this.waitTillUpdatesDone(this.queueSize);
    }

    private void waitTillUpdatesDone(AtomicInteger counter) {
        while (counter.get() > 0) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private List<String> issueReferencesIn(TestOutcome result) {
        return result.getIssues();
    }

    private void updateIssue(String issueId, List<TestOutcome> testOutcomes) {
        try {
            TestResultComment testResultComment = this.newOrUpdatedCommentFor(issueId, testOutcomes);
            if (this.getWorkflow().isActive() && this.shouldUpdateWorkflow()) {
                this.updateIssueStatusFor(issueId, testResultComment.getOverallResult());
            }
        }
        catch (NoSuchIssueException noSuchIssueException) {
            LOGGER.error("No JIRA issue found with ID {}", (Object)issueId);
        }
    }

    private void updateIssueStatusFor(String issueId, TestResult testResult) {
        LOGGER.info("Updating status for issue {} with test result {}", (Object)issueId, (Object)testResult);
        String currentStatus = this.issueTracker.getStatusFor(issueId);
        LOGGER.info("Issue {} currently has status '{}'", (Object)issueId, (Object)currentStatus);
        List<String> transitions = this.getWorkflow().getTransitions().forTestResult(testResult).whenIssueIs(currentStatus);
        LOGGER.info("Found transitions {} for issue {}", transitions, (Object)issueId);
        for (String transition : transitions) {
            this.issueTracker.doTransition(issueId, transition);
        }
    }

    private TestResultComment newOrUpdatedCommentFor(String issueId, List<TestOutcome> testOutcomes) {
        TestResultComment testResultComment;
        LOGGER.info("Updating comments for issue {}", (Object)issueId);
        LOGGER.info("WIKI Rendering activated: {}", (Object)this.isWikiRenderedActive());
        List<IssueComment> comments = this.issueTracker.getCommentsFor(issueId);
        IssueComment existingComment = this.findExistingThucydidesCommentIn(comments);
        String testRunNumber = this.environmentVariables.getProperty(BUILD_ID_PROPERTY);
        if (existingComment == null) {
            testResultComment = TestResultComment.comment(this.isWikiRenderedActive()).withResults(testOutcomes).withReportUrl(this.linkToReport(testOutcomes)).withTestRun(testRunNumber).asComment();
            this.issueTracker.addComment(issueId, testResultComment.asText());
        } else {
            testResultComment = TestResultComment.fromText(existingComment.getText()).withWikiRendering(this.isWikiRenderedActive()).withUpdatedTestResults(testOutcomes).withUpdatedReportUrl(this.linkToReport(testOutcomes)).withUpdatedTestRunNumber(testRunNumber);
            IssueComment updatedComment = new IssueComment(existingComment.getId(), testResultComment.asText(), existingComment.getAuthor());
            this.issueTracker.updateComment(updatedComment);
        }
        return testResultComment;
    }

    private IssueComment findExistingThucydidesCommentIn(List<IssueComment> comments) {
        for (IssueComment comment : comments) {
            if (!comment.getText().contains("Thucydides Test Results")) continue;
            return comment;
        }
        return null;
    }

    private void logIssueTracking(String issueId) {
        if (this.dryRun()) {
            LOGGER.info("--- DRY RUN ONLY: JIRA WILL NOT BE UPDATED ---");
        }
        LOGGER.info("Updating JIRA issue: " + issueId);
        LOGGER.info("JIRA server: " + this.issueTracker.toString());
    }

    private boolean dryRun() {
        return Boolean.valueOf(this.environmentVariables.getProperty("thucydides.skip.jira.updates"));
    }

    private String linkToReport(List<TestOutcome> testOutcomes) {
        TestOutcome firstTestOutcome = testOutcomes.get(0);
        String reportUrl = this.environmentVariables.getProperty(ThucydidesSystemProperty.THUCYDIDES_PUBLIC_URL.getPropertyName());
        String reportName = String.valueOf(firstTestOutcome.getReportName()) + ".html";
        return this.formatTestResultsLink(reportUrl, reportName);
    }

    public String formatTestResultsLink(String reportUrl, String reportName) {
        return String.valueOf(reportUrl) + "/" + reportName;
    }

    private boolean isWikiRenderedActive() {
        return this.configuration.isWikiRenderedActive();
    }

    private Story storyUnderTest() {
        if (this.currentTestCase != null) {
            return Stories.findStoryFrom(this.currentTestCase);
        }
        return this.currentStory;
    }

    private List<String> addPrefixesIfRequired(List<String> issueNumbers) {
        return Lambda.convert(issueNumbers, this.toIssueNumbersWithPrefixes());
    }

    private Converter<String, String> toIssueNumbersWithPrefixes() {
        return new Converter<String, String>(){

            public String convert(String issueNumber) {
                if (StringUtils.isEmpty((CharSequence)JiraListener.this.projectPrefix)) {
                    return issueNumber;
                }
                if (issueNumber.startsWith(JiraListener.this.projectPrefix)) {
                    return issueNumber;
                }
                return String.valueOf(JiraListener.this.projectPrefix) + "-" + issueNumber;
            }
        };
    }

    private List<String> stripInitialHashesFrom(List<String> issueNumbers) {
        return Lambda.convert(issueNumbers, this.toIssueNumbersWithoutHashes());
    }

    private Converter<String, String> toIssueNumbersWithoutHashes() {
        return new Converter<String, String>(){

            public String convert(String issueNumber) {
                if (issueNumber.startsWith("#")) {
                    return issueNumber.substring(1);
                }
                return issueNumber;
            }
        };
    }

    public void stepStarted(ExecutedStepDescription executedStepDescription) {
    }

    public void skippedStepStarted(ExecutedStepDescription description) {
    }

    public void stepFailed(StepFailure stepFailure) {
    }

    public void lastStepFailed(StepFailure stepFailure) {
    }

    public void stepIgnored() {
    }

    public void stepIgnored(String s) {
    }

    public void stepPending() {
    }

    public void stepPending(String s) {
    }

    public void assumptionViolated(String s) {
    }

    public void stepFinished() {
    }

    public void testFailed(TestOutcome testOutcome, Throwable cause) {
    }

    public void testIgnored() {
    }

    public void testSkipped() {
    }

    public void testPending() {
    }

    public void notifyScreenChange() {
    }

    public void useExamplesFrom(DataTable dataTable) {
    }

    public void exampleStarted(Map<String, String> stringStringMap) {
    }

    public void exampleStarted() {
    }

    public void exampleFinished() {
    }
}

