/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.rdf.model;

import org.coode.owlapi.rdf.model.RDFNode;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.NodeID;

public class RDFResourceNode
extends RDFNode
implements Comparable<RDFNode> {
    private IRI iri;
    private int anonId;

    public RDFResourceNode(IRI iri) {
        this.iri = iri;
    }

    public RDFResourceNode(int anonId) {
        this.anonId = anonId;
    }

    @Override
    public IRI getIRI() {
        return this.iri;
    }

    public int getId() {
        return this.anonId;
    }

    @Override
    public boolean isLiteral() {
        return false;
    }

    @Override
    public boolean isAnonymous() {
        return this.iri == null;
    }

    public int hashCode() {
        int hashCode = 17;
        hashCode = hashCode * 37 + (this.iri == null ? this.anonId : this.iri.hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RDFResourceNode)) {
            return false;
        }
        RDFResourceNode other = (RDFResourceNode)obj;
        if (this.iri != null) {
            if (other.iri != null) {
                return other.iri.equals((Object)this.iri);
            }
            return false;
        }
        return other.anonId == this.anonId;
    }

    public String toString() {
        return this.iri != null ? "<" + this.iri.toString() + ">" : NodeID.nodeString((int)this.anonId);
    }

    protected Comparable id() {
        return (Comparable)(this.iri != null ? this.iri : Integer.valueOf(this.anonId));
    }

    @Override
    public int compareTo(RDFNode b) {
        boolean anonB;
        if (b.isLiteral()) {
            return 1;
        }
        if (this.equals(b)) {
            return 0;
        }
        int diff = 0;
        boolean anonA = this.isAnonymous();
        diff = anonA == (anonB = b.isAnonymous()) ? this.id().compareTo(((RDFResourceNode)b).id()) : (!anonA ? -1 : 1);
        return diff;
    }
}

