/*
 * Decompiled with CFR 0.152.
 */
package net.kaczmarzyk.spring.data.jpa.domain;

import java.util.Arrays;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.springframework.data.jpa.domain.Specification;

public class JoinFetch<T>
implements Specification<T> {
    private List<String> pathsToFetch;
    private JoinType joinType;

    public JoinFetch(String[] pathsToFetch, JoinType joinType) {
        this.pathsToFetch = Arrays.asList(pathsToFetch);
        this.joinType = joinType;
    }

    public Predicate toPredicate(Root<T> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
        if (!Number.class.isAssignableFrom(query.getResultType())) {
            for (String path : this.pathsToFetch) {
                root.fetch(path, this.joinType);
            }
        }
        return null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.joinType == null ? 0 : this.joinType.hashCode());
        result = 31 * result + (this.pathsToFetch == null ? 0 : this.pathsToFetch.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JoinFetch other = (JoinFetch)obj;
        if (this.joinType != other.joinType) {
            return false;
        }
        return !(this.pathsToFetch == null ? other.pathsToFetch != null : !this.pathsToFetch.equals(other.pathsToFetch));
    }
}

