/*
 * Decompiled with CFR 0.152.
 */
package net.kaczmarzyk.spring.data.jpa.domain;

import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import net.kaczmarzyk.spring.data.jpa.domain.PathSpecification;
import net.kaczmarzyk.spring.data.jpa.utils.Converter;
import net.kaczmarzyk.spring.data.jpa.utils.QueryContext;

public class Equal<T>
extends PathSpecification<T> {
    protected String expectedValue;
    private Converter converter;

    public Equal(QueryContext queryContext, String path, String[] httpParamValues, Converter converter) {
        super(queryContext, path);
        if (httpParamValues == null || httpParamValues.length != 1) {
            throw new IllegalArgumentException();
        }
        this.expectedValue = httpParamValues[0];
        this.converter = converter;
    }

    public Predicate toPredicate(Root<T> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
        Class typeOnPath = this.path(root).getJavaType();
        return cb.equal(this.path(root), this.converter.convert(this.expectedValue, typeOnPath));
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.converter == null ? 0 : this.converter.hashCode());
        result = 31 * result + (this.expectedValue == null ? 0 : this.expectedValue.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Equal other = (Equal)obj;
        if (this.converter == null ? other.converter != null : !this.converter.equals(other.converter)) {
            return false;
        }
        return !(this.expectedValue == null ? other.expectedValue != null : !this.expectedValue.equals(other.expectedValue));
    }

    public String toString() {
        return "Equal [expectedValue=" + this.expectedValue + ", converter=" + this.converter + "]";
    }
}

