/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.service.services.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import javax.annotation.Resource;
import nc.ird.cantharella.data.exceptions.UnexpectedException;
import nc.ird.cantharella.data.model.Extraction;
import nc.ird.cantharella.data.model.Lot;
import nc.ird.cantharella.data.model.Molecule;
import nc.ird.cantharella.data.model.Purification;
import nc.ird.cantharella.data.model.ResultatTestBio;
import nc.ird.cantharella.data.model.Specimen;
import nc.ird.cantharella.data.model.Station;
import nc.ird.cantharella.data.model.Utilisateur;
import nc.ird.cantharella.service.model.SearchBean;
import nc.ird.cantharella.service.model.SearchResult;
import nc.ird.cantharella.service.services.LotService;
import nc.ird.cantharella.service.services.SearchService;
import nc.ird.cantharella.service.services.SpecimenService;
import nc.ird.cantharella.service.services.StationService;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.queryParser.MultiFieldQueryParser;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.ReaderUtil;
import org.apache.lucene.util.Version;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.MassIndexer;
import org.hibernate.search.Search;
import org.hibernate.search.SearchFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SearchServiceImpl
implements SearchService {
    private static final Logger LOG = LoggerFactory.getLogger(SearchServiceImpl.class);
    @Resource
    private SessionFactory sessionFactory;
    @Autowired
    private LotService lotService;
    @Autowired
    private StationService stationService;
    @Autowired
    private SpecimenService specimenService;

    @Override
    public void reIndex() {
        long before = System.currentTimeMillis();
        if (LOG.isInfoEnabled()) {
            LOG.info("Starting full rebuild on lucene index");
        }
        Session session = this.sessionFactory.getCurrentSession();
        FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
        try {
            MassIndexer indexer = fullTextSession.createIndexer(new Class[0]);
            indexer.batchSizeToLoadObjects(1);
            indexer.threadsToLoadObjects(1);
            indexer.threadsForSubsequentFetching(1);
            indexer.startAndWait();
            if (LOG.isInfoEnabled()) {
                long after = System.currentTimeMillis();
                LOG.info("Lucene index rebuilded in " + (after - before) + " ms");
            }
        }
        catch (InterruptedException ex) {
            throw new UnexpectedException("Can't rebuild index", (Exception)ex);
        }
    }

    @Override
    public SearchResult search(SearchBean search, Utilisateur utilisateur) {
        SearchResult result = new SearchResult();
        Session session = this.sessionFactory.getCurrentSession();
        FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
        try {
            String strQuery = "";
            if (search.getQuery() != null) {
                strQuery = strQuery + search.getQuery();
            }
            strQuery = strQuery + " ";
            if (search.getCountry() != null) {
                strQuery = strQuery + search.getCountry();
            }
            strQuery = strQuery.trim();
            List specimens = Collections.EMPTY_LIST;
            List lots = Collections.EMPTY_LIST;
            List extractions = Collections.EMPTY_LIST;
            List purifications = Collections.EMPTY_LIST;
            List resultatTestBios = Collections.EMPTY_LIST;
            List resultatStations = Collections.EMPTY_LIST;
            List resultatMolecules = Collections.EMPTY_LIST;
            if (!strQuery.isEmpty()) {
                org.hibernate.Query hibSpecimen = this.getQuery(fullTextSession, Specimen.class, strQuery, utilisateur);
                org.hibernate.Query hibLot = this.getQuery(fullTextSession, Lot.class, strQuery, utilisateur);
                org.hibernate.Query hibExtraction = this.getQuery(fullTextSession, Extraction.class, strQuery, utilisateur);
                org.hibernate.Query hibPurification = this.getQuery(fullTextSession, Purification.class, strQuery, utilisateur);
                org.hibernate.Query hibResultatTestBio = this.getQuery(fullTextSession, ResultatTestBio.class, strQuery, utilisateur);
                org.hibernate.Query hibStation = this.getQuery(fullTextSession, Station.class, strQuery, utilisateur);
                org.hibernate.Query hibMolecule = this.getQuery(fullTextSession, Molecule.class, strQuery, utilisateur);
                specimens = hibSpecimen.list();
                lots = hibLot.list();
                extractions = hibExtraction.list();
                purifications = hibPurification.list();
                resultatTestBios = hibResultatTestBio.list();
                resultatStations = hibStation.list();
                resultatMolecules = hibMolecule.list();
            }
            result.setSpecimens(specimens);
            result.setLots(lots);
            result.setExtractions(extractions);
            result.setPurifications(purifications);
            result.setResultatTestBios(resultatTestBios);
            result.setStations(resultatStations);
            result.setMolecules(resultatMolecules);
            result = this.filterResults(result, utilisateur);
        }
        catch (ParseException ex) {
            throw new UnexpectedException("Can't parse query", (Exception)((Object)ex));
        }
        return result;
    }

    protected org.hibernate.Query getQuery(FullTextSession fullTextSession, Class<?> clazz, String strQuery, Utilisateur utilisateur) throws ParseException {
        SearchFactory searchFactory = fullTextSession.getSearchFactory();
        IndexReader reader = searchFactory.getIndexReaderAccessor().open(new Class[]{clazz});
        FieldInfos fieldInfos = ReaderUtil.getMergedFieldInfos((IndexReader)reader);
        ArrayList<String> fieldList = new ArrayList<String>();
        for (int i = 0; i < fieldInfos.size(); ++i) {
            String fieldName = fieldInfos.fieldName(i);
            if (fieldName.startsWith("id") || fieldName.contains(".id")) continue;
            fieldList.add(fieldName);
        }
        Analyzer analyzer = searchFactory.getAnalyzer(clazz);
        MultiFieldQueryParser parser = new MultiFieldQueryParser(Version.LUCENE_36, fieldList.toArray(new String[fieldList.size()]), analyzer);
        searchFactory.getIndexReaderAccessor().close(reader);
        parser.setAllowLeadingWildcard(true);
        parser.setDefaultOperator(QueryParser.Operator.AND);
        Query query = parser.parse(strQuery);
        FullTextQuery hibQuery = fullTextSession.createFullTextQuery(query, new Class[]{clazz});
        return hibQuery;
    }

    private SearchResult filterResults(SearchResult result, Utilisateur utilisateur) {
        if (utilisateur.getTypeDroit() == Utilisateur.TypeDroit.ADMINISTRATEUR) {
            return result;
        }
        ArrayList campagnes = new ArrayList();
        campagnes.addAll(utilisateur.getCampagnesCreees());
        campagnes.addAll(utilisateur.getCampagnesDroits().keySet());
        ArrayList lots = new ArrayList();
        lots.addAll(utilisateur.getLotsCrees());
        lots.addAll(utilisateur.getLotsDroits().keySet());
        Iterator<Lot> itLots = result.getLots().iterator();
        while (itLots.hasNext()) {
            Lot lot = itLots.next();
            if (this.lotService.isLotAccessibleByUser(lot, utilisateur)) continue;
            itLots.remove();
        }
        Iterator<Extraction> itExtractions = result.getExtractions().iterator();
        while (itExtractions.hasNext()) {
            Extraction extraction = itExtractions.next();
            Lot lot = extraction.getLot();
            if (this.lotService.isLotAccessibleByUser(lot, utilisateur)) continue;
            itExtractions.remove();
        }
        Iterator<Purification> itPurifications = result.getPurifications().iterator();
        while (itPurifications.hasNext()) {
            Purification purification = itPurifications.next();
            Lot lot = purification.getLotSource();
            if (this.lotService.isLotAccessibleByUser(lot, utilisateur)) continue;
            itPurifications.remove();
        }
        Iterator<ResultatTestBio> itResultatTestBios = result.getResultatTestBios().iterator();
        while (itResultatTestBios.hasNext()) {
            ResultatTestBio resultatTestBio = itResultatTestBios.next();
            Lot lot = resultatTestBio.getLotSource();
            if (resultatTestBio.getTypeResultat() == ResultatTestBio.TypeResultat.PRODUIT && this.lotService.isLotAccessibleByUser(lot, utilisateur)) continue;
            itResultatTestBios.remove();
        }
        SortedSet<Station> userStations = this.stationService.listStationsForUser(utilisateur);
        result.getStations().retainAll(userStations);
        SortedSet<Specimen> userSpecimens = this.specimenService.listSpecimensForUser(utilisateur);
        result.getSpecimens().retainAll(userSpecimens);
        return result;
    }
}

