/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.service.model;

import java.util.List;
import nc.ird.cantharella.data.model.Document;
import nc.ird.cantharella.data.model.Extrait;
import nc.ird.cantharella.data.model.Fraction;
import nc.ird.cantharella.data.model.Lot;
import nc.ird.cantharella.data.model.Molecule;
import nc.ird.cantharella.data.model.MoleculeProvenance;
import nc.ird.cantharella.data.model.Produit;
import nc.ird.cantharella.data.model.utils.DocumentAttachable;

public class MoleculeProvenanceBean
implements DocumentAttachable {
    protected Molecule molecule;
    protected MoleculeProvenance provenance;

    public MoleculeProvenanceBean(Molecule molecule) {
        this.molecule = molecule;
    }

    public MoleculeProvenanceBean(MoleculeProvenance provenance) {
        this(provenance.getMolecule());
        this.provenance = provenance;
    }

    public Integer getIdMolecule() {
        return this.molecule.getIdMolecule();
    }

    public Molecule getMolecule() {
        return this.molecule;
    }

    public MoleculeProvenance getMoleculeProvenance() {
        return this.provenance;
    }

    public Lot getLot() {
        Lot result = null;
        if (this.provenance != null) {
            Produit produit = this.provenance.getProduit();
            if (produit instanceof Fraction) {
                Fraction fraction = (Fraction)produit;
                result = fraction.getPurification().getLotSource();
            } else {
                Extrait extrait = (Extrait)produit;
                result = extrait.getExtraction().getLot();
            }
        }
        return result;
    }

    public List<Document> getDocuments() {
        return this.molecule.getDocuments();
    }

    public void addDocument(Document document) {
        this.molecule.addDocument(document);
    }

    public void removeDocument(Document document) {
        this.molecule.removeDocument(document);
    }
}

