/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.bits;

import it.unimi.dsi.bits.AbstractBitVector;
import it.unimi.dsi.bits.BitVector;
import it.unimi.dsi.bits.LongArrayBitVector;
import it.unimi.dsi.fastutil.BigArrays;
import it.unimi.dsi.fastutil.longs.LongBigArrays;
import it.unimi.dsi.fastutil.longs.LongBigList;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class LongBigArrayBitVector
extends AbstractBitVector
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 2L;
    public static final boolean CHECKS = false;
    protected long length;
    protected transient long[][] bits;

    public static final long words(long size) {
        return size + 64L - 1L >>> LongArrayBitVector.LOG2_BITS_PER_WORD;
    }

    public static final long bits(long word) {
        assert (word >= 0L);
        return word << LongArrayBitVector.LOG2_BITS_PER_WORD;
    }

    public static final long word(long index) {
        return index >>> LongArrayBitVector.LOG2_BITS_PER_WORD;
    }

    protected LongBigArrayBitVector(long capacity) {
        this.bits = capacity > 0L ? LongBigArrays.newBigArray((long)LongBigArrayBitVector.words(capacity)) : LongBigArrays.EMPTY_BIG_ARRAY;
    }

    public static LongBigArrayBitVector getInstance(long capacity) {
        return new LongBigArrayBitVector(capacity);
    }

    public static LongBigArrayBitVector getInstance() {
        return new LongBigArrayBitVector(0L);
    }

    public static LongBigArrayBitVector ofLength(long length) {
        LongBigArrayBitVector bv = new LongBigArrayBitVector(length);
        bv.length = length;
        return bv;
    }

    public static LongBigArrayBitVector of(int ... bit) {
        LongBigArrayBitVector bitVector = new LongBigArrayBitVector(bit.length);
        for (int b : bit) {
            if (b != 0 && b != 1) {
                throw new IllegalArgumentException("Illegal bit value: " + b);
            }
            bitVector.add(b);
        }
        return bitVector;
    }

    @Override
    public long length() {
        return this.length;
    }

    public long[][] bigBits() {
        return this.bits;
    }

    public LongBigArrayBitVector ensureCapacity(long numBits) {
        this.bits = BigArrays.grow((long[][])this.bits, (long)LongBigArrayBitVector.words(numBits), (long)LongBigArrayBitVector.words(this.length));
        return this;
    }

    @Override
    public LongBigArrayBitVector length(long newLength) {
        this.bits = BigArrays.ensureCapacity((long[][])this.bits, (long)LongBigArrayBitVector.words(newLength), (long)LongBigArrayBitVector.words(this.length));
        long oldLength = this.length;
        if (newLength < oldLength) {
            this.fill(newLength, oldLength, false);
        }
        this.length = newLength;
        return this;
    }

    @Override
    public void fill(boolean value) {
        long fullWords = LongBigArrayBitVector.word(this.length);
        BigArrays.fill((long[][])this.bits, (long)0L, (long)fullWords, (long)(value ? -1L : 0L));
        if (!LongArrayBitVector.round(this.length)) {
            if (value) {
                BigArrays.set((long[][])this.bits, (long)fullWords, (long)((1L << (int)this.length) - 1L));
            } else {
                BigArrays.set((long[][])this.bits, (long)fullWords, (long)0L);
            }
        }
    }

    public boolean trim() {
        if (BigArrays.length((long[][])this.bits) == LongBigArrayBitVector.words(this.length)) {
            return false;
        }
        this.bits = BigArrays.setLength((long[][])this.bits, (long)LongBigArrayBitVector.words(this.length));
        return true;
    }

    @Override
    public void clear() {
        if (this.length != 0L) {
            BigArrays.fill((long[][])this.bits, (long)0L, (long)LongBigArrayBitVector.words(this.length), (long)0L);
        }
        this.length = 0L;
    }

    @Override
    public LongBigArrayBitVector copy() {
        LongBigArrayBitVector copy = new LongBigArrayBitVector(this.length);
        copy.length = this.length;
        BigArrays.copy((long[][])this.bits, (long)0L, (long[][])copy.bits, (long)0L, (long)LongBigArrayBitVector.words(this.length));
        return copy;
    }

    @Override
    public LongBigArrayBitVector fast() {
        return this;
    }

    public static LongBigArrayBitVector copy(BitVector bv) {
        long length = bv.length();
        LongBigArrayBitVector copy = new LongBigArrayBitVector(length);
        long fullBits = length & 0xFFFFFFFFFFFFFFC0L;
        for (long i = 0L; i < fullBits; i += 64L) {
            BigArrays.set((long[][])copy.bits, (long)LongBigArrayBitVector.word(i), (long)bv.getLong(i, i + 64L));
        }
        if (!LongArrayBitVector.round(length)) {
            BigArrays.set((long[][])copy.bits, (long)LongBigArrayBitVector.word(fullBits), (long)bv.getLong(fullBits, length));
        }
        copy.length = length;
        return copy;
    }

    public boolean getBoolean(long index) {
        assert (index >= 0L);
        assert (index < this.length);
        return (BigArrays.get((long[][])this.bits, (long)LongBigArrayBitVector.word(index)) & LongArrayBitVector.mask(index)) != 0L;
    }

    @Override
    public boolean set(long index, boolean value) {
        int displacement;
        boolean oldValue;
        assert (index >= 0L);
        assert (index < this.length);
        long word = LongBigArrayBitVector.word(index);
        long mask = LongArrayBitVector.mask(index);
        int segment = BigArrays.segment((long)word);
        boolean bl = oldValue = (this.bits[segment][displacement = BigArrays.displacement((long)word)] & mask) != 0L;
        if (value != oldValue) {
            long[] lArray = this.bits[segment];
            int n = displacement;
            lArray[n] = lArray[n] ^ mask;
        }
        return oldValue;
    }

    @Override
    public void set(long index) {
        assert (index >= 0L);
        assert (index < this.length);
        long word = LongBigArrayBitVector.word(index);
        long[] lArray = this.bits[BigArrays.segment((long)word)];
        int n = BigArrays.displacement((long)word);
        lArray[n] = lArray[n] | LongArrayBitVector.mask(index);
    }

    @Override
    public void clear(long index) {
        assert (index >= 0L);
        assert (index < this.length);
        long word = LongBigArrayBitVector.word(index);
        long[] lArray = this.bits[BigArrays.segment((long)word)];
        int n = BigArrays.displacement((long)word);
        lArray[n] = lArray[n] & (LongArrayBitVector.mask(index) ^ 0xFFFFFFFFFFFFFFFFL);
    }

    @Override
    public LongBigArrayBitVector append(long value, int width) {
        if (width == 0) {
            return this;
        }
        assert (width == 64 || (value & -1L << width) == 0L);
        long length = this.length;
        long startWord = LongBigArrayBitVector.word(length);
        int segment = BigArrays.segment((long)startWord);
        int displacement = BigArrays.displacement((long)startWord);
        int startBit = LongArrayBitVector.bit(length);
        this.ensureCapacity(length + (long)width);
        if (startBit + width <= 64) {
            long[] lArray = this.bits[segment];
            int n = displacement;
            lArray[n] = lArray[n] | value << startBit;
        } else {
            long[] lArray = this.bits[segment];
            int n = displacement++;
            lArray[n] = lArray[n] | value << startBit;
            if (displacement == 0x8000000) {
                displacement = 0;
                ++segment;
            }
            this.bits[segment][displacement] = value >>> -startBit;
        }
        this.length += (long)width;
        return this;
    }

    @Override
    public boolean add(boolean value) {
        long length = this.length;
        long startWord = LongBigArrayBitVector.word(length);
        int segment = BigArrays.segment((long)startWord);
        int displacement = BigArrays.displacement((long)startWord);
        int startBit = LongArrayBitVector.bit(length);
        this.ensureCapacity(length + 1L);
        if (value) {
            long[] lArray = this.bits[segment];
            int n = displacement;
            lArray[n] = lArray[n] | LongArrayBitVector.mask(startBit);
        }
        ++this.length;
        return true;
    }

    @Override
    public long getLong(long from, long to) {
        assert (0L <= from);
        assert (from <= to);
        assert (to <= this.length);
        long l = 64L - (to - from);
        long startWord = LongBigArrayBitVector.word(from);
        int segment = BigArrays.segment((long)startWord);
        int displacement = BigArrays.displacement((long)startWord);
        int startBit = LongArrayBitVector.bit(from);
        if (l == 64L) {
            return 0L;
        }
        if ((long)startBit <= l) {
            return this.bits[segment][displacement] << (int)(l - (long)startBit) >>> (int)l;
        }
        long result = this.bits[segment][displacement] >>> startBit;
        if (++displacement == 0x8000000) {
            displacement = 0;
            ++segment;
        }
        return result | this.bits[segment][displacement] << (int)(l - (long)startBit) >>> (int)l;
    }

    public static LongBigArrayBitVector wrap(long[][] array, long size) {
        if (size > LongBigArrayBitVector.bits(BigArrays.length((long[][])array))) {
            throw new IllegalArgumentException("The provided array is too short (" + BigArrays.length((long[][])array) + " elements) for the given size (" + size + ")");
        }
        LongBigArrayBitVector result = new LongBigArrayBitVector(0L);
        result.length = size;
        result.bits = array;
        long arrayLength = BigArrays.length((long[][])array);
        long lastWord = LongBigArrayBitVector.word(size);
        if (lastWord < arrayLength && (BigArrays.get((long[][])array, (long)lastWord) & ((1L << (int)size) - 1L ^ 0xFFFFFFFFFFFFFFFFL)) != 0L) {
            throw new IllegalArgumentException("Garbage beyond size in bit array");
        }
        for (long i = lastWord + 1L; i < arrayLength; ++i) {
            if (BigArrays.get((long[][])array, (long)i) == 0L) continue;
            throw new IllegalArgumentException("Garbage beyond size in bit array");
        }
        return result;
    }

    public static LongBigArrayBitVector wrap(long[][] array) {
        return LongBigArrayBitVector.wrap(array, BigArrays.length((long[][])array) * 64L);
    }

    public LongBigArrayBitVector clone() throws CloneNotSupportedException {
        LongBigArrayBitVector copy = (LongBigArrayBitVector)super.clone();
        copy.bits = (long[][])this.bits.clone();
        return copy;
    }

    @Override
    public int hashCode() {
        long h = 0x9E3779B97F4A7C13L ^ this.length;
        long numWords = LongBigArrayBitVector.words(this.length);
        for (long i = 0L; i < numWords; ++i) {
            h ^= (h << 5) + BigArrays.get((long[][])this.bits, (long)i) + (h >>> 2);
        }
        assert ((int)(h >>> 32 ^ h) == super.hashCode());
        return (int)(h >>> 32 ^ h);
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof LongBigArrayBitVector) {
            return this.equals((LongBigArrayBitVector)o);
        }
        return super.equals(o);
    }

    public boolean equals(LongBigArrayBitVector v) {
        if (this.length != v.length()) {
            return false;
        }
        long i = LongBigArrayBitVector.words(this.length);
        while (i-- != 0L) {
            if (BigArrays.get((long[][])this.bits, (long)i) == BigArrays.get((long[][])v.bits, (long)i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public LongBigList asLongBigList(int width) {
        return new LongBigListView(this, width);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        long numWords = LongBigArrayBitVector.words(this.length);
        for (long i = 0L; i < numWords; ++i) {
            s.writeLong(BigArrays.get((long[][])this.bits, (long)i));
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        long numWords = LongBigArrayBitVector.words(this.length);
        this.bits = LongBigArrays.newBigArray((long)numWords);
        for (long i = 0L; i < numWords; ++i) {
            BigArrays.set((long[][])this.bits, (long)i, (long)s.readLong());
        }
    }

    protected static class LongBigListView
    extends AbstractBitVector.LongBigListView {
        private static final long serialVersionUID = 1L;
        private final LongBigArrayBitVector bitVector;

        public LongBigListView(LongBigArrayBitVector bitVector, int width) {
            super(bitVector, width);
            this.bitVector = bitVector;
        }

        public boolean add(long value) {
            this.bitVector.append(value, this.width);
            return true;
        }

        @Override
        public long getLong(long index) {
            long start = index * (long)this.width;
            return this.bitVector.getLong(start, start + (long)this.width);
        }

        public void clear() {
            this.bitVector.clear();
        }

        @Override
        public long set(long index, long value) {
            long oldValue;
            if (this.width == 0) {
                return 0L;
            }
            if (this.width != 64 && value > this.fullMask) {
                throw new IllegalArgumentException("Value too large: " + value);
            }
            this.ensureRestrictedIndex(index);
            long[][] bits = this.bitVector.bits;
            long start = index * (long)this.width;
            long startWord = LongBigArrayBitVector.word(start);
            long endWord = LongBigArrayBitVector.word(start + (long)this.width - 1L);
            int startBit = LongArrayBitVector.bit(start);
            if (startWord == endWord) {
                int segment = BigArrays.segment((long)startWord);
                int displacement = BigArrays.displacement((long)startWord);
                oldValue = bits[segment][displacement] >>> startBit & this.fullMask;
                long[] lArray = bits[segment];
                int n = displacement;
                lArray[n] = lArray[n] & (this.fullMask << startBit ^ 0xFFFFFFFFFFFFFFFFL);
                long[] lArray2 = bits[segment];
                int n2 = displacement;
                lArray2[n2] = lArray2[n2] | value << startBit;
                assert (value == (bits[segment][displacement] >>> startBit & this.fullMask));
            } else {
                int startSegment = BigArrays.segment((long)startWord);
                int startDisplacement = BigArrays.displacement((long)startWord);
                int endSegment = BigArrays.segment((long)endWord);
                int endDisplacement = BigArrays.displacement((long)endWord);
                oldValue = bits[startSegment][startDisplacement] >>> startBit | bits[endSegment][endDisplacement] << -startBit & this.fullMask;
                long[] lArray = bits[startSegment];
                int n = startDisplacement;
                lArray[n] = lArray[n] & (1L << startBit) - 1L;
                long[] lArray3 = bits[startSegment];
                int n3 = startDisplacement;
                lArray3[n3] = lArray3[n3] | value << startBit;
                long[] lArray4 = bits[endSegment];
                int n4 = endDisplacement;
                lArray4[n4] = lArray4[n4] & -(1L << this.width + startBit);
                long[] lArray5 = bits[endSegment];
                int n5 = endDisplacement;
                lArray5[n5] = lArray5[n5] | value >>> -startBit;
                assert (value == (bits[startSegment][startDisplacement] >>> startBit | bits[endSegment][endDisplacement] << -startBit & this.fullMask));
            }
            return oldValue;
        }
    }
}

