/*
 * Decompiled with CFR 0.152.
 */
package brave.context.log4j2;

import brave.internal.HexCodec;
import brave.internal.Nullable;
import brave.propagation.CurrentTraceContext;
import brave.propagation.TraceContext;
import org.apache.logging.log4j.ThreadContext;

public final class ThreadContextCurrentTraceContext
extends CurrentTraceContext {
    final CurrentTraceContext delegate;

    public static ThreadContextCurrentTraceContext create() {
        return ThreadContextCurrentTraceContext.create(CurrentTraceContext.Default.inheritable());
    }

    public static ThreadContextCurrentTraceContext create(CurrentTraceContext delegate) {
        return new ThreadContextCurrentTraceContext(delegate);
    }

    ThreadContextCurrentTraceContext(CurrentTraceContext delegate) {
        if (delegate == null) {
            throw new NullPointerException("delegate == null");
        }
        this.delegate = delegate;
    }

    public TraceContext get() {
        return this.delegate.get();
    }

    public CurrentTraceContext.Scope newScope(@Nullable TraceContext currentSpan) {
        return this.newScope(currentSpan, ThreadContext.get((String)"traceId"), ThreadContext.get((String)"spanId"));
    }

    public CurrentTraceContext.Scope maybeScope(@Nullable TraceContext currentSpan) {
        String previousTraceId = ThreadContext.get((String)"traceId");
        String previousSpanId = ThreadContext.get((String)"spanId");
        if (currentSpan == null) {
            if (previousTraceId == null) {
                return CurrentTraceContext.Scope.NOOP;
            }
            return this.newScope(null, previousTraceId, previousSpanId);
        }
        if (HexCodec.lowerHexEqualsTraceId((CharSequence)previousTraceId, (TraceContext)currentSpan) && HexCodec.lowerHexEqualsUnsignedLong((CharSequence)previousSpanId, (long)currentSpan.spanId())) {
            return CurrentTraceContext.Scope.NOOP;
        }
        return this.newScope(currentSpan, previousTraceId, previousSpanId);
    }

    CurrentTraceContext.Scope newScope(TraceContext currentSpan, final String previousTraceId, final String previousSpanId) {
        final String previousParentId = ThreadContext.get((String)"parentId");
        if (currentSpan != null) {
            this.maybeReplaceTraceContext(currentSpan, previousTraceId, previousParentId, previousSpanId);
        } else {
            ThreadContext.remove((String)"traceId");
            ThreadContext.remove((String)"parentId");
            ThreadContext.remove((String)"spanId");
        }
        final CurrentTraceContext.Scope scope = this.delegate.newScope(currentSpan);
        class ThreadContextCurrentTraceContextScope
        implements CurrentTraceContext.Scope {
            ThreadContextCurrentTraceContextScope() {
            }

            public void close() {
                scope.close();
                ThreadContextCurrentTraceContext.replace("traceId", previousTraceId);
                ThreadContextCurrentTraceContext.replace("parentId", previousParentId);
                ThreadContextCurrentTraceContext.replace("spanId", previousSpanId);
            }
        }
        return new ThreadContextCurrentTraceContextScope();
    }

    void maybeReplaceTraceContext(TraceContext currentSpan, String previousTraceId, @Nullable String previousParentId, String previousSpanId) {
        long parentId;
        boolean sameTraceId = HexCodec.lowerHexEqualsTraceId((CharSequence)previousTraceId, (TraceContext)currentSpan);
        if (!sameTraceId) {
            ThreadContext.put((String)"traceId", (String)currentSpan.traceIdString());
        }
        if ((parentId = currentSpan.parentIdAsLong()) == 0L) {
            ThreadContext.remove((String)"parentId");
        } else {
            boolean sameParentId = HexCodec.lowerHexEqualsUnsignedLong((CharSequence)previousParentId, (long)parentId);
            if (!sameParentId) {
                ThreadContext.put((String)"parentId", (String)HexCodec.toLowerHex((long)parentId));
            }
        }
        boolean sameSpanId = HexCodec.lowerHexEqualsUnsignedLong((CharSequence)previousSpanId, (long)currentSpan.spanId());
        if (!sameSpanId) {
            ThreadContext.put((String)"spanId", (String)HexCodec.toLowerHex((long)currentSpan.spanId()));
        }
    }

    static void replace(String key, @Nullable String value) {
        if (value != null) {
            ThreadContext.put((String)key, (String)value);
        } else {
            ThreadContext.remove((String)key);
        }
    }
}

