/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.i18n.plugin.parser.impl;

import java.io.File;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.xpath.XPath;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.nuiton.i18n.plugin.parser.I18nSourceEntry;
import org.nuiton.i18n.plugin.parser.SourceEntry;
import org.nuiton.i18n.plugin.parser.impl.I18nParseXmlMojoSupport;
import org.nuiton.io.FileUpdater;
import org.nuiton.io.MirroredFileUpdater;

@Mojo(name="parse-xml", defaultPhase=LifecyclePhase.GENERATE_RESOURCES)
public class ParseXmlUserMojo
extends I18nParseXmlMojoSupport {
    @Parameter(property="i18n.xmlBasedir", defaultValue="${basedir}/src/main/resources", required=true)
    private File basedir;
    @Parameter(property="i18n.xmlIncludes", required=true)
    private String includes;
    @Parameter(property="i18n.coreRuleFiles")
    private String coreRuleFile;
    @Parameter(property="i18n.outputGetter", defaultValue="xmlUser.getter", required=true)
    private String outputGetter;

    @Override
    public String[] getDefaultIncludes() {
        return new String[]{this.includes};
    }

    @Override
    public String[] getDefaultExcludes() {
        return I18nSourceEntry.EMPTY_STRING_ARRAY;
    }

    @Override
    public File getDefaultBasedir() {
        return this.basedir;
    }

    @Override
    protected String getCoreRuleFile() {
        return this.coreRuleFile;
    }

    @Override
    protected I18nParseXmlMojoSupport.XmlFileParser newXmlFileParser(File basedir, XPath xpath, DocumentBuilder builder) {
        return new I18nParseXmlMojoSupport.XmlFileParser(this.getLog(), this.encoding, this.getAcceptPattern(), this.rules, xpath, builder, this.namespaces, this.isVerbose()){

            @Override
            public String extract(File file, String i18nString) {
                String s = null;
                if (!i18nString.trim().isEmpty()) {
                    s = i18nString.trim();
                }
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)String.format("%s = %s", i18nString, s));
                }
                return s;
            }
        };
    }

    @Override
    protected String getOutGetter() {
        return this.outputGetter;
    }

    @Override
    public FileUpdater newFileUpdater(SourceEntry entry) {
        return new MirroredFileUpdater("", "", entry.getBasedir(), this.buildOutputDirectory){

            public File getMirrorFile(File f) {
                String file = f.getAbsolutePath().substring(this.prefixSourceDirecotory);
                return new File(this.destinationDirectory + File.separator + file);
            }
        };
    }
}

