/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.i18n.plugin.bundle;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.nuiton.i18n.I18nDefinitionFile;
import org.nuiton.i18n.bundle.I18nBundleEntry;
import org.nuiton.i18n.bundle.I18nBundleUtil;
import org.nuiton.i18n.init.DefaultI18nInitializer;
import org.nuiton.i18n.plugin.bundle.AbstractI18nBundleMojo;
import org.nuiton.i18n.plugin.bundle.BundleFormatConverter;
import org.nuiton.i18n.plugin.bundle.BundleValidation;
import org.nuiton.io.SortedProperties;
import org.nuiton.plugin.PluginHelper;
import org.nuiton.version.Versions;

@Mojo(name="bundle", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, requiresDependencyResolution=ResolutionScope.RUNTIME)
@Execute(goal="collect-i18n-artifacts")
public class BundleMojo
extends AbstractI18nBundleMojo {
    @Parameter(property="i18n.bundleInputEncoding")
    private String bundleInputEncoding;
    @Parameter(property="i18n.bundleOutputEncoding")
    private String bundleOutputEncoding;
    @Parameter(property="i18n.bundleOutputDirectory", defaultValue="${project.build.outputDirectory}", required=true)
    private File bundleOutputDirectory;
    @Parameter(property="i18n.bundleOutputPackage", defaultValue="META-INF", required=true)
    private String bundleOutputPackage;
    @Parameter(property="i18n.bundleOutputName", defaultValue="${project.artifactId}-i18n", required=true)
    private String bundleOutputName;
    @Parameter(property="i18n.generateDefaultLocale", defaultValue="false")
    private boolean generateDefaultLocale;
    @Parameter(property="i18n.checkBundle", defaultValue="true")
    private boolean checkBundle;
    @Parameter(property="i18n.showEmpty", defaultValue="false")
    private boolean showEmpty;
    @Deprecated
    @Parameter(property="i18n.failsIfWarning", defaultValue="false")
    private boolean failsIfWarning;
    @Parameter(property="i18n.failsIfAnyKeyMissingValue", defaultValue="false")
    private boolean failsIfAnyKeyMissingValue;
    @Parameter(property="i18n.failsIfAnyKeyMissingInBundle", defaultValue="false")
    private boolean failsIfAnyKeyMissingInBundle;
    private BundleValidation bundleValidation;
    private File outputFolder;
    @Parameter(property="i18n.generateDefinitionFile", defaultValue="true")
    private boolean generateDefinitionFile;
    @Parameter(property="i18n.bundleFormatConverter")
    private String bundleFormatConverter;
    @Parameter(property="i18n.template.list")
    private List<String> templateList;
    @Parameter(property="i18n.template.extension")
    private String templateExtension;
    @Component(role=BundleFormatConverter.class)
    private Map<String, BundleFormatConverter> bundleFormatConverters;
    private BundleFormatConverter converter;

    @Override
    public void init() throws Exception {
        super.init();
        if (this.failsIfWarning) {
            this.checkBundle = true;
            this.bundleValidation = new BundleValidation(this.locales);
        } else {
            this.bundleValidation = null;
        }
        this.outputFolder = this.getBundleOutputFolder();
        if (this.isVerbose()) {
            this.getLog().info((CharSequence)String.format("Will generates bundles in %s", this.outputFolder));
        }
        this.createDirectoryIfNecessary(this.outputFolder);
        if (StringUtils.isEmpty((CharSequence)this.bundleInputEncoding)) {
            this.bundleInputEncoding = this.getEncoding();
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)String.format("Use as input encoding the default one : %s", this.bundleInputEncoding));
            }
        }
        if (StringUtils.isEmpty((CharSequence)this.bundleOutputEncoding)) {
            this.bundleOutputEncoding = this.getEncoding();
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)String.format("Use as output encoding the default one : %s", this.bundleOutputEncoding));
            }
        }
        this.addResourceDir(this.bundleOutputDirectory, new String[]{"**/*.properties"});
        if (StringUtils.isNotEmpty((CharSequence)this.bundleFormatConverter)) {
            this.converter = this.bundleFormatConverters.get(this.bundleFormatConverter);
            if (this.converter == null) {
                throw new MojoExecutionException(String.format("There is no bundleFormatConverter named \"%s\", known ones are %s", this.bundleFormatConverter, this.bundleFormatConverters.keySet()));
            }
        }
    }

    protected void doAction() throws Exception {
        long t00 = System.nanoTime();
        String version = this.getProject().getVersion();
        version = PluginHelper.removeSnapshotSuffix((String)version);
        String inputEncoding = this.getBundleInputEncoding();
        String outputEncoding = this.getBundleOutputEncoding();
        if (!this.silent) {
            this.getLog().info((CharSequence)String.format("config - resources dir    : %s", this.bundleOutputDirectory));
            this.getLog().info((CharSequence)String.format("config - package name     : %s", this.bundleOutputPackage));
            this.getLog().info((CharSequence)String.format("config - bundle name      : %s", this.bundleOutputName));
            this.getLog().info((CharSequence)String.format("config - input  encoding  : %s", inputEncoding));
            this.getLog().info((CharSequence)String.format("config - output encoding  : %s", outputEncoding));
            if (this.bundleFormatConverter != null) {
                this.getLog().info((CharSequence)String.format("config - format converter : %s", this.bundleFormatConverter));
            }
            this.getLog().info((CharSequence)String.format("config - locales          : %s", Arrays.toString(this.locales)));
            this.getLog().info((CharSequence)String.format("config - version          : %s", version));
        }
        LinkedHashMap<Locale, String> bundleDico = new LinkedHashMap<Locale, String>(this.locales.length);
        for (Locale locale : this.locales) {
            long t0 = System.nanoTime();
            File bundleOut = this.getI18nFile(this.outputFolder, this.bundleOutputName, locale, false);
            SortedProperties propertiesOut = new SortedProperties(outputEncoding, false);
            StringBuilder buffer = new StringBuilder();
            URL[] urls = this.getCollectI18nResources(locale);
            if (urls.length == 0) {
                this.getLog().warn((CharSequence)String.format("no bundle for locale %s", locale));
                continue;
            }
            if (!this.silent) {
                this.getLog().info((CharSequence)String.format("generate bundle for locale %s from %d i18n resource(s)", locale, urls.length));
            }
            ArrayList<String> bundlesUrls = new ArrayList<String>();
            Charset loadEncoding = Charset.forName(inputEncoding);
            for (URL url : urls) {
                long t000 = System.nanoTime();
                I18nBundleEntry bundleEntry = new I18nBundleEntry(url, locale, null);
                bundleEntry.load((Properties)propertiesOut, loadEncoding);
                String strPath = bundleEntry.getPath().toString();
                int index = strPath.indexOf("i18n/");
                String str = strPath.substring(index);
                bundlesUrls.add(str);
                buffer.append(',').append(str);
                if (!this.verbose) continue;
                this.getLog().info((CharSequence)String.format("loaded %s in %s", bundleEntry.getPath(), PluginHelper.convertTime((long)t000, (long)System.nanoTime())));
            }
            if (!bundlesUrls.isEmpty()) {
                bundleDico.put(locale, buffer.substring(1));
                if (!this.silent) {
                    if (this.getLog().isDebugEnabled()) {
                        this.getLog().debug((CharSequence)String.format("%d i18n resource(s) detected", bundlesUrls.size()));
                    }
                    for (String u : bundlesUrls) {
                        this.getLog().info((CharSequence)u);
                    }
                }
            }
            if (this.converter != null) {
                this.applyConversion((Properties)propertiesOut);
            }
            propertiesOut.store(bundleOut);
            if (!this.silent && this.verbose) {
                this.getLog().info((CharSequence)String.format("bundle created in %s (detected sentences : %d)", PluginHelper.convertTime((long)t0, (long)System.nanoTime()), propertiesOut.size()));
            }
            if (!this.checkBundle) continue;
            this.checkBundle(locale, (Properties)propertiesOut, this.showEmpty, this.bundleValidation);
        }
        this.failsIfAnyKeyMissingValue(this.failsIfWarning || this.failsIfAnyKeyMissingValue, this.bundleValidation);
        this.failsIfAnyKeyMissingInBundle(this.failsIfAnyKeyMissingInBundle, this.bundleValidation);
        if (this.generateDefaultLocale) {
            this.generateDefaultBundle();
        }
        if (this.generateDefinitionFile) {
            this.generateDefinitionFile(version, bundleDico);
        }
        if (!this.silent && this.verbose) {
            this.getLog().info((CharSequence)("done in " + PluginHelper.convertTime((long)t00, (long)System.nanoTime())));
        }
    }

    private File getBundleFile(File root, String artifactId, Locale locale, boolean create) throws IOException {
        return this.getI18nFile(root, artifactId, locale, create);
    }

    private void generateDefinitionFile(String version, Map<Locale, String> bundleDico) throws IOException {
        String f = String.format(DefaultI18nInitializer.UNIQUE_BUNDLE_DEF, this.bundleOutputName);
        File defOut = new File(this.outputFolder, f);
        if (!this.silent) {
            this.getLog().info((CharSequence)String.format("prepare i18n definition file in %s", defOut.getAbsolutePath()));
        }
        ArrayListMultimap abundles = ArrayListMultimap.create();
        for (Map.Entry<Locale, String> e : bundleDico.entrySet()) {
            String value = e.getValue();
            abundles.putAll((Object)e.getKey(), Arrays.asList(value.split(",")));
        }
        I18nDefinitionFile definitionFile = new I18nDefinitionFile(this.bundleOutputName, Charset.forName(this.encoding), Versions.valueOf((String)version), new LinkedHashSet<Locale>(Arrays.asList(this.locales)), this.templateExtension, (Set)(this.templateList == null ? Collections.emptySortedSet() : new TreeSet<String>(this.templateList)), (Multimap)abundles);
        definitionFile.store(this.outputFolder);
    }

    @Override
    protected URL[] getCollectI18nResources(Locale locale) throws IOException {
        File file = this.getCollectOutputFile(locale, false);
        if (!file.exists()) {
            return I18nBundleUtil.EMPTY_URL_ARRAY;
        }
        return PluginHelper.getLinesAsURL((File)file);
    }

    private void applyConversion(Properties properties) {
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String convertedValue = this.converter.convert((String)entry.getValue());
            properties.setProperty((String)entry.getKey(), convertedValue);
        }
    }

    private void generateDefaultBundle() throws IOException {
        File bundleFirstLocale = this.getBundleFile(this.outputFolder, this.bundleOutputName, this.locales[0], false);
        File bundleWithoutLocale = this.getBundleFile(this.outputFolder, this.bundleOutputName, null, false);
        if (!this.isSilent()) {
            this.getLog().info((CharSequence)String.format("Generate default bundle at %s", bundleWithoutLocale));
        }
        FileUtils.copyFile((File)bundleFirstLocale, (File)bundleWithoutLocale);
    }

    private File getBundleOutputFolder() {
        File result = this.bundleOutputDirectory;
        if (StringUtils.isNotEmpty((CharSequence)this.bundleOutputPackage)) {
            String[] paths;
            for (String path : paths = this.bundleOutputPackage.split("\\.")) {
                result = new File(result, path);
            }
        }
        return result;
    }

    private String getBundleOutputEncoding() {
        return this.bundleOutputEncoding;
    }

    private String getBundleInputEncoding() {
        return this.bundleInputEncoding;
    }
}

