/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.i18n.plugin;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.nuiton.i18n.plugin.I18nMojoSupport;
import org.nuiton.i18n.plugin.bundle.BundleValidation;
import org.nuiton.i18n.spi.GetterFile;
import org.nuiton.io.SortedProperties;
import org.nuiton.plugin.PluginHelper;

@Mojo(name="generate", defaultPhase=LifecyclePhase.GENERATE_RESOURCES)
@Execute(goal="collect-i18n-artifacts")
public class GenerateMojo
extends I18nMojoSupport {
    @Parameter(property="i18n.strictMode", defaultValue="false")
    private boolean strictMode;
    @Parameter(property="i18n.checkBundle", defaultValue="true", required=true)
    private boolean checkBundle;
    @Parameter(property="i18n.showEmpty", defaultValue="false", required=true)
    private boolean showEmpty;
    @Parameter(property="i18n.failsIfAnyKeyMissingValue", defaultValue="false")
    private boolean failsIfAnyKeyMissingValue;
    @Parameter(property="i18n.failsIfAnyKeyMissingInBundle", defaultValue="false")
    private boolean failsIfAnyKeyMissingInBundle;
    @Parameter(property="i18n.removeDuplicatedKeys", defaultValue="false")
    private boolean removeDuplicatedKeys;
    @Parameter(property="i18n.failsIfDuplicatedKeys", defaultValue="true")
    private boolean failsIfDuplicatedKeys;
    @Parameter(property="i18n.keepGetters", defaultValue="false")
    private boolean keepGetters;
    @Parameter(property="i18n.collectDirectory", defaultValue="${project.build.directory}/i18n/collect", required=true)
    private File collectDirectory;
    @Parameter(property="i18n.collectBundleName", defaultValue="${project.artifactId}-collect", required=true)
    private String collectBundleName;
    @Parameter(property="i18n.copyToClasses", defaultValue="false")
    private boolean copyToClasses;
    private List<GetterFile> getterFiles;

    @Override
    public void init() throws Exception {
        super.init();
        this.getterFiles = GetterFile.load((File)this.gettersDirectory);
        for (GetterFile getterFile : this.getterFiles) {
            getterFile.load();
        }
    }

    protected boolean checkSkip() {
        boolean result = true;
        if (this.getterFiles.isEmpty()) {
            this.getLog().info((CharSequence)"No getter detected - all files are up to date.");
            result = false;
            this.copyI18nBundleToClasses();
        }
        return result;
    }

    protected void doAction() throws Exception {
        if (!this.silent) {
            this.getLog().info((CharSequence)("config - sourceDirectory : " + this.sourceDirectory.getAbsolutePath()));
            this.getLog().info((CharSequence)("config - locales         : " + Arrays.toString(this.locales)));
        }
        BundleValidation bundleValidation = new BundleValidation(this.locales);
        Set detectedKeys = this.getterFiles.stream().flatMap(g -> g.getKeys().stream()).collect(Collectors.toSet());
        for (Locale locale : this.locales) {
            if (!this.silent) {
                this.getLog().info((CharSequence)("prepare bundle for locale " + locale));
            }
            File bundleSrc = this.getI18nFile(this.sourceDirectory, this.artifactId, locale, false);
            SortedProperties propertiesSrc = new SortedProperties(this.encoding);
            if (bundleSrc.exists()) {
                propertiesSrc.load(bundleSrc);
            }
            SortedProperties propertiesOut = new SortedProperties(this.encoding);
            TreeSet keysToKeep = new TreeSet(detectedKeys);
            if (!this.strictMode) {
                keysToKeep.addAll(propertiesSrc.stringPropertyNames());
            }
            for (String key : keysToKeep) {
                String value = propertiesSrc.getProperty(key);
                if (value == null) {
                    value = "";
                }
                propertiesOut.put((Object)key, (Object)value);
            }
            this.getLog().info((CharSequence)String.format("For locale %s got %d key(s).", locale, propertiesOut.size()));
            Properties dependenciesBundle = this.loadDependenciesKeys(locale, bundleSrc);
            TreeSet dependenciesKeys = new TreeSet();
            dependenciesBundle.keySet().forEach(e -> dependenciesKeys.add((String)e));
            TreeSet allKeys = new TreeSet();
            propertiesOut.keySet().forEach(e -> allKeys.add((String)e));
            allKeys.retainAll(dependenciesKeys);
            Properties moduleDivergence = new Properties();
            if (!allKeys.isEmpty()) {
                Iterator iterator = allKeys.iterator();
                while (iterator.hasNext()) {
                    String key = (String)iterator.next();
                    String moduleValue = propertiesOut.getProperty(key);
                    String dependenciesValue = dependenciesBundle.getProperty(key);
                    if (StringUtils.isEmpty((CharSequence)moduleValue) || Objects.equals(moduleValue, dependenciesValue)) {
                        if (this.verbose) {
                            this.getLog().info((CharSequence)String.format("For locale %s, removing duplicated key %s", locale, key));
                        }
                        iterator.remove();
                        propertiesOut.remove((Object)key);
                        continue;
                    }
                    moduleDivergence.put(key, Pair.of((Object)dependenciesValue, (Object)moduleValue));
                }
            }
            if (!allKeys.isEmpty()) {
                if (this.failsIfDuplicatedKeys) {
                    throw new MojoFailureException(String.format("For locale %s found %d duplicated key(s):\n%s\n\nDivergence values:\n%s", locale, allKeys.size(), Joiner.on((String)"\n").join(allKeys), Joiner.on((String)"\n").join(moduleDivergence.entrySet())));
                }
                this.getLog().warn((CharSequence)String.format("For locale %s found %d duplicated key(s):\n%s\n\nDivergence values:\n%s", locale, allKeys.size(), Joiner.on((String)"\n").join(allKeys), Joiner.on((String)"\n").join(moduleDivergence.entrySet())));
                if (this.removeDuplicatedKeys) {
                    allKeys.forEach(arg_0 -> propertiesOut.remove(arg_0));
                    this.getLog().info((CharSequence)String.format("For locale %s, remove %d duplicated key(s).", locale, allKeys.size()));
                }
            }
            if (!this.silent) {
                this.getLog().info((CharSequence)String.format("merge bundle %s to outputDirectory", locale));
            }
            if (this.checkBundle) {
                ImmutableSet keys = Maps.fromProperties((Properties)propertiesOut).keySet();
                bundleValidation.getKeysPerLocale().putAll((Object)locale, (Iterable)keys);
                this.checkBundle(locale, (Properties)propertiesOut, this.showEmpty, bundleValidation);
            }
            PluginHelper.createDirectoryIfNecessary((File)bundleSrc.getParentFile());
            propertiesOut.store(bundleSrc);
            if (this.silent) continue;
            this.getLog().info((CharSequence)String.format("copy bundle %s to sourceDirectory", locale));
        }
        if (!this.keepGetters) {
            this.getterFiles.forEach(GetterFile::delete);
            this.deleteFile(this.gettersDirectory);
        }
        this.failsIfAnyKeyMissingValue(this.failsIfAnyKeyMissingValue, bundleValidation);
        this.failsIfAnyKeyMissingInBundle(this.failsIfAnyKeyMissingInBundle, bundleValidation);
        this.copyI18nBundleToClasses();
    }

    private Properties loadDependenciesKeys(Locale locale, File bundleOut) throws IOException {
        Properties result = new Properties();
        Objects.requireNonNull(locale);
        File i18nFile = this.getI18nFile(this.collectDirectory, this.collectBundleName, locale, false);
        this.getLog().debug((CharSequence)String.format("dependencies file: %s", i18nFile));
        if (i18nFile.exists()) {
            List urls = Files.readLines((File)i18nFile, (Charset)this.charset);
            for (String url : urls) {
                File f;
                this.getLog().debug((CharSequence)String.format("url to test: %s", url));
                if (url.startsWith("file:") && ((f = new File(new URL(url).getFile())).getParentFile().equals(bundleOut.getParentFile()) || f.getName().equals(bundleOut.getName()))) continue;
                InputStreamReader reader = new InputStreamReader(new URL(url).openStream(), this.charset);
                Throwable throwable = null;
                try {
                    result.load(reader);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (reader == null) continue;
                    if (throwable != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ((Reader)reader).close();
                }
            }
        }
        return result;
    }

    private void copyI18nBundleToClasses() {
        if (!this.copyToClasses) {
            return;
        }
        LinkedHashSet<File> bundleFiles = new LinkedHashSet<File>();
        for (Locale locale : this.locales) {
            try {
                File bundleSrc = this.getI18nFile(this.sourceDirectory, this.artifactId, locale, false);
                if (!bundleSrc.exists()) continue;
                bundleFiles.add(bundleSrc);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        File outputDir = new File(this.buildOutputDirectory, "i18n");
        for (File bundleFile : bundleFiles) {
            try {
                PluginHelper.copy((File)bundleFile, (File)new File(outputDir, bundleFile.getName()));
            }
            catch (IOException e) {
                throw new RuntimeException("Can't copy some files...", e);
            }
        }
    }
}

