/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.maven.polyglot.yaml;

import java.beans.IntrospectionException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Developer;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.yaml.snakeyaml.introspector.Property;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Represent;
import org.yaml.snakeyaml.representer.Representer;

class ModelRepresenter
extends Representer {
    public ModelRepresenter() {
        this.representers.put(Xpp3Dom.class, new RepresentXpp3Dom());
        Represent stringRepresenter = (Represent)this.representers.get(String.class);
        this.representers.put(Boolean.class, stringRepresenter);
        this.multiRepresenters.put(Number.class, stringRepresenter);
        this.multiRepresenters.put(Date.class, stringRepresenter);
        this.multiRepresenters.put(Enum.class, stringRepresenter);
        this.multiRepresenters.put(Calendar.class, stringRepresenter);
    }

    protected NodeTuple representJavaBeanProperty(Object javaBean, Property property, Object propertyValue, Tag customTag) {
        Object map;
        if (propertyValue == null) {
            return null;
        }
        if (propertyValue instanceof Map && (map = (Map)propertyValue).isEmpty()) {
            return null;
        }
        if (propertyValue instanceof List && (map = (List)propertyValue).isEmpty()) {
            return null;
        }
        if (javaBean instanceof Dependency) {
            if (this.skipBoolean(property, "optional", propertyValue, false)) {
                return null;
            }
            if (this.skipString(property, "type", propertyValue, "jar")) {
                return null;
            }
        }
        if (javaBean instanceof Plugin) {
            if (this.skipBoolean(property, "extensions", propertyValue, false)) {
                return null;
            }
            if (this.skipBoolean(property, "inherited", propertyValue, true)) {
                return null;
            }
        }
        return super.representJavaBeanProperty(javaBean, property, propertyValue, customTag);
    }

    private boolean skipString(Property property, String name, Object propertyValue, String value) {
        if (name.equals(property.getName())) {
            String v = (String)propertyValue;
            return value.equals(v);
        }
        return false;
    }

    private boolean skipBoolean(Property property, String name, Object propertyValue, boolean value) {
        if (name.equals(property.getName())) {
            Boolean v = (Boolean)propertyValue;
            return v.equals(value);
        }
        return false;
    }

    protected Set<Property> getProperties(Class<? extends Object> type) throws IntrospectionException {
        if (type.isAssignableFrom(Model.class)) {
            Set standard = super.getProperties(type);
            ArrayList<String> order = new ArrayList<String>(Arrays.asList("modelVersion", "groupId", "artifactId", "version", "packaging", "properties", "name", "description", "inceptionYear", "url", "issueManagement", "ciManagement", "mailingLists", "scm", "licenses", "developers", "contributers", "prerequisites", "dependencies", "distributionManagement", "build", "reporting"));
            TreeSet<Property> sorted = new TreeSet<Property>(new ModelPropertyComparator(order));
            sorted.addAll(standard);
            return sorted;
        }
        if (type.isAssignableFrom(Developer.class)) {
            Set standard = super.getProperties(type);
            ArrayList<String> order = new ArrayList<String>(Arrays.asList("name", "id", "email"));
            TreeSet<Property> sorted = new TreeSet<Property>(new ModelPropertyComparator(order));
            sorted.addAll(standard);
            return sorted;
        }
        if (type.isAssignableFrom(Plugin.class)) {
            Set standard = super.getProperties(type);
            ArrayList<String> order = new ArrayList<String>(Arrays.asList("groupId", "artifactId", "version", "inherited", "extensions", "configuration"));
            TreeSet<Property> sorted = new TreeSet<Property>(new ModelPropertyComparator(order));
            sorted.addAll(standard);
            return sorted;
        }
        return super.getProperties(type);
    }

    private class ModelPropertyComparator
    implements Comparator<Property> {
        private List<String> names;

        public ModelPropertyComparator(List<String> names) {
            this.names = names;
        }

        @Override
        public int compare(Property o1, Property o2) {
            for (String name : this.names) {
                int c = this.compareByName(o1, o2, name);
                if (c == 0) continue;
                return c;
            }
            return o1.compareTo(o2);
        }

        private int compareByName(Property o1, Property o2, String name) {
            if (o1.getName().equals(name)) {
                return -1;
            }
            if (o2.getName().equals(name)) {
                return 1;
            }
            return 0;
        }
    }

    private class RepresentXpp3Dom
    implements Represent {
        private RepresentXpp3Dom() {
        }

        public Node representData(Object data) {
            return ModelRepresenter.this.representMapping(Tag.MAP, this.toMap((Xpp3Dom)data), null);
        }

        private Map<String, Object> toMap(Xpp3Dom dom) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            int n = dom.getChildCount();
            for (int i = 0; i < n; ++i) {
                Xpp3Dom child = dom.getChild(i);
                if (child.getValue() != null) {
                    map.put(child.getName(), child.getValue());
                    continue;
                }
                map.put(child.getName(), this.toMap(child));
            }
            return map;
        }
    }
}

