/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.maven.polyglot.yaml;

import java.util.regex.Matcher;
import org.apache.maven.model.Dependency;
import org.sonatype.maven.polyglot.yaml.ModelResolver;
import org.yaml.snakeyaml.constructor.AbstractConstruct;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.ScalarNode;

public class ConstructDependency
extends AbstractConstruct {
    public Object construct(Node node) {
        ScalarNode scalar = (ScalarNode)node;
        return ConstructDependency.createDependency(scalar.getValue(), new Dependency());
    }

    public static Dependency createDependency(String scalar, Dependency dependency) {
        String version;
        Matcher matcher = ModelResolver.DEPENDENCY_PATTERN.matcher(scalar);
        if (matcher.matches()) {
            version = matcher.group("version");
            dependency.setVersion(version);
            String scope = matcher.group("scope");
            dependency.setScope(scope);
        } else {
            matcher = ModelResolver.COORDINATE_PATTERN.matcher(scalar);
            if (matcher.matches()) {
                version = matcher.group("version");
                dependency.setVersion(version);
            } else {
                matcher = ModelResolver.GROUP_NAME_PATTERN.matcher(scalar);
                if (!matcher.matches()) {
                    throw new IllegalArgumentException("Unexpected node: " + scalar);
                }
            }
        }
        String groupId = matcher.group("groupId");
        String artifactId = matcher.group("artifactId");
        dependency.setGroupId(groupId);
        dependency.setArtifactId(artifactId);
        return dependency;
    }
}

