/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.maven.polyglot.ruby;

import java.io.File;
import java.io.FileFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.TreeSet;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.plugin.LegacySupport;
import org.apache.maven.repository.RepositorySystem;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;

@Component(role=SetupClassRealm.class)
public class SetupClassRealm {
    @Requirement
    RepositorySystem system;
    @Requirement
    protected LegacySupport legacySupport;
    private static final String JRUBY_HOME = "polyglot.jruby.home";

    public void setupArtifact(String gav, ClassRealm realm) throws MalformedURLException {
        try {
            realm.loadClass("org.jruby.embed.ScriptingContainer");
        }
        catch (ClassNotFoundException e) {
            this.setup(gav, realm);
        }
    }

    private void setup(String gav, ClassRealm realm) throws MalformedURLException {
        String jrubyHome = System.getenv("POLYGLOT_JRUBY_HOME");
        if (jrubyHome == null) {
            jrubyHome = System.getProperty(JRUBY_HOME);
        }
        if (jrubyHome == null) {
            jrubyHome = this.legacySupport.getSession().getRequest().getUserProperties().getProperty(JRUBY_HOME);
        }
        if (jrubyHome == null) {
            jrubyHome = this.legacySupport.getSession().getRequest().getSystemProperties().getProperty(JRUBY_HOME);
        }
        if (jrubyHome == null && this.legacySupport.getSession().getCurrentProject() != null) {
            jrubyHome = this.legacySupport.getSession().getCurrentProject().getProperties().getProperty(JRUBY_HOME);
        }
        if (jrubyHome != null) {
            this.setupFromJrubyHome(jrubyHome, realm);
        } else {
            this.doSetupArtifact(gav, realm);
        }
    }

    protected void setupFromJrubyHome(String jrubyHome, ClassRealm realm) throws MalformedURLException {
        System.setProperty(JRUBY_HOME, jrubyHome);
        File[] jars = new File(jrubyHome, "lib").listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().endsWith(".jar");
            }
        });
        if (jars == null || jars.length == 0) {
            throw new RuntimeException("found jruby-home variable but no jruby.jar: " + jrubyHome);
        }
        for (File jar : jars) {
            realm.addURL(jar.toURI().toURL());
        }
    }

    public void doSetupArtifact(String gav, ClassRealm realm) throws MalformedURLException {
        String[] parts = gav.split(":");
        Artifact root = this.system.createArtifact(parts[0], parts[1], parts[2], "pom");
        ArtifactResolutionResult result = this.system.resolve(new ArtifactResolutionRequest().setArtifact(root).setCollectionFilter(new ArtifactFilter(){

            public boolean include(Artifact artifact) {
                return !"polyglot-common".equals(artifact.getArtifactId()) && !"test".equals(artifact.getScope());
            }
        }).setResolveRoot(true).setForceUpdate(true).setOffline(this.legacySupport.getSession().getRequest().isOffline()).setMirrors(this.legacySupport.getSession().getRequest().getMirrors()).setProxies(this.legacySupport.getSession().getRequest().getProxies()).setServers(this.legacySupport.getSession().getRequest().getServers()).setLocalRepository(this.legacySupport.getSession().getRequest().getLocalRepository()).setRemoteRepositories(this.legacySupport.getSession().getRequest().getRemoteRepositories()).setResolveTransitively(true));
        TreeSet<String> urls = new TreeSet<String>();
        for (URL url : realm.getURLs()) {
            urls.add(url.toString());
        }
        for (Artifact a : result.getArtifacts()) {
            URL url;
            if (!"jar".equals(a.getType()) || a.getFile() == null || urls.contains((url = a.getFile().toURI().toURL()).toString())) continue;
            realm.addURL(a.getFile().toURI().toURL());
        }
    }
}

