/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.maven.polyglot.atom.parsing;

import java.util.ArrayList;
import java.util.List;
import org.sonatype.maven.polyglot.atom.parsing.Token;

public class Tokenizer {
    private final String input;
    private static final int NON = 0;
    private static final int SINGLE_TOKEN = 1;
    private static final int SEQUENCE_TOKEN = 2;
    private static final int[] DELIMITERS = new int[256];
    private static final boolean[] STRING_TERMINATORS = new boolean[256];

    public Tokenizer(String input) {
        this.input = input.replace("\r\n", "\n").replace('\r', '\n');
    }

    public List<Token> tokenize() {
        int i;
        ArrayList<Token> tokens = new ArrayList<Token>();
        char[] input = this.input.toCharArray();
        int start = 0;
        boolean inWhitespace = false;
        boolean inDelimiter = false;
        boolean inComment = false;
        boolean leading = true;
        char inStringSequence = '\u0000';
        for (i = 0; i < input.length; ++i) {
            char c = input[i];
            if (STRING_TERMINATORS[c]) {
                if (inStringSequence > '\u0000') {
                    if (inStringSequence == c) {
                        Tokenizer.bakeToken(tokens, input, i + 1, start);
                        start = i + 1;
                        inStringSequence = '\u0000';
                        continue;
                    }
                } else {
                    if (i > start) {
                        Tokenizer.bakeToken(tokens, input, i, start);
                        start = i;
                    }
                    inStringSequence = c;
                }
            }
            if (inStringSequence > '\u0000') continue;
            if (c == '\n') {
                leading = true;
            }
            if (c == '#') {
                inComment = true;
            }
            if (inComment) {
                if (c == '\n') {
                    inComment = false;
                }
                start = i;
                continue;
            }
            if (Tokenizer.isWhitespace(c)) {
                inDelimiter = false;
                if (!inWhitespace) {
                    Tokenizer.bakeToken(tokens, input, i, start);
                    inWhitespace = true;
                }
                if (leading) {
                    tokens.add(new Token(" ", Token.Kind.INDENT));
                }
                start = i + 1;
                continue;
            }
            inWhitespace = false;
            if (c != '\n') {
                leading = false;
            }
            if (Tokenizer.isSingleTokenDelimiter(c)) {
                Tokenizer.bakeToken(tokens, input, i, start);
                start = i;
                Tokenizer.bakeToken(tokens, input, i + 1, start);
                start = i + 1;
                continue;
            }
            if (Tokenizer.isDelimiter(c)) {
                if (inDelimiter) continue;
                Tokenizer.bakeToken(tokens, input, i, start);
                inDelimiter = true;
                start = i;
                continue;
            }
            if (!inDelimiter) continue;
            Tokenizer.bakeToken(tokens, input, i, start);
            start = i;
            inDelimiter = false;
        }
        if (i > start && !inComment) {
            Tokenizer.bakeToken(tokens, input, i, start);
        }
        return tokens;
    }

    private static boolean isWhitespace(char c) {
        return '\n' != c && Character.isWhitespace(c);
    }

    static boolean isSingleTokenDelimiter(char c) {
        return DELIMITERS[c] == 1;
    }

    public static String detokenize(List<Token> tokens) {
        StringBuilder builder = new StringBuilder();
        for (Token token : tokens) {
            if (Token.Kind.INDENT == token.kind) {
                builder.append("~");
            } else {
                builder.append(token.value);
            }
            builder.append(' ');
        }
        return builder.toString().trim();
    }

    private static boolean isDelimiter(char c) {
        return DELIMITERS[c] != 0;
    }

    private static void bakeToken(List<Token> tokens, char[] input, int i, int start) {
        if (i > start) {
            String value = new String(input, start, i - start);
            tokens.add(new Token(value, Token.Kind.determine(value)));
        }
    }

    static {
        Tokenizer.DELIMITERS[43] = 2;
        Tokenizer.DELIMITERS[47] = 2;
        Tokenizer.DELIMITERS[42] = 2;
        Tokenizer.DELIMITERS[62] = 2;
        Tokenizer.DELIMITERS[60] = 2;
        Tokenizer.DELIMITERS[33] = 2;
        Tokenizer.DELIMITERS[63] = 2;
        Tokenizer.DELIMITERS[10] = 1;
        Tokenizer.DELIMITERS[46] = 1;
        Tokenizer.DELIMITERS[44] = 1;
        Tokenizer.DELIMITERS[58] = 1;
        Tokenizer.DELIMITERS[40] = 1;
        Tokenizer.DELIMITERS[41] = 1;
        Tokenizer.DELIMITERS[91] = 1;
        Tokenizer.DELIMITERS[93] = 1;
        Tokenizer.DELIMITERS[123] = 1;
        Tokenizer.DELIMITERS[125] = 1;
        Tokenizer.DELIMITERS[64] = 1;
        Tokenizer.STRING_TERMINATORS[34] = true;
        Tokenizer.STRING_TERMINATORS[39] = true;
        Tokenizer.STRING_TERMINATORS[96] = true;
    }
}

