/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.maven.polyglot.atom.parsing;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.model.Repository;
import org.apache.maven.model.Scm;
import org.sonatype.maven.polyglot.atom.parsing.Element;
import org.sonatype.maven.polyglot.atom.parsing.Id;
import org.sonatype.maven.polyglot.atom.parsing.Property;
import org.sonatype.maven.polyglot.atom.parsing.Repositories;
import org.sonatype.maven.polyglot.atom.parsing.ScmElement;

public class Project
extends Element {
    private final Id projectId;
    private final Parent parent;
    private String packaging = "jar";
    private List<Property> properties;
    private final Repositories repositories;
    private final String description;
    private final String url;
    private List<Id> deps;
    private List<Id> overrides;
    private List<String> modules;
    private List<Plugin> pluginOverrides;
    private List<Plugin> plugins;
    private Map<String, String> dirs;
    private static final String MAVEN_CENTRAL_URL = "http://repo1.maven.org/maven2";
    private final ScmElement scm;

    public Project(Id projectId, Parent parent, String packaging, List<Property> properties, Repositories repositories, String description, String url, List<Id> overrides, List<Id> deps, List<String> modules, List<Plugin> pluginOverrides, List<Plugin> plugins, Map<String, String> dirs, ScmElement scm) {
        this.projectId = projectId;
        this.parent = parent;
        this.packaging = packaging;
        this.properties = properties;
        this.repositories = repositories;
        this.description = description;
        this.url = url;
        this.overrides = overrides;
        this.deps = deps;
        this.modules = modules;
        this.pluginOverrides = pluginOverrides;
        this.plugins = plugins;
        this.dirs = dirs;
        this.scm = scm;
    }

    public Id getProjectId() {
        return this.projectId;
    }

    public Parent getParent() {
        return this.parent;
    }

    public String getPackaging() {
        return this.packaging;
    }

    public List<Plugin> getPlugins() {
        return this.plugins;
    }

    public List<Plugin> getPluginOverrides() {
        return this.pluginOverrides;
    }

    public List<String> getModules() {
        return this.modules;
    }

    public List<Id> getOverrides() {
        return this.overrides;
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    public Repositories getRepositories() {
        return this.repositories;
    }

    public String getDescription() {
        return this.description;
    }

    public String getUrl() {
        return this.url;
    }

    public List<Id> getDeps() {
        return this.deps;
    }

    public Map<String, String> getDirs() {
        return this.dirs;
    }

    public Model toMavenModel() {
        Model model = new Model();
        model.setBuild(new Build());
        model.setDescription(this.description);
        model.setUrl(this.url);
        model.setName(this.projectId.getArtifact());
        model.setGroupId(this.projectId.getGroup());
        model.setVersion(this.projectId.getVersion());
        model.setArtifactId(this.projectId.getArtifact());
        model.setModelVersion("4.0.0");
        if (this.parent != null) {
            model.setParent(this.parent);
        }
        model.setPackaging(this.packaging);
        if (this.properties != null) {
            Properties modelProperties = new Properties();
            for (Property p : this.properties) {
                modelProperties.setProperty(p.getKey(), p.getValue());
            }
            model.setProperties(modelProperties);
        }
        if (null != this.repositories) {
            for (String string : this.repositories.getRepositories()) {
                Repository repository = new Repository();
                repository.setId(Integer.toString(string.hashCode()));
                repository.setUrl(string);
                model.addRepository(repository);
            }
        }
        if (this.overrides != null) {
            DependencyManagement depMan = new DependencyManagement();
            for (Id dep : this.overrides) {
                Dependency dependency = new Dependency();
                dependency.setGroupId(dep.getGroup());
                dependency.setArtifactId(dep.getArtifact());
                dependency.setVersion(dep.getVersion());
                dependency.setType("jar");
                if (null != dep.getClassifier()) {
                    dependency.setClassifier(dep.getClassifier());
                }
                depMan.addDependency(dependency);
            }
            model.setDependencyManagement(depMan);
        }
        if (this.deps != null) {
            for (Id id : this.deps) {
                Dependency dependency = new Dependency();
                dependency.setGroupId(id.getGroup());
                dependency.setArtifactId(id.getArtifact());
                dependency.setVersion(id.getVersion());
                dependency.setType("jar");
                if (null != id.getClassifier()) {
                    dependency.setClassifier(id.getClassifier());
                }
                model.addDependency(dependency);
            }
        }
        if (this.modules != null) {
            model.setModules(this.modules);
        }
        if (this.pluginOverrides != null) {
            PluginManagement management = new PluginManagement();
            management.setPlugins(this.pluginOverrides);
            model.getBuild().setPluginManagement(management);
        }
        if (this.plugins != null) {
            model.getBuild().setPlugins(this.plugins);
        }
        if (this.dirs != null) {
            Build build = new Build();
            String string = this.dirs.get("src");
            String testDir = this.dirs.get("test");
            if (null != string) {
                build.setSourceDirectory(string);
            }
            if (null != testDir) {
                build.setTestSourceDirectory(testDir);
            }
            model.setBuild(build);
        }
        if (null != this.scm) {
            Scm scm = new Scm();
            scm.setConnection(this.scm.getConnection());
            scm.setDeveloperConnection(this.scm.getDeveloperConnection());
            scm.setUrl(this.scm.getUrl());
            model.setScm(scm);
        }
        return model;
    }

    public ScmElement getScm() {
        return this.scm;
    }
}

