/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.languages;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.codegen.CliOption;
import io.swagger.codegen.CodegenConfig;
import io.swagger.codegen.CodegenModel;
import io.swagger.codegen.CodegenOperation;
import io.swagger.codegen.CodegenParameter;
import io.swagger.codegen.CodegenProperty;
import io.swagger.codegen.CodegenSecurity;
import io.swagger.codegen.CodegenType;
import io.swagger.codegen.DefaultCodegen;
import io.swagger.codegen.SupportingFile;
import io.swagger.codegen.languages.helpers.ExtensionHelper;
import io.swagger.codegen.utils.ModelUtils;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.core.util.Yaml;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.BooleanSchema;
import io.swagger.v3.oas.models.media.MapSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.security.SecurityScheme;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class HaskellHttpClientCodegen
extends DefaultCodegen
implements CodegenConfig {
    protected String sourceFolder = "src";
    protected String artifactId = "swagger-haskell-http-client";
    protected String artifactVersion = "1.0.0";
    protected String defaultDateFormat = "%Y-%m-%d";
    protected Boolean useMonadLogger = false;
    protected Boolean genEnums = true;
    public static final String PROP_ALLOW_FROMJSON_NULLS = "allowFromJsonNulls";
    public static final String PROP_ALLOW_TOJSON_NULLS = "allowToJsonNulls";
    public static final String PROP_DATETIME_FORMAT = "dateTimeFormat";
    public static final String PROP_DATE_FORMAT = "dateFormat";
    public static final String PROP_GENERATE_ENUMS = "generateEnums";
    public static final String PROP_GENERATE_FORM_URLENCODED_INSTANCES = "generateFormUrlEncodedInstances";
    public static final String PROP_GENERATE_LENSES = "generateLenses";
    public static final String PROP_GENERATE_MODEL_CONSTRUCTORS = "generateModelConstructors";
    public static final String PROP_INLINE_MIME_TYPES = "inlineMimeTypes";
    public static final String PROP_MODEL_DERIVING = "modelDeriving";
    public static final String PROP_STRICT_FIELDS = "strictFields";
    public static final String PROP_USE_MONAD_LOGGER = "useMonadLogger";
    private static final Pattern LEADING_UNDERSCORE = Pattern.compile("^_+");
    static final String MEDIA_TYPE = "mediaType";
    static final String MIME_NO_CONTENT = "MimeNoContent";
    static final String X_ALL_UNIQUE_PARAMS = "x-allUniqueParams";
    static final String X_COLLECTION_FORMAT = "x-collectionFormat";
    static final String X_HADDOCK_PATH = "x-haddockPath";
    static final String X_HAS_BODY_OR_FORM_PARAM = "x-hasBodyOrFormParam";
    static final String X_HAS_ENUM_SECTION = "x-hasEnumSection";
    static final String X_HAS_MIME_FORM_URL_ENCODED = "x-hasMimeFormUrlEncoded";
    static final String X_HAS_NEW_TAG = "x-hasNewTag";
    static final String X_HAS_OPTIONAL_PARAMS = "x-hasOptionalParams";
    static final String X_HAS_UNKNOWN_MIME_TYPES = "x-hasUnknownMimeTypes";
    static final String X_HAS_UNKNOWN_RETURN = "x-hasUnknownReturn";
    static final String X_INLINE_CONTENT_TYPE = "x-inlineContentType";
    static final String X_INLINE_ACCEPT = "x-inlineAccept";
    static final String X_IS_BODY_OR_FORM_PARAM = "x-isBodyOrFormParam";
    static final String X_IS_BODY_PARAM = "x-isBodyParam";
    static final String X_MEDIA_DATA_TYPE = "x-mediaDataType";
    static final String X_DATA_TYPE = "x-dataType";
    static final String X_ENUM_VALUES = "x-enumValues";
    static final String X_MEDIA_IS_JSON = "x-mediaIsJson";
    static final String X_MIME_TYPES = "x-mimeTypes";
    static final String X_OPERATION_TYPE = "x-operationType";
    static final String X_PARAM_NAME_TYPE = "x-paramNameType";
    static final String X_PATH = "x-path";
    static final String X_RETURN_TYPE = "x-returnType";
    static final String X_STRICT_FIELDS = "x-strictFields";
    static final String X_UNKNOWN_MIME_TYPES = "x-unknownMimeTypes";
    static final String X_USE_MONAD_LOGGER = "x-useMonadLogger";
    static final String X_NEWTYPE = "x-newtype";
    static final String X_ENUM = "x-enum";
    protected ArrayList<Map<String, String>> unknownMimeTypes = new ArrayList();
    protected Map<String, Map<String, Object>> uniqueParamNameTypes = new HashMap<String, Map<String, Object>>();
    protected Map<String, Set<String>> modelMimeTypes = new HashMap<String, Set<String>>();
    protected Map<String, String> knownMimeDataTypes = new HashMap<String, String>();
    protected Set<String> typeNames = new HashSet<String>();
    private static final Pattern JSON_MIME_PATTERN = Pattern.compile("(?i)application/.*json(;.*)?");

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "haskell-http-client";
    }

    @Override
    public String getHelp() {
        return "Generates a Haskell http-client library.";
    }

    public HaskellHttpClientCodegen() {
        this.specialCharReplacements.put("-", "Dash");
        this.specialCharReplacements.put(">", "GreaterThan");
        this.specialCharReplacements.put("<", "LessThan");
        this.specialCharReplacements.remove("\\");
        this.specialCharReplacements.remove("\"");
        this.specialCharReplacements.put("\\\\", "Back_Slash");
        this.specialCharReplacements.put("\\\"", "Double_Quote");
        this.outputFolder = "generated-code/haskell-http-client";
        this.templateDir = "haskell-http-client";
        this.embeddedTemplateDir = "haskell-http-client";
        this.apiPackage = "API";
        this.modelPackage = "Model";
        this.setReservedWordsLowerCase(Arrays.asList("as", "case", "of", "class", "data", "family", "default", "deriving", "do", "forall", "foreign", "hiding", "if", "then", "else", "import", "infix", "infixl", "infixr", "instance", "let", "in", "mdo", "module", "newtype", "proc", "qualified", "rec", "type", "where", "pure", "return", "Accept", "ContentType"));
        this.additionalProperties.put("artifactId", this.artifactId);
        this.additionalProperties.put("artifactVersion", this.artifactVersion);
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        this.supportingFiles.add(new SupportingFile("stack.mustache", "", "stack.yaml"));
        this.supportingFiles.add(new SupportingFile("Setup.mustache", "", "Setup.hs"));
        this.supportingFiles.add(new SupportingFile("gitignore.mustache", "", ".gitignore"));
        this.supportingFiles.add(new SupportingFile(".travis.yml", "", ".travis.yml"));
        this.supportingFiles.add(new SupportingFile("git_push.sh.mustache", "", "git_push.sh"));
        this.supportingFiles.add(new SupportingFile("tests/ApproxEq.mustache", "tests", "ApproxEq.hs"));
        this.supportingFiles.add(new SupportingFile("tests/Instances.mustache", "tests", "Instances.hs"));
        this.supportingFiles.add(new SupportingFile("tests/PropMime.mustache", "tests", "PropMime.hs"));
        this.supportingFiles.add(new SupportingFile("tests/Test.mustache", "tests", "Test.hs"));
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("Bool", "String", "Int", "Integer", "Float", "Char", "Double", "List", "FilePath", "Text"));
        this.typeMapping.clear();
        this.typeMapping.put("boolean", "Bool");
        this.typeMapping.put("int", "Int");
        this.typeMapping.put("long", "Integer");
        this.typeMapping.put("short", "Int");
        this.typeMapping.put("char", "Char");
        this.typeMapping.put("float", "Float");
        this.typeMapping.put("double", "Double");
        this.typeMapping.put("number", "Double");
        this.typeMapping.put("integer", "Int");
        this.typeMapping.put("file", "FilePath");
        this.typeMapping.put("string", "Text");
        this.typeMapping.put("UUID", "Text");
        this.typeMapping.put("any", "A.Value");
        this.typeMapping.put("set", "Set.Set");
        this.typeMapping.put("binary", "Binary");
        this.typeMapping.put("ByteArray", "ByteArray");
        this.typeMapping.put("date", "Date");
        this.typeMapping.put("DateTime", "DateTime");
        this.knownMimeDataTypes.put("application/json", "MimeJSON");
        this.knownMimeDataTypes.put("application/xml", "MimeXML");
        this.knownMimeDataTypes.put("application/x-www-form-urlencoded", "MimeFormUrlEncoded");
        this.knownMimeDataTypes.put("application/octet-stream", "MimeOctetStream");
        this.knownMimeDataTypes.put("multipart/form-data", "MimeMultipartFormData");
        this.knownMimeDataTypes.put("text/plain", "MimePlainText");
        this.knownMimeDataTypes.put("*/*", "MimeAny");
        this.importMapping.clear();
        this.cliOptions.add(CliOption.newString("modelPackage", "package for generated models"));
        this.cliOptions.add(CliOption.newString("apiPackage", "package for generated api classes"));
        this.cliOptions.add(CliOption.newBoolean(PROP_ALLOW_FROMJSON_NULLS, "allow JSON Null during model decoding from JSON").defaultValue(Boolean.TRUE.toString()));
        this.cliOptions.add(CliOption.newBoolean(PROP_ALLOW_TOJSON_NULLS, "allow emitting JSON Null during model encoding to JSON").defaultValue(Boolean.FALSE.toString()));
        this.cliOptions.add(CliOption.newBoolean(PROP_GENERATE_LENSES, "Generate Lens optics for Models").defaultValue(Boolean.TRUE.toString()));
        this.cliOptions.add(CliOption.newBoolean(PROP_GENERATE_MODEL_CONSTRUCTORS, "Generate smart constructors (only supply required fields) for models").defaultValue(Boolean.TRUE.toString()));
        this.cliOptions.add(CliOption.newBoolean(PROP_GENERATE_ENUMS, "Generate specific datatypes for swagger enums").defaultValue(Boolean.TRUE.toString()));
        this.cliOptions.add(CliOption.newBoolean(PROP_GENERATE_FORM_URLENCODED_INSTANCES, "Generate FromForm/ToForm instances for models that are used by operations that produce or consume application/x-www-form-urlencoded").defaultValue(Boolean.TRUE.toString()));
        this.cliOptions.add(CliOption.newBoolean(PROP_INLINE_MIME_TYPES, "Inline (hardcode) the content-type and accept parameters on operations, when there is only 1 option").defaultValue(Boolean.FALSE.toString()));
        this.cliOptions.add(CliOption.newString(PROP_MODEL_DERIVING, "Additional classes to include in the deriving() clause of Models"));
        this.cliOptions.add(CliOption.newBoolean(PROP_STRICT_FIELDS, "Add strictness annotations to all model fields").defaultValue(Boolean.TRUE.toString()));
        this.cliOptions.add(CliOption.newBoolean(PROP_USE_MONAD_LOGGER, "Use the monad-logger package to provide logging (if false, use the katip logging package)").defaultValue(Boolean.FALSE.toString()));
        this.cliOptions.add(CliOption.newString(PROP_DATETIME_FORMAT, "format string used to parse/render a datetime"));
        this.cliOptions.add(CliOption.newString(PROP_DATE_FORMAT, "format string used to parse/render a date").defaultValue(this.defaultDateFormat));
        this.cliOptions.add(CliOption.newBoolean("hideGenerationTimestamp", "hides the timestamp when files were generated").defaultValue(Boolean.TRUE.toString()));
    }

    public void setAllowFromJsonNulls(Boolean value) {
        this.additionalProperties.put(PROP_ALLOW_FROMJSON_NULLS, value);
    }

    public void setAllowToJsonNulls(Boolean value) {
        this.additionalProperties.put(PROP_ALLOW_TOJSON_NULLS, value);
    }

    public void setGenerateModelConstructors(Boolean value) {
        this.additionalProperties.put(PROP_GENERATE_MODEL_CONSTRUCTORS, value);
    }

    public void setGenerateEnums(Boolean value) {
        this.additionalProperties.put(PROP_GENERATE_ENUMS, value);
        this.genEnums = value;
    }

    public void setGenerateFormUrlEncodedInstances(Boolean value) {
        this.additionalProperties.put(PROP_GENERATE_FORM_URLENCODED_INSTANCES, value);
    }

    public void setInlineMimeTypes(Boolean value) {
        this.additionalProperties.put(PROP_INLINE_MIME_TYPES, value);
    }

    public void setGenerateLenses(Boolean value) {
        this.additionalProperties.put(PROP_GENERATE_LENSES, value);
    }

    public void setModelDeriving(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            this.additionalProperties.remove(PROP_MODEL_DERIVING);
        } else {
            this.additionalProperties.put(PROP_MODEL_DERIVING, StringUtils.join((Object[])value.split(" "), (String)","));
        }
    }

    public void setDateTimeFormat(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            this.additionalProperties.remove(PROP_DATETIME_FORMAT);
        } else {
            this.additionalProperties.put(PROP_DATETIME_FORMAT, value);
        }
    }

    public void setDateFormat(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            this.additionalProperties.remove(PROP_DATE_FORMAT);
        } else {
            this.additionalProperties.put(PROP_DATE_FORMAT, value);
        }
    }

    public void setStrictFields(Boolean value) {
        this.additionalProperties.put(X_STRICT_FIELDS, value);
    }

    public void setUseMonadLogger(Boolean value) {
        this.additionalProperties.put(X_USE_MONAD_LOGGER, value);
        this.useMonadLogger = value;
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey("hideGenerationTimestamp")) {
            this.convertPropertyToBooleanAndWriteBack("hideGenerationTimestamp");
        } else {
            this.additionalProperties.put("hideGenerationTimestamp", true);
        }
        if (this.additionalProperties.containsKey(PROP_ALLOW_FROMJSON_NULLS)) {
            this.setAllowFromJsonNulls(this.convertPropertyToBoolean(PROP_ALLOW_FROMJSON_NULLS));
        } else {
            this.setAllowFromJsonNulls(true);
        }
        if (this.additionalProperties.containsKey(PROP_ALLOW_TOJSON_NULLS)) {
            this.setAllowToJsonNulls(this.convertPropertyToBoolean(PROP_ALLOW_TOJSON_NULLS));
        } else {
            this.setAllowToJsonNulls(false);
        }
        if (this.additionalProperties.containsKey(PROP_GENERATE_MODEL_CONSTRUCTORS)) {
            this.setGenerateModelConstructors(this.convertPropertyToBoolean(PROP_GENERATE_MODEL_CONSTRUCTORS));
        } else {
            this.setGenerateModelConstructors(true);
        }
        if (this.additionalProperties.containsKey(PROP_GENERATE_ENUMS)) {
            this.setGenerateEnums(this.convertPropertyToBoolean(PROP_GENERATE_ENUMS));
        } else {
            this.setGenerateEnums(true);
        }
        if (this.additionalProperties.containsKey(PROP_GENERATE_FORM_URLENCODED_INSTANCES)) {
            this.setGenerateFormUrlEncodedInstances(this.convertPropertyToBoolean(PROP_GENERATE_FORM_URLENCODED_INSTANCES));
        } else {
            this.setGenerateFormUrlEncodedInstances(true);
        }
        if (this.additionalProperties.containsKey(PROP_INLINE_MIME_TYPES)) {
            this.setInlineMimeTypes(this.convertPropertyToBoolean(PROP_INLINE_MIME_TYPES));
        } else {
            this.setInlineMimeTypes(false);
        }
        if (this.additionalProperties.containsKey(PROP_GENERATE_LENSES)) {
            this.setGenerateLenses(this.convertPropertyToBoolean(PROP_GENERATE_LENSES));
        } else {
            this.setGenerateLenses(true);
        }
        if (this.additionalProperties.containsKey(PROP_MODEL_DERIVING)) {
            this.setModelDeriving(this.additionalProperties.get(PROP_MODEL_DERIVING).toString());
        } else {
            this.setModelDeriving("");
        }
        if (this.additionalProperties.containsKey(PROP_DATETIME_FORMAT)) {
            this.setDateTimeFormat(this.additionalProperties.get(PROP_DATETIME_FORMAT).toString());
        } else {
            this.setDateTimeFormat(null);
        }
        if (this.additionalProperties.containsKey(PROP_DATE_FORMAT)) {
            this.setDateFormat(this.additionalProperties.get(PROP_DATE_FORMAT).toString());
        } else {
            this.setDateFormat(this.defaultDateFormat);
        }
        if (this.additionalProperties.containsKey(PROP_STRICT_FIELDS)) {
            this.setStrictFields(this.convertPropertyToBoolean(PROP_STRICT_FIELDS));
        } else {
            this.setStrictFields(true);
        }
        if (this.additionalProperties.containsKey(PROP_USE_MONAD_LOGGER)) {
            this.setUseMonadLogger(this.convertPropertyToBoolean(PROP_USE_MONAD_LOGGER));
        } else {
            this.setUseMonadLogger(false);
        }
    }

    @Override
    public void preprocessOpenAPI(OpenAPI openAPI) {
        String title = openAPI.getInfo().getTitle();
        if (title == null) {
            title = "Swagger";
        } else if ((title = title.trim()).toUpperCase().endsWith("API")) {
            title = title.substring(0, title.length() - 3);
        }
        String[] words = title.split(" ");
        ArrayList<String> wordsLower = new ArrayList<String>();
        for (String string : words) {
            wordsLower.add(string.toLowerCase());
        }
        String cabalName = StringUtils.join(wordsLower, (String)"-");
        String pathsName = StringUtils.join(wordsLower, (String)"_");
        ArrayList<String> wordsCaps = new ArrayList<String>();
        for (String word : words) {
            wordsCaps.add(this.firstLetterToUpper(word));
        }
        String string = StringUtils.join(wordsCaps, (String)"");
        this.supportingFiles.add(new SupportingFile("haskell-http-client.cabal.mustache", "", cabalName + ".cabal"));
        this.supportingFiles.add(new SupportingFile("swagger.mustache", "", "swagger.yaml"));
        this.supportingFiles.add(new SupportingFile("TopLevel.mustache", "lib/", string + ".hs"));
        this.supportingFiles.add(new SupportingFile("Client.mustache", "lib/" + string, "Client.hs"));
        this.supportingFiles.add(new SupportingFile("API.mustache", "lib/" + string, "API.hs"));
        this.supportingFiles.add(new SupportingFile("Core.mustache", "lib/" + string, "Core.hs"));
        this.supportingFiles.add(new SupportingFile("Model.mustache", "lib/" + string, "Model.hs"));
        this.supportingFiles.add(new SupportingFile("MimeTypes.mustache", "lib/" + string, "MimeTypes.hs"));
        this.supportingFiles.add(new SupportingFile(this.useMonadLogger != false ? "LoggingMonadLogger.mustache" : "LoggingKatip.mustache", "lib/" + string, "Logging.hs"));
        if (((Boolean)this.additionalProperties.get(PROP_GENERATE_LENSES)).booleanValue()) {
            this.supportingFiles.add(new SupportingFile("ModelLens.mustache", "lib/" + string, "ModelLens.hs"));
        }
        this.additionalProperties.put("title", string);
        this.additionalProperties.put("titleLower", this.firstLetterToLower(string));
        this.additionalProperties.put("package", cabalName);
        this.additionalProperties.put("pathsName", pathsName);
        this.additionalProperties.put("requestType", string + "Request");
        this.additionalProperties.put("configType", string + "Config");
        this.additionalProperties.put("openApiVersion", openAPI.getOpenapi());
        try {
            String swaggerJson = Json.pretty((Object)openAPI);
            FileUtils.writeStringToFile((File)new File(this.outputFolder + File.separator + "swagger.json"), (String)swaggerJson);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e.getCause());
        }
        super.preprocessOpenAPI(openAPI);
    }

    @Override
    public Map<String, Object> postProcessSupportingFileData(Map<String, Object> objs) {
        OpenAPI openAPI = (OpenAPI)objs.get("openapi");
        if (openAPI != null) {
            try {
                objs.put("swagger-yaml", Yaml.mapper().writeValueAsString((Object)openAPI));
            }
            catch (JsonProcessingException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        return super.postProcessSupportingFileData(objs);
    }

    @Override
    public String getTypeDeclaration(Schema propertySchema) {
        if (propertySchema instanceof ArraySchema) {
            Schema inner = ((ArraySchema)propertySchema).getItems();
            return String.format("[%s]", this.getTypeDeclaration(inner));
        }
        if (propertySchema instanceof MapSchema && HaskellHttpClientCodegen.hasSchemaProperties(propertySchema)) {
            Schema inner = (Schema)propertySchema.getAdditionalProperties();
            return String.format("(Map.Map String %s)", this.getTypeDeclaration(inner));
        }
        return super.getTypeDeclaration(propertySchema);
    }

    @Override
    public String getSchemaType(Schema propertySchema) {
        String schemaType = super.getSchemaType(propertySchema);
        String type = null;
        if (this.typeMapping.containsKey(schemaType)) {
            return (String)this.typeMapping.get(schemaType);
        }
        if (this.languageSpecificPrimitives.contains(type)) {
            return type;
        }
        if (schemaType.equals("object")) {
            return "A.Value";
        }
        return this.toModelName(schemaType);
    }

    @Override
    public String toInstantiationType(Schema propertySchema) {
        if (propertySchema instanceof MapSchema && HaskellHttpClientCodegen.hasSchemaProperties(propertySchema)) {
            Schema additionalProperties2 = (Schema)propertySchema.getAdditionalProperties();
            String type = additionalProperties2.getType();
            if (null == type) {
                LOGGER.error("No Type defined for Additional Property " + additionalProperties2 + "\n\tIn Property: " + propertySchema);
            }
            String inner = this.getSchemaType(additionalProperties2);
            return "(Map.Map Text " + inner + ")";
        }
        if (propertySchema instanceof ArraySchema) {
            ArraySchema arraySchema = (ArraySchema)propertySchema;
            String inner = this.getSchemaType(arraySchema.getItems());
            return inner;
        }
        return null;
    }

    @Override
    public CodegenOperation fromOperation(String resourcePath, String httpMethod, Operation operation, Map<String, Schema> schemas, OpenAPI openAPI) {
        CodegenOperation op = super.fromOperation(resourcePath, httpMethod, operation, schemas, openAPI);
        op.vendorExtensions = new LinkedHashMap<String, Object>();
        String operationType = this.toTypeName("Op", op.operationId);
        op.vendorExtensions.put(X_OPERATION_TYPE, operationType);
        this.typeNames.add(operationType);
        op.vendorExtensions.put(X_HADDOCK_PATH, String.format("%s %s", op.httpMethod, op.path.replace("/", "\\/")));
        op.vendorExtensions.put(X_HAS_BODY_OR_FORM_PARAM, op.getHasBodyParam() || op.getHasFormParams());
        for (CodegenParameter param : op.allParams) {
            param.vendorExtensions = new LinkedHashMap<String, Object>();
            param.vendorExtensions.put(X_OPERATION_TYPE, operationType);
            boolean isBodyParam = ExtensionHelper.getBooleanValue(param, "x-is-body-param");
            boolean isFormParam = ExtensionHelper.getBooleanValue(param, "x-is-form-param");
            param.vendorExtensions.put(X_IS_BODY_OR_FORM_PARAM, isBodyParam || isFormParam);
            if (!StringUtils.isBlank((CharSequence)param.collectionFormat)) {
                param.vendorExtensions.put(X_COLLECTION_FORMAT, this.mapCollectionFormat(param.collectionFormat));
            }
            if (!param.required) {
                op.vendorExtensions.put(X_HAS_OPTIONAL_PARAMS, true);
            }
            boolean isEnum = ExtensionHelper.getBooleanValue(param, "x-is-enum");
            if (!this.typeMapping.containsKey(param.dataType) && !ExtensionHelper.getBooleanValue(param, "x-is-map-container") && !ExtensionHelper.getBooleanValue(param, "x-is-list-container") && !ExtensionHelper.getBooleanValue(param, "x-is-primitive-type") && !ExtensionHelper.getBooleanValue(param, "x-is-file") && !isEnum) continue;
            String dataType = this.genEnums != false && isEnum ? param.datatypeWithEnum : param.dataType;
            String paramNameType = this.toDedupedName(this.toTypeName("Param", param.paramName), dataType, !isEnum);
            param.vendorExtensions.put(X_PARAM_NAME_TYPE, paramNameType);
            HashMap<String, Object> props = new HashMap<String, Object>();
            props.put(X_IS_BODY_PARAM, ExtensionHelper.getBooleanValue(param, "x-is-body-param"));
            this.addToUniques(X_NEWTYPE, paramNameType, dataType, props);
        }
        this.processPathExpr(op);
        this.processProducesConsumes(op);
        this.processReturnType(op);
        return op;
    }

    @Override
    public List<CodegenSecurity> fromSecurity(Map<String, SecurityScheme> schemes) {
        List<CodegenSecurity> secs = super.fromSecurity(schemes);
        for (CodegenSecurity sec : secs) {
            String prefix = "";
            if (ExtensionHelper.getBooleanValue(sec, "x-is-basic")) {
                prefix = "AuthBasic";
            }
            if (ExtensionHelper.getBooleanValue(sec, "x-is-api-key")) {
                prefix = "AuthApiKey";
            }
            if (ExtensionHelper.getBooleanValue(sec, "x-is-oauth")) {
                prefix = "AuthOAuth";
            }
            sec.name = prefix + this.toTypeName("", sec.name);
        }
        return secs;
    }

    @Override
    public Map<String, Object> postProcessOperations(Map<String, Object> objs) {
        Map<String, Object> ret = super.postProcessOperations(objs);
        HashMap pathOps = (HashMap)ret.get("operations");
        ArrayList ops = (ArrayList)pathOps.get("operation");
        if (ops.size() > 0) {
            ((CodegenOperation)ops.get((int)0)).vendorExtensions.put(X_HAS_NEW_TAG, true);
        }
        this.updateGlobalAdditionalProps();
        return ret;
    }

    @Override
    public Map<String, Object> postProcessAllModels(Map<String, Object> objs) {
        this.updateGlobalAdditionalProps();
        return super.postProcessAllModels(objs);
    }

    public void updateGlobalAdditionalProps() {
        this.additionalProperties.put(X_HAS_UNKNOWN_MIME_TYPES, !this.unknownMimeTypes.isEmpty());
        Collections.sort(this.unknownMimeTypes, new Comparator<Map<String, String>>(){

            @Override
            public int compare(Map<String, String> o1, Map<String, String> o2) {
                return o1.get(HaskellHttpClientCodegen.MEDIA_TYPE).compareTo(o2.get(HaskellHttpClientCodegen.MEDIA_TYPE));
            }
        });
        this.additionalProperties.put(X_UNKNOWN_MIME_TYPES, this.unknownMimeTypes);
        ArrayList<Map<String, Object>> params = new ArrayList<Map<String, Object>>(this.uniqueParamNameTypes.values());
        Collections.sort(params, new Comparator<Map<String, Object>>(){

            @Override
            public int compare(Map<String, Object> o1, Map<String, Object> o2) {
                return ((String)o1.get(HaskellHttpClientCodegen.X_PARAM_NAME_TYPE)).compareTo((String)o2.get(HaskellHttpClientCodegen.X_PARAM_NAME_TYPE));
            }
        });
        this.additionalProperties.put(X_ALL_UNIQUE_PARAMS, params);
    }

    @Override
    public Map<String, Object> postProcessOperationsWithModels(Map<String, Object> objs, List<Object> allModels) {
        for (Object object : allModels) {
            HashMap h = (HashMap)object;
            CodegenModel codegenModel = (CodegenModel)h.get("model");
            if (!this.modelMimeTypes.containsKey(codegenModel.classname)) continue;
            Set<String> mimeTypes = this.modelMimeTypes.get(codegenModel.classname);
            codegenModel.vendorExtensions.put(X_MIME_TYPES, mimeTypes);
            if (!((Boolean)this.additionalProperties.get(PROP_GENERATE_FORM_URLENCODED_INSTANCES)).booleanValue() || !mimeTypes.contains("MimeFormUrlEncoded")) continue;
            Boolean hasMimeFormUrlEncoded = true;
            for (CodegenProperty codegenProperty : codegenModel.vars) {
                boolean isPrimitiveType = ExtensionHelper.getBooleanValue(codegenProperty, "x-is-primitive-type");
                boolean isString = ExtensionHelper.getBooleanValue(codegenProperty, "x-is-string");
                boolean isDate = ExtensionHelper.getBooleanValue(codegenProperty, "x-is-date");
                boolean isDateTime = ExtensionHelper.getBooleanValue(codegenProperty, "x-is-date-time");
                if (isPrimitiveType || isString || isDate || isDateTime) continue;
                hasMimeFormUrlEncoded = false;
            }
            if (!hasMimeFormUrlEncoded.booleanValue()) continue;
            codegenModel.vendorExtensions.put(X_HAS_MIME_FORM_URL_ENCODED, true);
        }
        return objs;
    }

    @Override
    public CodegenModel fromModel(String name, Schema schema, Map<String, Schema> allSchemas) {
        CodegenModel model = super.fromModel(name, schema, allSchemas);
        while (this.typeNames.contains(model.classname)) {
            model.classname = HaskellHttpClientCodegen.generateNextName(model.classname);
        }
        this.typeNames.add(model.classname);
        String prefix = StringUtils.uncapitalize((String)model.classname);
        for (CodegenProperty prop : model.vars) {
            prop.name = this.toVarName(prefix, prop.name);
        }
        return model;
    }

    @Override
    public String escapeReservedWord(String name) {
        if (this.reservedWordsMappings().containsKey(name)) {
            return this.reservedWordsMappings().get(name);
        }
        return "_" + name;
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("\"", "");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("{-", "{_-").replace("-}", "-_}");
    }

    @Override
    public boolean isDataTypeFile(String dataType) {
        return dataType != null && dataType.equals("FilePath");
    }

    @Override
    public boolean isDataTypeBinary(String dataType) {
        return dataType != null && dataType.equals("B.ByteString");
    }

    private void processReturnType(CodegenOperation codegenOperation) {
        String returnType = codegenOperation.returnType;
        if (returnType == null || returnType.equals("null")) {
            boolean hasProduces = ExtensionHelper.getBooleanValue(codegenOperation, "x-has-produces");
            if (hasProduces) {
                returnType = "res";
                codegenOperation.vendorExtensions.put(X_HAS_UNKNOWN_RETURN, true);
            } else {
                returnType = "NoContent";
                if (!codegenOperation.vendorExtensions.containsKey(X_INLINE_ACCEPT)) {
                    this.SetNoContent(codegenOperation, X_INLINE_ACCEPT);
                }
            }
        }
        if (returnType.indexOf(" ") >= 0) {
            returnType = "(" + returnType + ")";
        }
        codegenOperation.vendorExtensions.put(X_RETURN_TYPE, returnType);
    }

    private void processProducesConsumes(CodegenOperation codegenOperation) {
        boolean hasProduces;
        boolean hasConsumes;
        if (!((Boolean)codegenOperation.vendorExtensions.get(X_HAS_BODY_OR_FORM_PARAM)).booleanValue()) {
            this.SetNoContent(codegenOperation, X_INLINE_CONTENT_TYPE);
        }
        if (hasConsumes = ExtensionHelper.getBooleanValue(codegenOperation, "x-has-consumes")) {
            for (Map<String, String> m : codegenOperation.consumes) {
                this.processMediaType(codegenOperation, m);
                this.processInlineConsumesContentType(codegenOperation, m);
            }
            if (HaskellHttpClientCodegen.isMultipartOperation(codegenOperation.consumes)) {
                codegenOperation.getVendorExtensions().put("x-is-multipart", Boolean.TRUE);
            }
        }
        if (hasProduces = ExtensionHelper.getBooleanValue(codegenOperation, "x-has-produces")) {
            for (Map<String, String> m : codegenOperation.produces) {
                this.processMediaType(codegenOperation, m);
                this.processInlineProducesContentType(codegenOperation, m);
            }
        }
    }

    private void processInlineConsumesContentType(CodegenOperation op, Map<String, String> m) {
        if (op.vendorExtensions.containsKey(X_INLINE_CONTENT_TYPE)) {
            return;
        }
        if (((Boolean)this.additionalProperties.get(PROP_INLINE_MIME_TYPES)).booleanValue() && op.consumes.size() == 1) {
            op.vendorExtensions.put(X_INLINE_CONTENT_TYPE, m);
            for (CodegenParameter param : op.allParams) {
                boolean isBodyParam = ExtensionHelper.getBooleanValue(param, "x-is-body-param");
                if (!isBodyParam || !param.required) continue;
                param.vendorExtensions.put(X_INLINE_CONTENT_TYPE, m);
            }
        }
    }

    private void processInlineProducesContentType(CodegenOperation op, Map<String, String> m) {
        if (((Boolean)this.additionalProperties.get(PROP_INLINE_MIME_TYPES)).booleanValue() && op.produces.size() == 1) {
            op.vendorExtensions.put(X_INLINE_ACCEPT, m);
        }
    }

    private void SetNoContent(CodegenOperation op, String inlineExtentionName) {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put(X_MEDIA_DATA_TYPE, MIME_NO_CONTENT);
        op.vendorExtensions.put(inlineExtentionName, m);
    }

    private String toDedupedName(String paramNameType, String dataType, Boolean appendDataType) {
        if (appendDataType.booleanValue() && this.uniqueParamNameTypes.containsKey(paramNameType) && !this.isDuplicate(paramNameType, dataType).booleanValue()) {
            paramNameType = paramNameType + dataType;
        }
        while (this.typeNames.contains(paramNameType) && !this.isDuplicate(paramNameType, dataType).booleanValue()) {
            paramNameType = HaskellHttpClientCodegen.generateNextName(paramNameType);
        }
        this.typeNames.add(paramNameType);
        return paramNameType;
    }

    public Boolean isDuplicate(String paramNameType, String dataType) {
        String comparisonKey;
        String lastParamDataType;
        Map<String, Object> lastParam = this.uniqueParamNameTypes.get(paramNameType);
        if (lastParam != null && (lastParamDataType = (String)lastParam.get(comparisonKey = lastParam.containsKey(X_ENUM) ? X_ENUM_VALUES : X_DATA_TYPE)) != null && lastParamDataType.equals(dataType)) {
            return true;
        }
        return false;
    }

    private Pair<Boolean, String> isDuplicateEnumValues(String enumValues) {
        for (Map<String, Object> vs : this.uniqueParamNameTypes.values()) {
            if (!enumValues.equals(vs.get(X_ENUM_VALUES))) continue;
            return Pair.of((Object)true, (Object)((String)vs.get(X_PARAM_NAME_TYPE)));
        }
        return Pair.of((Object)false, null);
    }

    private void addToUniques(String xGroup, String paramNameType, String dataType, Map<String, Object> props) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put(X_PARAM_NAME_TYPE, paramNameType);
        m.put(X_DATA_TYPE, dataType);
        m.put(xGroup, true);
        m.putAll(props);
        this.uniqueParamNameTypes.put(paramNameType, m);
    }

    private void addEnumToUniques(String paramNameType, String datatype, String enumValues, Map<String, Object> allowableValues, String description) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("allowableValues", allowableValues);
        if (StringUtils.isNotBlank((CharSequence)description)) {
            props.put("description", description);
        }
        props.put(X_ENUM_VALUES, enumValues);
        this.addToUniques(X_ENUM, paramNameType, datatype, props);
        this.additionalProperties.put(X_HAS_ENUM_SECTION, true);
    }

    private void processPathExpr(CodegenOperation op) {
        String xPath = "[\"" + this.escapeText(op.path) + "\"]";
        if (op.getHasPathParams()) {
            for (CodegenParameter param : op.pathParams) {
                xPath = xPath.replaceAll("\\{" + param.baseName + "\\}", "\",toPath " + param.paramName + ",\"");
            }
            xPath = xPath.replaceAll(",\"\",", ",");
            xPath = xPath.replaceAll("\"\",", ",");
            xPath = xPath.replaceAll(",\"\"", ",");
            xPath = xPath.replaceAll("^\\[,", "[");
            xPath = xPath.replaceAll(",\\]$", "]");
        }
        op.vendorExtensions.put(X_PATH, xPath);
    }

    private void processMediaType(CodegenOperation op, Map<String, String> m) {
        String mediaType = m.get(MEDIA_TYPE);
        if (StringUtils.isBlank((CharSequence)mediaType)) {
            return;
        }
        String mimeType = this.getMimeDataType(mediaType);
        this.typeNames.add(mimeType);
        m.put(X_MEDIA_DATA_TYPE, mimeType);
        if (HaskellHttpClientCodegen.isJsonMimeType(mediaType)) {
            m.put(X_MEDIA_IS_JSON, "true");
        }
        if (!this.knownMimeDataTypes.containsValue(mimeType) && !this.unknownMimeTypesContainsType(mimeType).booleanValue()) {
            this.unknownMimeTypes.add(m);
        }
        for (CodegenParameter param : op.allParams) {
            boolean isBodyParam = ExtensionHelper.getBooleanValue(param, "x-is-body-param");
            boolean isFormParam = ExtensionHelper.getBooleanValue(param, "x-is-form-param");
            boolean isPrimitiveType = ExtensionHelper.getBooleanValue(param, "x-is-primitive-type");
            boolean isListContainer = ExtensionHelper.getBooleanValue(param, "x-is-list-container");
            boolean isMapContainer = ExtensionHelper.getBooleanValue(param, "x-is-map-container");
            if (!isBodyParam && (!isFormParam || isPrimitiveType || isListContainer || isMapContainer)) continue;
            HashSet<String> mimeTypes = this.modelMimeTypes.containsKey(param.dataType) ? this.modelMimeTypes.get(param.dataType) : new HashSet<String>();
            mimeTypes.add(mimeType);
            this.modelMimeTypes.put(param.dataType, mimeTypes);
        }
    }

    private Boolean unknownMimeTypesContainsType(String mimeType) {
        for (Map<String, String> m : this.unknownMimeTypes) {
            String mimeType0 = m.get(X_MEDIA_DATA_TYPE);
            if (mimeType0 == null || !mimeType0.equals(mimeType)) continue;
            return true;
        }
        return false;
    }

    public String firstLetterToUpper(String word) {
        if (word.length() == 0) {
            return word;
        }
        if (word.length() == 1) {
            return word.substring(0, 1).toUpperCase();
        }
        return word.substring(0, 1).toUpperCase() + word.substring(1);
    }

    public String firstLetterToLower(String word) {
        if (word.length() == 0) {
            return word;
        }
        if (word.length() == 1) {
            return word.substring(0, 1).toLowerCase();
        }
        return word.substring(0, 1).toLowerCase() + word.substring(1);
    }

    private String mapCollectionFormat(String collectionFormat) {
        switch (collectionFormat) {
            case "csv": {
                return "CommaSeparated";
            }
            case "tsv": {
                return "TabSeparated";
            }
            case "ssv": {
                return "SpaceSeparated";
            }
            case "pipes": {
                return "PipeSeparated";
            }
            case "multi": {
                return "MultiParamArray";
            }
        }
        throw new UnsupportedOperationException();
    }

    private String getMimeDataType(String mimeType) {
        if (StringUtils.isBlank((CharSequence)mimeType)) {
            return MIME_NO_CONTENT;
        }
        if (this.knownMimeDataTypes.containsKey(mimeType)) {
            return this.knownMimeDataTypes.get(mimeType);
        }
        String shortenedName = mimeType.replaceFirst("application/", "");
        return "Mime" + this.toTypeName("", shortenedName);
    }

    private static String generateNextName(String name) {
        Pattern pattern = Pattern.compile("\\d+\\z");
        Matcher matcher = pattern.matcher(name);
        if (matcher.find()) {
            String numStr = matcher.group();
            int num = Integer.parseInt(numStr) + 1;
            return name.substring(0, name.length() - numStr.length()) + num;
        }
        return name + "2";
    }

    private static boolean isMultipartOperation(List<Map<String, String>> consumes) {
        for (Map<String, String> consume : consumes) {
            if (consume == null || !"multipart/form-data".equals(consume.get(MEDIA_TYPE))) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toVarName(String name) {
        return this.toVarName("", name);
    }

    public String toVarName(String prefix, String name) {
        Boolean hasPrefix = !StringUtils.isBlank((CharSequence)prefix);
        name = HaskellHttpClientCodegen.underscore(this.sanitizeName(name.replaceAll("-", "_")));
        name = HaskellHttpClientCodegen.camelize(name, hasPrefix == false);
        if (hasPrefix.booleanValue()) {
            return prefix + name;
        }
        if (name.matches("^\\d.*")) {
            name = this.escapeReservedWord(name);
        }
        if (this.isReservedWord(name)) {
            name = this.escapeReservedWord(name);
        }
        return name;
    }

    @Override
    public String toParamName(String name) {
        return this.toVarName(name);
    }

    @Override
    public String toModelName(String name) {
        return this.toTypeName("Model", name);
    }

    @Override
    public String toModelFilename(String name) {
        return this.toTypeName("Model", name);
    }

    public String toTypeName(String prefix, String name) {
        name = this.escapeIdentifier(prefix, HaskellHttpClientCodegen.camelize(this.sanitizeName(name)));
        return name;
    }

    @Override
    public String toOperationId(String operationId) {
        if (StringUtils.isEmpty((CharSequence)operationId)) {
            throw new RuntimeException("Empty method/operation name (operationId) not allowed");
        }
        String uniqueName = operationId = this.escapeIdentifier("op", HaskellHttpClientCodegen.camelize(this.sanitizeName(operationId), true));
        String uniqueNameType = this.toTypeName("Op", operationId);
        while (this.typeNames.contains(uniqueNameType)) {
            uniqueName = HaskellHttpClientCodegen.generateNextName(uniqueName);
            uniqueNameType = this.toTypeName("Op", uniqueName);
        }
        this.typeNames.add(uniqueNameType);
        if (!operationId.equals(uniqueName)) {
            LOGGER.warn("generated unique operationId `" + uniqueName + "`");
        }
        return uniqueName;
    }

    public String escapeIdentifier(String prefix, String name) {
        if (StringUtils.isBlank((CharSequence)prefix)) {
            return name;
        }
        if (this.isReservedWord(name)) {
            name = prefix + name;
        }
        if (name.matches("^\\d.*")) {
            name = prefix + name;
        }
        if (this.languageSpecificPrimitives.contains(name)) {
            name = prefix + name;
        }
        if (this.typeMapping.containsValue(name)) {
            name = prefix + name;
        }
        return name;
    }

    static boolean isJsonMimeType(String mime) {
        return mime != null && JSON_MIME_PATTERN.matcher(mime).matches();
    }

    @Override
    public String toDefaultValue(Schema propertySchema) {
        if (propertySchema instanceof StringSchema) {
            if (propertySchema.getDefault() != null) {
                return String.format("\"%s\"", this.escapeText(propertySchema.getDefault().toString()));
            }
        } else if (propertySchema instanceof BooleanSchema) {
            if (propertySchema.getDefault() != null) {
                if (propertySchema.getDefault().toString().equalsIgnoreCase("false")) {
                    return "False";
                }
                return "True";
            }
        } else if (propertySchema.getDefault() != null && propertySchema.getDefault() != null) {
            return propertySchema.getDefault().toString();
        }
        return null;
    }

    @Override
    public Map<String, Object> postProcessModels(Map<String, Object> objs) {
        List models = (List)objs.get("models");
        for (Object _mo : models) {
            Map mo = (Map)_mo;
            CodegenModel cm = (CodegenModel)mo.get("model");
            boolean isEnum = ExtensionHelper.getBooleanValue(cm, "x-is-enum");
            cm.getVendorExtensions().put("x-is-enum", this.genEnums != false && isEnum);
            boolean isAlias = ExtensionHelper.getBooleanValue(cm, "x-is-alias");
            if (isAlias) {
                cm.vendorExtensions.put(X_DATA_TYPE, cm.dataType);
            }
            for (CodegenProperty var : cm.vars) {
                String datatype = this.genEnums != false && !StringUtils.isBlank((CharSequence)var.datatypeWithEnum) ? var.datatypeWithEnum : var.datatype;
                var.vendorExtensions.put(X_DATA_TYPE, datatype);
            }
        }
        return this.postProcessModelsEnum(objs);
    }

    @Override
    public Map<String, Object> postProcessModelsEnum(Map<String, Object> objs) {
        Map<String, Object> objsEnum = super.postProcessModelsEnum(objs);
        if (this.genEnums.booleanValue()) {
            List models = (List)objsEnum.get("models");
            for (Object _mo : models) {
                Map mo = (Map)_mo;
                CodegenModel cm = (CodegenModel)mo.get("model");
                boolean isEnum = ExtensionHelper.getBooleanValue(cm, "x-is-enum");
                if (!isEnum || cm.allowableValues == null) continue;
                this.updateAllowableValuesNames(cm.classname, cm.allowableValues);
                this.addEnumToUniques(cm.classname, cm.dataType, cm.allowableValues.values().toString(), cm.allowableValues, cm.description);
            }
        }
        return objsEnum;
    }

    @Override
    protected void updateDataTypeWithEnumForMap(CodegenProperty property) {
        CodegenProperty baseItem = property.items;
        boolean isMapContainer = ExtensionHelper.getBooleanValue(property, "x-is-map-container");
        boolean isListContainer = ExtensionHelper.getBooleanValue(property, "x-is-list-container");
        while (baseItem != null && (isMapContainer || isListContainer)) {
            baseItem = baseItem.items;
        }
        if (baseItem != null) {
            property.datatypeWithEnum = property.datatypeWithEnum.replace(baseItem.baseType + ")", this.toEnumName(baseItem) + ")");
            property.enumName = this.toEnumName(property);
            if (property.defaultValue != null) {
                property.defaultValue = property.defaultValue.replace(", " + property.items.baseType, ", " + this.toEnumName(property.items));
            }
        }
    }

    @Override
    public String toEnumName(CodegenProperty var) {
        if (!this.genEnums.booleanValue()) {
            return super.toEnumName(var);
        }
        if (var.items != null && ExtensionHelper.getBooleanValue(var.items, "x-is-enum")) {
            return this.toEnumName(var.items);
        }
        String paramNameType = "E'" + this.toTypeName("", var.name);
        String enumValues = var._enum.toString();
        Pair<Boolean, String> duplicateEnum = this.isDuplicateEnumValues(enumValues);
        if (((Boolean)duplicateEnum.getLeft()).booleanValue()) {
            paramNameType = (String)duplicateEnum.getRight();
        } else {
            var.datatypeWithEnum = paramNameType = this.toDedupedName(paramNameType, enumValues, false);
            this.updateCodegenPropertyEnum(var);
            this.addEnumToUniques(paramNameType, var.datatype, enumValues, var.allowableValues, var.description);
        }
        return paramNameType;
    }

    public void updateCodegenPropertyEnum(CodegenProperty var) {
        ModelUtils.updateCodegenPropertyEnum(var);
        if (!this.genEnums.booleanValue()) {
            return;
        }
        this.updateCodegenPropertyEnumValues(var, var.datatypeWithEnum);
    }

    public void updateCodegenPropertyEnumValues(CodegenProperty var, String paramNameType) {
        if (var.items != null && var.items.allowableValues != null) {
            this.updateCodegenPropertyEnumValues(var.items, var.items.datatypeWithEnum);
            return;
        }
        boolean isEnum = ExtensionHelper.getBooleanValue(var, "x-is-enum");
        if (isEnum && var.allowableValues != null) {
            this.updateAllowableValuesNames(paramNameType, var.allowableValues);
        }
    }

    private void updateAllowableValuesNames(String paramNameType, Map<String, Object> allowableValues) {
        if (allowableValues == null) {
            return;
        }
        for (Map enumVar : (List)allowableValues.get("enumVars")) {
            enumVar.put("name", paramNameType + (String)enumVar.get("name"));
        }
    }

    @Override
    public String toEnumVarName(String value, String datatype) {
        if (!this.genEnums.booleanValue()) {
            return super.toEnumVarName(value, datatype);
        }
        ArrayList<String> num = new ArrayList<String>(Arrays.asList("integer", "int", "double", "long", "float"));
        if (value.length() == 0) {
            return "'Empty";
        }
        if (this.getSymbolName(value) != null) {
            return "'" + StringUtils.capitalize((String)this.sanitizeName(this.getSymbolName(value)));
        }
        if (num.contains(datatype.toLowerCase())) {
            String varName = "Num" + value;
            varName = varName.replaceAll("-", "Minus_");
            varName = varName.replaceAll("\\+", "Plus_");
            varName = varName.replaceAll("\\.", "_Dot_");
            return "'" + StringUtils.capitalize((String)this.sanitizeName(varName));
        }
        return "'" + StringUtils.capitalize((String)this.sanitizeName(value));
    }

    @Override
    public String toEnumValue(String value, String datatype) {
        ArrayList<String> num = new ArrayList<String>(Arrays.asList("integer", "int", "double", "long", "float"));
        if (num.contains(datatype.toLowerCase())) {
            return value;
        }
        return "\"" + this.escapeText(value) + "\"";
    }

    @Override
    public String escapeText(String input) {
        if (input == null) {
            return input;
        }
        return this.escapeUnsafeCharacters(StringEscapeUtils.unescapeJava((String)StringEscapeUtils.escapeJava((String)input).replace("\\/", "/")).replaceAll("[\\t\\n\\r]", " ").replace("\\", "\\\\").replace("\"", "\\\""));
    }
}

