/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.languages;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.samskivert.mustache.Escapers;
import com.samskivert.mustache.Mustache;
import io.swagger.codegen.CliOption;
import io.swagger.codegen.CodegenConfig;
import io.swagger.codegen.CodegenModel;
import io.swagger.codegen.CodegenOperation;
import io.swagger.codegen.CodegenParameter;
import io.swagger.codegen.CodegenProperty;
import io.swagger.codegen.CodegenSecurity;
import io.swagger.codegen.DefaultCodegen;
import io.swagger.codegen.languages.helpers.ExtensionHelper;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.DateSchema;
import io.swagger.v3.oas.models.media.DateTimeSchema;
import io.swagger.v3.oas.models.media.FileSchema;
import io.swagger.v3.oas.models.media.MapSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.responses.ApiResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public abstract class AbstractAdaCodegen
extends DefaultCodegen
implements CodegenConfig {
    protected String packageName = "swagger";
    protected String projectName = "Swagger";
    protected List<Map<String, Object>> orderedModels;
    protected Map<String, List<String>> modelDepends;
    protected Map<String, String> nullableTypeMapping;
    protected HashMap<String, String> operationsScopes;
    protected int scopeIndex = 0;

    public AbstractAdaCodegen() {
        this.setReservedWordsLowerCase(Arrays.asList("abort", "abs", "abstract", "accept", "access", "aliased", "all", "and", "array", "at", "begin", "body", "case", "constant", "declare", "delay", "digits", "do", "else", "elsif", "end", "entry", "exception", "exit", "for", "function", "generic", "goto", "if", "in", "interface", "is", "limited", "loop", "mod", "new", "not", "null", "of", "or", "others", "out", "overriding", "package", "pragma", "private", "procedure", "protected", "raise", "range", "record", "rem", "renames", "requeue", "return", "reverse", "select", "separate", "some", "subtype", "synchronized", "tagged", "task", "terminate", "then", "type", "until", "use", "when", "while", "with", "xor"));
        this.typeMapping = new HashMap();
        this.typeMapping.put("date", "Swagger.Date");
        this.typeMapping.put("DateTime", "Swagger.Datetime");
        this.typeMapping.put("string", "Swagger.UString");
        this.typeMapping.put("integer", "Integer");
        this.typeMapping.put("long", "Swagger.Long");
        this.typeMapping.put("boolean", "Boolean");
        this.typeMapping.put("array", "Swagger.Vector");
        this.typeMapping.put("map", "Swagger.Map");
        this.typeMapping.put("object", "Swagger.Object");
        this.typeMapping.put("number", "Swagger.Number");
        this.typeMapping.put("UUID", "Swagger.UString");
        this.typeMapping.put("file", "Swagger.Http_Content_Type");
        this.typeMapping.put("binary", "Swagger.Binary");
        this.nullableTypeMapping = new HashMap<String, String>();
        this.nullableTypeMapping.put("date", "Swagger.Nullable_Date");
        this.nullableTypeMapping.put("DateTime", "Swagger.Nullable_Date");
        this.nullableTypeMapping.put("string", "Swagger.Nullable_UString");
        this.nullableTypeMapping.put("integer", "Swagger.Nullable_Integer");
        this.nullableTypeMapping.put("long", "Swagger.Nullable_Long");
        this.nullableTypeMapping.put("boolean", "Swagger.Nullable_Boolean");
        this.nullableTypeMapping.put("object", "Swagger.Object");
        this.modelDepends = new HashMap<String, List<String>>();
        this.orderedModels = new ArrayList<Map<String, Object>>();
        this.operationsScopes = new HashMap();
        this.importMapping = new HashMap<String, String>();
        this.addOption("projectName", "GNAT project name", this.projectName);
        this.modelNameSuffix = "_Type";
        this.templateDir = "Ada";
        this.embeddedTemplateDir = "Ada";
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("integer", "boolean", "Integer", "Character", "Boolean", "long", "float", "double"));
    }

    protected void addOption(String key, String description, String defaultValue) {
        CliOption option = new CliOption(key, description);
        if (defaultValue != null) {
            option.defaultValue(defaultValue);
        }
        this.cliOptions.add(option);
    }

    public String toFilename(String name) {
        return name.replace(".", "-").toLowerCase();
    }

    protected String toAdaIdentifier(String name, String prefix) {
        if (this.isReservedWord(name)) {
            LOGGER.warn("Identifier '" + name + "' is a reserved word, renamed to " + prefix + name);
            name = prefix + name;
        }
        StringBuilder result = new StringBuilder();
        boolean needUpperCase = true;
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (needUpperCase) {
                needUpperCase = false;
                result.append(Character.toUpperCase(c));
                continue;
            }
            if (Character.isUpperCase(c)) {
                if (!needUpperCase) {
                    result.append('_');
                }
                result.append(c);
                needUpperCase = false;
                continue;
            }
            result.append(c);
            if (c != '_') continue;
            needUpperCase = true;
        }
        return result.toString();
    }

    @Override
    public String toOperationId(String operationId) {
        return this.toAdaIdentifier(this.sanitizeName(operationId), "Call_");
    }

    @Override
    public String toVarName(String name) {
        return this.toAdaIdentifier(this.sanitizeName(name), "P_");
    }

    @Override
    public String toParamName(String name) {
        return this.toAdaIdentifier(super.toParamName(name), "P_");
    }

    @Override
    public String toModelName(String name) {
        String result = super.toModelName(name);
        if (result.matches("^\\d.*") || result.startsWith("_")) {
            result = "Model_" + result;
        }
        return result.replaceAll("[\\.-]", "_").replaceAll("__+", "_");
    }

    @Override
    public CodegenProperty fromProperty(String name, Schema schema) {
        CodegenProperty property = super.fromProperty(name, schema);
        String nameInCamelCase = property.nameInCamelCase;
        property.nameInCamelCase = nameInCamelCase = this.sanitizeName(nameInCamelCase);
        return property;
    }

    @Override
    public String escapeReservedWord(String name) {
        return "p_" + name;
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("\"", "");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("*/", "*_/").replace("/*", "/_*").replace("-", "_");
    }

    @Override
    public Mustache.Compiler processCompiler(Mustache.Compiler compiler) {
        compiler = super.processCompiler(compiler).emptyStringIsFalse(true);
        return compiler.withEscaper(Escapers.NONE);
    }

    @Override
    public String getTypeDeclaration(Schema property) {
        String schemaType = this.getSchemaType(property);
        if (schemaType != null) {
            schemaType = schemaType.replace("-", "_");
        }
        if (property instanceof ArraySchema) {
            ArraySchema arraySchema = (ArraySchema)property;
            Schema inner = arraySchema.getItems();
            return this.getTypeDeclaration(inner) + "_Vectors.Vector";
        }
        if (property instanceof MapSchema && AbstractAdaCodegen.hasSchemaProperties(property)) {
            MapSchema mapSchema = (MapSchema)property;
            Schema inner = (Schema)mapSchema.getAdditionalProperties();
            String name = this.getTypeDeclaration(inner) + "_Map";
            if (name.startsWith("Swagger.")) {
                return name;
            }
            return "Swagger." + name;
        }
        if (this.typeMapping.containsKey(schemaType)) {
            // empty if block
        }
        if (this.languageSpecificPrimitives.contains(schemaType)) {
            return schemaType;
        }
        String modelType = this.toModelName(schemaType).replace("-", "_");
        if (property instanceof StringSchema || property instanceof DateSchema || property instanceof DateTimeSchema || property instanceof FileSchema || this.languageSpecificPrimitives.contains(modelType)) {
            return modelType;
        }
        return this.modelPackage + ".Models." + modelType;
    }

    @Override
    public void postProcessParameter(CodegenParameter parameter) {
        super.postProcessParameter(parameter);
        if (parameter.dataType == null) {
            return;
        }
        boolean isModel = parameter.dataType.startsWith(this.modelPackage);
        if (!(isModel || ExtensionHelper.getBooleanValue(parameter, "x-is-primitive-type") || ExtensionHelper.getBooleanValue(parameter, "x-is-date") || ExtensionHelper.getBooleanValue(parameter, "x-is-string") || ExtensionHelper.getBooleanValue(parameter, "x-is-container") || ExtensionHelper.getBooleanValue(parameter, "x-is-file"))) {
            isModel = true;
        }
        parameter.vendorExtensions.put("x-is-model-type", isModel);
    }

    protected int postProcessMediaTypes(List<Map<String, String>> types) {
        int count = 0;
        if (types != null) {
            for (Map<String, String> media : types) {
                String mt = media.get("mediaType");
                if (mt == null) continue;
                mt = mt.replace('/', '_');
                media.put("adaMediaType", mt.toUpperCase());
                ++count;
            }
        }
        return count;
    }

    @Override
    public CodegenOperation fromOperation(String path, String httpMethod, Operation operation, Map<String, Schema> definitions, OpenAPI openAPI) {
        Schema schema;
        ApiResponse methodResponse;
        CodegenOperation codegenOperation = super.fromOperation(path, httpMethod, operation, definitions, openAPI);
        if (operation.getResponses() != null && !operation.getResponses().isEmpty() && (methodResponse = this.findMethodResponse(operation.getResponses())) != null && (schema = this.getSchemaFromResponse(methodResponse)) != null) {
            CodegenProperty codegenProperty = this.fromProperty("response", schema);
            codegenOperation.vendorExtensions.put("x-codegen-response", codegenProperty);
            if (codegenProperty.datatype == "HttpContent") {
                codegenOperation.vendorExtensions.put("x-codegen-response-ishttpcontent", true);
            }
        }
        return codegenOperation;
    }

    @Override
    public Map<String, Object> postProcessOperations(Map<String, Object> objs) {
        Map operations = (Map)objs.get("operations");
        List operationList = (List)operations.get("operation");
        for (CodegenOperation codegenOperation : operationList) {
            if (codegenOperation.summary != null) {
                codegenOperation.summary = codegenOperation.summary.trim();
            }
            if (codegenOperation.notes != null) {
                codegenOperation.notes = codegenOperation.notes.trim();
            }
            codegenOperation.vendorExtensions.put("x-has-uniq-produces", this.postProcessMediaTypes(codegenOperation.produces) == 1);
            codegenOperation.vendorExtensions.put("x-has-uniq-consumes", this.postProcessMediaTypes(codegenOperation.consumes) == 1);
            codegenOperation.vendorExtensions.put("x-has-notes", codegenOperation.notes != null && codegenOperation.notes.length() > 0);
            for (CodegenParameter codegenParameter : codegenOperation.allParams) {
                if (!ExtensionHelper.getBooleanValue(codegenParameter, "x-is-form-param") || !ExtensionHelper.getBooleanValue(codegenParameter, "x-is-file")) continue;
                codegenParameter.dataType = "Swagger.File_Part_Type";
            }
            for (CodegenParameter codegenParameter : codegenOperation.formParams) {
                if (!ExtensionHelper.getBooleanValue(codegenParameter, "x-is-file")) continue;
                codegenParameter.dataType = "Swagger.File_Part_Type";
            }
            this.postProcessAuthMethod(codegenOperation.authMethods);
            for (CodegenParameter p : codegenOperation.pathParams) {
                String path = codegenOperation.path;
                int pos = 0;
                int index = 0;
                while (pos >= 0 && pos < path.length() && (pos = path.indexOf(123, pos)) >= 0) {
                    int last = path.indexOf(125, ++pos);
                    ++index;
                    if (last < 0 || path.substring(pos, last - 1) == p.baseName) break;
                    pos = last + 1;
                }
                p.vendorExtensions.put("x-path-index", index);
            }
        }
        return objs;
    }

    @Override
    public Map<String, Object> postProcessModels(Map<String, Object> objs) {
        List models = (List)objs.get("models");
        for (Map modelMap : models) {
            Object model = modelMap.get("model");
            if (!(model instanceof CodegenModel)) continue;
            CodegenModel codegenModel = (CodegenModel)model;
            ArrayList<String> d = new ArrayList<String>();
            for (CodegenProperty codegenProperty : codegenModel.allVars) {
                boolean isModel = false;
                CodegenProperty item = codegenProperty;
                if (ExtensionHelper.getBooleanValue(codegenProperty, "x-is-container")) {
                    item = codegenProperty.items;
                }
                if (!(item == null || ExtensionHelper.getBooleanValue(item, "x-is-string") || ExtensionHelper.getBooleanValue(item, "x-is-primitive-type") || ExtensionHelper.getBooleanValue(item, "x-is-container") || ExtensionHelper.getBooleanValue(item, "x-is-integer") || d.contains(item.datatype))) {
                    d.add(item.datatype);
                    isModel = true;
                }
                codegenProperty.vendorExtensions.put("x-is-model-type", isModel);
            }
            this.modelDepends.put(codegenModel.name, d);
            this.orderedModels.add(modelMap);
        }
        final Map<String, List<String>> deps = this.modelDepends;
        Collections.sort(this.orderedModels, new Comparator<Map<String, Object>>(){

            @Override
            public int compare(Map<String, Object> lhs, Map<String, Object> rhs) {
                List rhsList;
                Object v = lhs.get("model");
                String lhsName = ((CodegenModel)v).name;
                v = rhs.get("model");
                String rhsName = ((CodegenModel)v).name;
                List lhsList = (List)deps.get(lhsName);
                if (lhsList == (rhsList = (List)deps.get(rhsName))) {
                    return lhsName.compareTo(rhsName);
                }
                if (lhsList == null) {
                    return -1;
                }
                if (rhsList == null) {
                    return 1;
                }
                if (lhsList.contains(rhsName)) {
                    return 1;
                }
                if (rhsList.contains(lhsName)) {
                    return -1;
                }
                if (lhsList.size() < rhsList.size()) {
                    return -1;
                }
                if (lhsList.size() > rhsList.size()) {
                    return 1;
                }
                return lhsName.compareTo(rhsName);
            }
        });
        return this.postProcessModelsEnum(objs);
    }

    @Override
    public Map<String, Object> postProcessSupportingFileData(Map<String, Object> objs) {
        objs.put("orderedModels", this.orderedModels);
        OpenAPI openAPI = (OpenAPI)objs.get("openapi");
        if (openAPI != null) {
            try {
                objs.put("openapi-json", Json.pretty().writeValueAsString((Object)openAPI).replace("\r\n", "\n"));
            }
            catch (JsonProcessingException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        List authMethods = (List)objs.get("authMethods");
        this.postProcessAuthMethod(authMethods);
        return super.postProcessSupportingFileData(objs);
    }

    private void postProcessAuthMethod(List<CodegenSecurity> authMethods) {
        if (authMethods != null) {
            for (CodegenSecurity authMethod : authMethods) {
                if (authMethod.scopes != null) {
                    String name = (String)authMethod.scopes.get((Object)"scope");
                    if (this.operationsScopes.containsKey(name)) {
                        authMethod.scopes.put((Object)"ident", (Object)this.operationsScopes.get(name));
                    } else {
                        String ident;
                        if (name.startsWith("https://")) {
                            int pos = name.lastIndexOf(47);
                            ident = name.substring(pos + 1);
                        } else {
                            ident = name;
                        }
                        ++this.scopeIndex;
                        ident = this.toAdaIdentifier(this.sanitizeName(ident.replaceAll(":", "_")), "S_");
                        if (this.operationsScopes.containsValue(ident)) {
                            ident = ident + "_" + this.scopeIndex;
                        }
                        this.operationsScopes.put(name, ident);
                        authMethod.scopes.put((Object)"ident", (Object)ident);
                    }
                }
                authMethod.name = AbstractAdaCodegen.camelize(this.sanitizeName(authMethod.name), true);
            }
        }
    }
}

