/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.languages.swift;

import io.swagger.codegen.CliOption;
import io.swagger.codegen.CodegenModel;
import io.swagger.codegen.CodegenProperty;
import io.swagger.codegen.SupportingFile;
import io.swagger.codegen.languages.swift.AbstractSwiftCodegen;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Swift4Codegen
extends AbstractSwiftCodegen {
    public Swift4Codegen() {
        this.reservedWords = new HashSet<String>(Arrays.asList("ErrorResponse", "Response", "id", "description", "NSArray", "NSURL", "CGFloat", "NSSet", "NSString", "NSInteger", "NSUInteger", "NSError", "NSDictionary", "associatedtype", "class", "deinit", "enum", "extension", "fileprivate", "func", "import", "init", "inout", "internal", "let", "open", "operator", "private", "protocol", "public", "static", "struct", "subscript", "typealias", "var", "break", "case", "continue", "default", "defer", "do", "else", "fallthrough", "for", "guard", "if", "in", "repeat", "return", "switch", "where", "while", "as", "Any", "catch", "false", "is", "nil", "rethrows", "super", "self", "Self", "throw", "throws", "true", "try", "_", "#available", "#colorLiteral", "#column", "#else", "#elseif", "#endif", "#file", "#fileLiteral", "#function", "#if", "#imageLiteral", "#line", "#selector", "#sourceLocation", "associativity", "convenience", "dynamic", "didSet", "final", "get", "infix", "indirect", "lazy", "left", "mutating", "none", "nonmutating", "optional", "override", "postfix", "precedence", "prefix", "Protocol", "required", "right", "set", "Type", "unowned", "weak", "willSet", "Bool", "Int", "Double", "Float", "Range", "ClosedRange", "Error", "Optional", "UInt", "UInt8", "UInt16", "UInt32", "UInt64", "Int8", "Int16", "Int32", "Int64", "Float80", "Float32", "Float64", "String", "Character", "Unicode", "StaticString", "Array", "Dictionary", "Set", "OptionSet", "CountableRange", "CountableClosedRange", "URL", "Data", "Codable", "Encodable", "Decodable", "Void", "AnyObject", "Class", "dynamicType", "COLUMN", "FILE", "FUNCTION", "LINE"));
        this.typeMapping = new HashMap();
        this.typeMapping.put("array", "Array");
        this.typeMapping.put("List", "Array");
        this.typeMapping.put("map", "Dictionary");
        this.typeMapping.put("date", "Date");
        this.typeMapping.put("Date", "Date");
        this.typeMapping.put("DateTime", "Date");
        this.typeMapping.put("boolean", "Bool");
        this.typeMapping.put("string", "String");
        this.typeMapping.put("char", "Character");
        this.typeMapping.put("short", "Int");
        this.typeMapping.put("int", "Int");
        this.typeMapping.put("long", "Int64");
        this.typeMapping.put("integer", "Int");
        this.typeMapping.put("Integer", "Int");
        this.typeMapping.put("float", "Float");
        this.typeMapping.put("number", "Double");
        this.typeMapping.put("double", "Double");
        this.typeMapping.put("object", "Any");
        this.typeMapping.put("file", "URL");
        this.typeMapping.put("binary", "Data");
        this.typeMapping.put("ByteArray", "Data");
        this.typeMapping.put("UUID", "UUID");
        this.cliOptions.add(new CliOption("projectName", "Project name in Xcode"));
        this.cliOptions.add(new CliOption("responseAs", "Optionally use libraries to manage response.  Currently " + StringUtils.join((Object[])RESPONSE_LIBRARIES, (String)", ") + " are available."));
        this.cliOptions.add(new CliOption("unwrapRequired", "Treat 'required' properties in response as non-optional (which would crash the app if api returns null as opposed to required option specified in json schema"));
        this.cliOptions.add(new CliOption("objcCompatible", "Add additional properties and methods for Objective-C compatibility (default: false)"));
        this.cliOptions.add(new CliOption("podSource", "Source information used for Podspec"));
        this.cliOptions.add(new CliOption("podVersion", "Version used for Podspec"));
        this.cliOptions.add(new CliOption("podAuthors", "Authors used for Podspec"));
        this.cliOptions.add(new CliOption("podSocialMediaURL", "Social Media URL used for Podspec"));
        this.cliOptions.add(new CliOption("podDocsetURL", "Docset URL used for Podspec"));
        this.cliOptions.add(new CliOption("podLicense", "License used for Podspec"));
        this.cliOptions.add(new CliOption("podHomepage", "Homepage used for Podspec"));
        this.cliOptions.add(new CliOption("podSummary", "Summary used for Podspec"));
        this.cliOptions.add(new CliOption("podDescription", "Description used for Podspec"));
        this.cliOptions.add(new CliOption("podScreenshots", "Screenshots used for Podspec"));
        this.cliOptions.add(new CliOption("podDocumentationURL", "Documentation URL used for Podspec"));
        this.cliOptions.add(new CliOption("swiftUseApiNamespace", "Flag to make all the API classes inner-class of {{projectName}}API"));
        this.cliOptions.add(new CliOption("hideGenerationTimestamp", "Hides the generation timestamp when files are generated.").defaultValue(Boolean.TRUE.toString()));
        this.cliOptions.add(new CliOption("lenientTypeCast", "Accept and cast values for simple types (string->bool, string->int, int->string)").defaultValue(Boolean.FALSE.toString()));
    }

    public String getName() {
        return "swift4";
    }

    @Override
    public void processOpts() {
        super.processOpts();
        this.supportingFiles.add(new SupportingFile("CodableHelper.mustache", this.sourceFolder, "CodableHelper.swift"));
        this.supportingFiles.add(new SupportingFile("JSONEncodableEncoding.mustache", this.sourceFolder, "JSONEncodableEncoding.swift"));
        this.supportingFiles.add(new SupportingFile("JSONEncodingHelper.mustache", this.sourceFolder, "JSONEncodingHelper.swift"));
    }

    @Override
    public Map<String, Object> postProcessModels(Map<String, Object> objs) {
        Map<String, Object> postProcessedModelsEnum = this.postProcessModelsEnum(objs);
        List models = (List)postProcessedModelsEnum.get("models");
        for (Object _mo : models) {
            Map mo = (Map)_mo;
            CodegenModel cm = (CodegenModel)mo.get("model");
            boolean modelHasPropertyWithEscapedName = false;
            for (CodegenProperty prop : cm.allVars) {
                if (prop.name.equals(prop.baseName)) continue;
                prop.vendorExtensions.put("x-codegen-escaped-property-name", true);
                modelHasPropertyWithEscapedName = true;
            }
            if (!modelHasPropertyWithEscapedName) continue;
            cm.vendorExtensions.put("x-codegen-has-escaped-property-names", true);
        }
        return postProcessedModelsEnum;
    }
}

