/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.v3.jaxrs2;

import io.swagger.v3.core.converter.ModelConverters;
import io.swagger.v3.core.converter.ResolvedSchema;
import io.swagger.v3.core.util.AnnotationsUtils;
import io.swagger.v3.oas.annotations.headers.Header;
import io.swagger.v3.oas.annotations.links.Link;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Encoding;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import java.util.Map;
import java.util.Optional;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import org.apache.commons.lang3.StringUtils;

public class OperationParser {
    public static final String COMPONENTS_REF = "#/components/schemas/";

    public static Optional<RequestBody> getRequestBody(io.swagger.v3.oas.annotations.parameters.RequestBody requestBody, Consumes classConsumes, Consumes methodConsumes, Components components) {
        if (requestBody == null) {
            return Optional.empty();
        }
        RequestBody requestBodyObject = new RequestBody();
        boolean isEmpty = true;
        if (StringUtils.isNotBlank((CharSequence)requestBody.description())) {
            requestBodyObject.setDescription(requestBody.description());
            isEmpty = false;
        }
        if (requestBody.required()) {
            requestBodyObject.setRequired(Boolean.valueOf(requestBody.required()));
            isEmpty = false;
        }
        if (isEmpty) {
            return Optional.empty();
        }
        OperationParser.getContent(requestBody.content(), classConsumes == null ? new String[]{} : classConsumes.value(), methodConsumes == null ? new String[]{} : methodConsumes.value(), components).ifPresent(arg_0 -> ((RequestBody)requestBodyObject).setContent(arg_0));
        return Optional.of(requestBodyObject);
    }

    public static Optional<ApiResponses> getApiResponses(io.swagger.v3.oas.annotations.responses.ApiResponse[] responses, Produces classProduces, Produces methodProduces, Components components) {
        if (responses == null) {
            return Optional.empty();
        }
        ApiResponses apiResponsesObject = new ApiResponses();
        for (io.swagger.v3.oas.annotations.responses.ApiResponse response : responses) {
            ApiResponse apiResponseObject = new ApiResponse();
            if (StringUtils.isNotBlank((CharSequence)response.description())) {
                apiResponseObject.setDescription(response.description());
            }
            OperationParser.getContent(response.content(), classProduces == null ? new String[]{} : classProduces.value(), methodProduces == null ? new String[]{} : methodProduces.value(), components).ifPresent(arg_0 -> ((ApiResponse)apiResponseObject).content(arg_0));
            AnnotationsUtils.getHeaders((Header[])response.headers()).ifPresent(arg_0 -> ((ApiResponse)apiResponseObject).headers(arg_0));
            if (!StringUtils.isNotBlank((CharSequence)apiResponseObject.getDescription()) && apiResponseObject.getContent() == null && apiResponseObject.getHeaders() == null) continue;
            Map links = AnnotationsUtils.getLinks((Link[])response.links());
            if (links.size() > 0) {
                apiResponseObject.setLinks(links);
            }
            if (StringUtils.isNotBlank((CharSequence)response.responseCode())) {
                apiResponsesObject.addApiResponse(response.responseCode(), apiResponseObject);
                continue;
            }
            apiResponsesObject._default(apiResponseObject);
        }
        if (apiResponsesObject.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(apiResponsesObject);
    }

    public static Optional<Content> getContent(io.swagger.v3.oas.annotations.media.Content[] annotationContents, String[] classTypes, String[] methodTypes, Components components) {
        if (annotationContents == null) {
            return Optional.empty();
        }
        Content content = new Content();
        for (io.swagger.v3.oas.annotations.media.Content annotationContent : annotationContents) {
            Encoding[] encodings;
            ExampleObject[] examples;
            MediaType mediaType = new MediaType();
            OperationParser.getSchema(annotationContent, components).ifPresent(arg_0 -> ((MediaType)mediaType).setSchema(arg_0));
            for (ExampleObject example : examples = annotationContent.examples()) {
                AnnotationsUtils.getExample((ExampleObject)example).ifPresent(exampleObject -> mediaType.addExamples(example.name(), exampleObject));
            }
            for (Encoding encoding : encodings = annotationContent.encoding()) {
                AnnotationsUtils.addEncodingToMediaType((MediaType)mediaType, (Encoding)encoding);
            }
            if (StringUtils.isNotBlank((CharSequence)annotationContent.mediaType())) {
                content.addMediaType(annotationContent.mediaType(), mediaType);
                continue;
            }
            if (mediaType.getSchema() == null) continue;
            AnnotationsUtils.applyTypes((String[])classTypes, (String[])methodTypes, (Content)content, (MediaType)mediaType);
        }
        if (content.size() == 0) {
            return Optional.empty();
        }
        return Optional.of(content);
    }

    public static Optional<? extends io.swagger.v3.oas.models.media.Schema> getSchema(io.swagger.v3.oas.annotations.media.Content annotationContent, Components components) {
        Class schemaImplementation = annotationContent.schema().implementation();
        boolean isArray = false;
        if (schemaImplementation == Void.class && (schemaImplementation = annotationContent.array().schema().implementation()) != Void.class) {
            isArray = true;
        }
        return OperationParser.getSchema(annotationContent.schema(), annotationContent.array(), isArray, schemaImplementation, components);
    }

    public static Optional<? extends io.swagger.v3.oas.models.media.Schema> getSchema(Schema schemaAnnotation, ArraySchema arrayAnnotation, boolean isArray, Class<?> schemaImplementation, Components components) {
        if (schemaImplementation != Void.class) {
            io.swagger.v3.oas.models.media.Schema schemaObject = new io.swagger.v3.oas.models.media.Schema();
            if (schemaImplementation.getName().startsWith("java.lang")) {
                schemaObject.setType(schemaImplementation.getSimpleName().toLowerCase());
            } else {
                ResolvedSchema resolvedSchema = ModelConverters.getInstance().readAllAsResolvedSchema(schemaImplementation);
                if (resolvedSchema != null) {
                    Map schemaMap = resolvedSchema.referencedSchemas;
                    schemaMap.forEach((key, schema) -> components.addSchemas(key, schema));
                    schemaObject.set$ref(COMPONENTS_REF + resolvedSchema.schema.getName());
                }
            }
            if (StringUtils.isBlank((CharSequence)schemaObject.get$ref()) && StringUtils.isBlank((CharSequence)schemaObject.getType())) {
                schemaObject.setType("string");
            }
            if (isArray) {
                Optional arraySchema = AnnotationsUtils.getArraySchema((ArraySchema)arrayAnnotation, (Components)components);
                if (arraySchema.isPresent()) {
                    ((io.swagger.v3.oas.models.media.ArraySchema)arraySchema.get()).setItems(schemaObject);
                    return arraySchema;
                }
                return Optional.empty();
            }
            return Optional.of(schemaObject);
        }
        Optional schemaFromAnnotation = AnnotationsUtils.getSchemaFromAnnotation((Schema)schemaAnnotation, (Components)components);
        if (schemaFromAnnotation.isPresent()) {
            if (StringUtils.isBlank((CharSequence)((io.swagger.v3.oas.models.media.Schema)schemaFromAnnotation.get()).get$ref()) && StringUtils.isBlank((CharSequence)((io.swagger.v3.oas.models.media.Schema)schemaFromAnnotation.get()).getType())) {
                ((io.swagger.v3.oas.models.media.Schema)schemaFromAnnotation.get()).setType("string");
            }
            return Optional.of(schemaFromAnnotation.get());
        }
        Optional arraySchemaFromAnnotation = AnnotationsUtils.getArraySchema((ArraySchema)arrayAnnotation, (Components)components);
        if (arraySchemaFromAnnotation.isPresent()) {
            if (StringUtils.isBlank((CharSequence)((io.swagger.v3.oas.models.media.ArraySchema)arraySchemaFromAnnotation.get()).getItems().get$ref()) && StringUtils.isBlank((CharSequence)((io.swagger.v3.oas.models.media.ArraySchema)arraySchemaFromAnnotation.get()).getItems().getType())) {
                ((io.swagger.v3.oas.models.media.ArraySchema)arraySchemaFromAnnotation.get()).getItems().setType("string");
            }
            return Optional.of(arraySchemaFromAnnotation.get());
        }
        return Optional.empty();
    }
}

