/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.v3.generators.dotnet;

import com.github.jknack.handlebars.Handlebars;
import com.google.common.collect.ImmutableMap;
import io.swagger.codegen.v3.CodegenConstants;
import io.swagger.codegen.v3.CodegenModel;
import io.swagger.codegen.v3.CodegenOperation;
import io.swagger.codegen.v3.CodegenProperty;
import io.swagger.codegen.v3.VendorExtendable;
import io.swagger.codegen.v3.generators.DefaultCodegenConfig;
import io.swagger.codegen.v3.generators.handlebars.ExtensionHelper;
import io.swagger.codegen.v3.generators.handlebars.csharp.CsharpHelper;
import io.swagger.codegen.v3.generators.handlebars.lambda.CamelCaseLambda;
import io.swagger.codegen.v3.generators.handlebars.lambda.IndentedLambda;
import io.swagger.codegen.v3.generators.handlebars.lambda.LowercaseLambda;
import io.swagger.codegen.v3.generators.handlebars.lambda.TitlecaseLambda;
import io.swagger.codegen.v3.generators.handlebars.lambda.UppercaseLambda;
import io.swagger.codegen.v3.utils.ModelUtils;
import io.swagger.codegen.v3.utils.URLPathUtil;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.DateSchema;
import io.swagger.v3.oas.models.media.DateTimeSchema;
import io.swagger.v3.oas.models.media.MapSchema;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.responses.ApiResponse;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCSharpCodegen
extends DefaultCodegenConfig {
    protected boolean optionalAssemblyInfoFlag = true;
    protected boolean optionalProjectFileFlag = true;
    protected boolean optionalEmitDefaultValue = false;
    protected boolean optionalMethodArgumentFlag = true;
    protected boolean useDateTimeOffsetFlag = false;
    protected boolean useCollection = false;
    protected boolean returnICollection = false;
    protected boolean preserveNewLines = false;
    protected boolean netCoreProjectFileFlag = false;
    protected String modelPropertyNaming = CodegenConstants.MODEL_PROPERTY_NAMING_TYPE.PascalCase.name();
    protected String packageVersion = "1.0.0";
    protected String packageName = "IO.Swagger";
    protected String packageTitle = "Swagger Library";
    protected String packageProductName = "SwaggerLibrary";
    protected String packageDescription = "A library generated from a Swagger doc";
    protected String packageCompany = "Swagger";
    protected String packageCopyright = "No Copyright";
    protected String packageAuthors = "Swagger";
    protected String interfacePrefix = "I";
    protected String sourceFolder;
    protected String testFolder = this.sourceFolder = "src";
    protected Set<String> collectionTypes;
    protected Set<String> mapTypes;
    protected Logger LOGGER = LoggerFactory.getLogger(AbstractCSharpCodegen.class);

    public AbstractCSharpCodegen() {
        this.supportsInheritance = true;
        this.importMapping.clear();
        this.outputFolder = "generated-code" + File.separator + this.getName();
        this.collectionTypes = new HashSet<String>(Arrays.asList("IList", "List", "ICollection", "Collection", "IEnumerable"));
        this.mapTypes = new HashSet<String>(Arrays.asList("IDictionary"));
        this.setReservedWordsLowerCase(Arrays.asList("Client", "client", "parameter", "File", "localVarPath", "localVarPathParams", "localVarQueryParams", "localVarHeaderParams", "localVarFormParams", "localVarFileParams", "localVarStatusCode", "localVarResponse", "localVarPostBody", "localVarHttpHeaderAccepts", "localVarHttpHeaderAccept", "localVarHttpContentTypes", "localVarHttpContentType", "localVarStatusCode", "abstract", "as", "base", "bool", "break", "byte", "case", "catch", "char", "checked", "class", "const", "continue", "decimal", "default", "delegate", "do", "double", "else", "enum", "event", "explicit", "extern", "false", "finally", "fixed", "float", "for", "foreach", "goto", "if", "implicit", "in", "int", "interface", "internal", "is", "lock", "long", "namespace", "new", "null", "object", "operator", "out", "override", "params", "private", "protected", "public", "readonly", "ref", "return", "sbyte", "sealed", "short", "sizeof", "stackalloc", "static", "string", "struct", "switch", "this", "throw", "true", "try", "typeof", "uint", "ulong", "unchecked", "unsafe", "ushort", "using", "virtual", "void", "volatile", "while"));
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("String", "string", "bool?", "double?", "decimal?", "int?", "long?", "float?", "byte[]", "ICollection", "Collection", "List", "Dictionary", "DateTime?", "DateTimeOffset?", "String", "Boolean", "Double", "Int32", "Int64", "Float", "Guid?", "System.IO.Stream", "Object"));
        this.instantiationTypes.put("array", "List");
        this.instantiationTypes.put("list", "List");
        this.instantiationTypes.put("map", "Dictionary");
        this.typeMapping = new HashMap();
        this.typeMapping.put("string", "string");
        this.typeMapping.put("binary", "byte[]");
        this.typeMapping.put("bytearray", "byte[]");
        this.typeMapping.put("boolean", "bool?");
        this.typeMapping.put("integer", "int?");
        this.typeMapping.put("int", "int?");
        this.typeMapping.put("float", "float?");
        this.typeMapping.put("long", "long?");
        this.typeMapping.put("double", "double?");
        this.typeMapping.put("number", "decimal?");
        this.typeMapping.put("BigDecimal", "decimal?");
        this.typeMapping.put("datetime", "DateTime?");
        this.typeMapping.put("date", "DateTime?");
        this.typeMapping.put("file", "System.IO.Stream");
        this.typeMapping.put("array", "List");
        this.typeMapping.put("list", "List");
        this.typeMapping.put("map", "Dictionary");
        this.typeMapping.put("object", "Object");
        this.typeMapping.put("uuid", "Guid?");
    }

    public void setReturnICollection(boolean returnICollection) {
        this.returnICollection = returnICollection;
    }

    public void setOptionalEmitDefaultValue(boolean optionalEmitDefaultValue) {
        this.optionalEmitDefaultValue = optionalEmitDefaultValue;
    }

    public void setUseCollection(boolean useCollection) {
        this.useCollection = useCollection;
        if (useCollection) {
            this.typeMapping.put("array", "Collection");
            this.typeMapping.put("list", "Collection");
            this.instantiationTypes.put("array", "Collection");
            this.instantiationTypes.put("list", "Collection");
        }
    }

    public void setOptionalMethodArgumentFlag(boolean flag) {
        this.optionalMethodArgumentFlag = flag;
    }

    public void setNetCoreProjectFileFlag(boolean flag) {
        this.netCoreProjectFileFlag = flag;
    }

    public void useDateTimeOffset(boolean flag) {
        this.useDateTimeOffsetFlag = flag;
        if (flag) {
            this.typeMapping.put("datetime", "DateTimeOffset?");
        } else {
            this.typeMapping.put("datetime", "DateTime?");
        }
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (StringUtils.isBlank((CharSequence)this.templateDir)) {
            this.embeddedTemplateDir = this.templateDir = this.getTemplateDir();
        }
        if (this.additionalProperties.containsKey("packageVersion")) {
            this.setPackageVersion((String)this.additionalProperties.get("packageVersion"));
        } else {
            this.additionalProperties.put("packageVersion", this.packageVersion);
        }
        if (this.additionalProperties.containsKey("sourceFolder")) {
            this.setSourceFolder((String)this.additionalProperties.get("sourceFolder"));
        } else {
            this.additionalProperties.put("sourceFolder", this.sourceFolder);
        }
        if (this.additionalProperties.containsKey("packageName")) {
            this.setPackageName((String)this.additionalProperties.get("packageName"));
        } else {
            this.additionalProperties.put("packageName", this.packageName);
        }
        if (this.additionalProperties.containsKey("invokerPackage")) {
            this.LOGGER.warn(String.format("%s is not used by C# generators. Please use %s", "invokerPackage", "packageName"));
        }
        if (this.additionalProperties.containsKey("packageTitle")) {
            this.setPackageTitle((String)this.additionalProperties.get("packageTitle"));
        } else {
            this.additionalProperties.put("packageTitle", this.packageTitle);
        }
        if (this.additionalProperties.containsKey("packageProductName")) {
            this.setPackageProductName((String)this.additionalProperties.get("packageProductName"));
        } else {
            this.additionalProperties.put("packageProductName", this.packageProductName);
        }
        if (this.additionalProperties.containsKey("packageDescription")) {
            this.setPackageDescription((String)this.additionalProperties.get("packageDescription"));
        } else {
            this.additionalProperties.put("packageDescription", this.packageDescription);
        }
        if (this.additionalProperties.containsKey("packageCompany")) {
            this.setPackageCompany((String)this.additionalProperties.get("packageCompany"));
        } else {
            this.additionalProperties.put("packageCompany", this.packageCompany);
        }
        if (this.additionalProperties.containsKey("packageCopyright")) {
            this.setPackageCopyright((String)this.additionalProperties.get("packageCopyright"));
        } else {
            this.additionalProperties.put("packageCopyright", this.packageCopyright);
        }
        if (this.additionalProperties.containsKey("packageAuthors")) {
            this.setPackageAuthors((String)this.additionalProperties.get("packageAuthors"));
        } else {
            this.additionalProperties.put("packageAuthors", this.packageAuthors);
        }
        if (this.additionalProperties.containsKey("useDateTimeOffset")) {
            this.useDateTimeOffset(this.convertPropertyToBooleanAndWriteBack("useDateTimeOffset"));
        } else {
            this.additionalProperties.put("useDateTimeOffset", this.useDateTimeOffsetFlag);
        }
        if (this.additionalProperties.containsKey("useCollection")) {
            this.setUseCollection(this.convertPropertyToBooleanAndWriteBack("useCollection"));
        } else {
            this.additionalProperties.put("useCollection", this.useCollection);
        }
        if (this.additionalProperties.containsKey("returnICollection")) {
            this.setReturnICollection(this.convertPropertyToBooleanAndWriteBack("returnICollection"));
        } else {
            this.additionalProperties.put("returnICollection", this.returnICollection);
        }
        if (this.additionalProperties.containsKey("optionalEmitDefaultValues")) {
            this.setOptionalEmitDefaultValue(this.convertPropertyToBooleanAndWriteBack("optionalEmitDefaultValues"));
        } else {
            this.additionalProperties.put("optionalEmitDefaultValues", this.optionalEmitDefaultValue);
        }
        if (this.additionalProperties.containsKey("netCoreProjectFile")) {
            this.setNetCoreProjectFileFlag(this.convertPropertyToBooleanAndWriteBack("netCoreProjectFile"));
        } else {
            this.additionalProperties.put("netCoreProjectFile", this.netCoreProjectFileFlag);
        }
        if (this.additionalProperties.containsKey("preserveNewlinesInComments")) {
            this.setPreserveNewLines(Boolean.valueOf(this.additionalProperties.get("preserveNewlinesInComments").toString()));
        }
        if (this.additionalProperties.containsKey("interfacePrefix")) {
            String useInterfacePrefix = this.additionalProperties.get("interfacePrefix").toString();
            if ("false".equals(useInterfacePrefix.toLowerCase())) {
                this.setInterfacePrefix("");
            } else if (!"true".equals(useInterfacePrefix.toLowerCase())) {
                this.setInterfacePrefix(this.sanitizeName(useInterfacePrefix));
            }
        }
        this.additionalProperties.put("interfacePrefix", this.interfacePrefix);
        this.addHandlebarsLambdas(this.additionalProperties);
    }

    private void addHandlebarsLambdas(Map<String, Object> objs) {
        ImmutableMap lambdas = new ImmutableMap.Builder().put((Object)"lowercase", (Object)new LowercaseLambda().generator(this)).put((Object)"uppercase", (Object)new UppercaseLambda()).put((Object)"titlecase", (Object)new TitlecaseLambda()).put((Object)"camelcase", (Object)new CamelCaseLambda().generator(this)).put((Object)"camelcase_param", (Object)new CamelCaseLambda().generator(this).escapeAsParamName(true)).put((Object)"indented", (Object)new IndentedLambda()).put((Object)"indented_8", (Object)new IndentedLambda(8, " ")).put((Object)"indented_12", (Object)new IndentedLambda(12, " ")).put((Object)"indented_16", (Object)new IndentedLambda(16, " ")).build();
        if (objs.containsKey("lambda")) {
            this.LOGGER.warn("An property named 'lambda' already exists. Mustache lambdas renamed from 'lambda' to '_lambda'. You'll likely need to use a custom template, see https://github.com/swagger-api/swagger-codegen#modifying-the-client-library-format. ");
            objs.put("_lambda", lambdas);
        } else {
            objs.put("lambda", lambdas);
        }
    }

    @Override
    public void postProcessModelProperty(CodegenModel model, CodegenProperty property) {
        super.postProcessModelProperty(model, property);
    }

    @Override
    public Map<String, Object> postProcessModels(Map<String, Object> objs) {
        List models = (List)objs.get("models");
        for (Object _mo : models) {
            Map mo = (Map)_mo;
            CodegenModel cm = (CodegenModel)mo.get("model");
            for (CodegenProperty var : cm.vars) {
                if (!var.name.equalsIgnoreCase(cm.name)) continue;
                var.name = "_" + var.name;
            }
        }
        return this.postProcessModelsEnum(objs);
    }

    @Override
    public Map<String, Object> postProcessAllModels(Map<String, Object> objs) {
        Map<String, Object> processed = super.postProcessAllModels(objs);
        this.postProcessEnumRefs(processed);
        return processed;
    }

    private void postProcessEnumRefs(Map<String, Object> models) {
        HashMap<String, CodegenModel> enumRefs = new HashMap<String, CodegenModel>();
        for (Map.Entry<String, Object> entry : models.entrySet()) {
            CodegenModel model = ModelUtils.getModelByName((String)entry.getKey(), models);
            boolean isEnum = ExtensionHelper.getBooleanValue((VendorExtendable)model, "x-is-enum");
            if (!isEnum) continue;
            enumRefs.put(entry.getKey(), model);
        }
        for (Map.Entry<String, Object> entry : models.entrySet()) {
            String swaggerName = entry.getKey();
            CodegenModel model = ModelUtils.getModelByName((String)swaggerName, models);
            if (model != null) {
                for (CodegenProperty var : model.allVars) {
                    if (!enumRefs.containsKey(var.datatype)) continue;
                    CodegenModel refModel = (CodegenModel)enumRefs.get(var.datatype);
                    var.allowableValues = refModel.allowableValues;
                    this.updateCodegenPropertyEnum(var);
                    var.getVendorExtensions().put("x-is-primitive-type", Boolean.TRUE);
                    var.getVendorExtensions().put("x-is-enum", Boolean.TRUE);
                }
                if (!ExtensionHelper.getBooleanValue((VendorExtendable)model, "x-is-enum")) continue;
                Boolean isString = false;
                Boolean isInteger = false;
                Boolean isLong = false;
                Boolean isByte = false;
                if (model.dataType.startsWith("byte")) {
                    isByte = true;
                    model.vendorExtensions.put("x-enum-byte", true);
                } else if (model.dataType.startsWith("int32")) {
                    isInteger = true;
                    model.vendorExtensions.put("x-enum-integer", true);
                } else if (model.dataType.startsWith("int64")) {
                    isLong = true;
                    model.vendorExtensions.put("x-enum-long", true);
                } else {
                    isString = true;
                    model.vendorExtensions.put("x-enum-string", true);
                }
                ArrayList enumVars = (ArrayList)model.allowableValues.get("enumVars");
                ArrayList newEnumVars = new ArrayList();
                for (Map enumVar : enumVars) {
                    HashMap<String, Boolean> mixedVars = new HashMap<String, Boolean>();
                    mixedVars.putAll(enumVar);
                    mixedVars.put("isString", isString);
                    mixedVars.put("isLong", isLong);
                    mixedVars.put("isInteger", isInteger);
                    mixedVars.put("isByte", isByte);
                    newEnumVars.add(mixedVars);
                }
                if (newEnumVars.isEmpty()) continue;
                model.allowableValues.put("enumVars", newEnumVars);
                continue;
            }
            this.LOGGER.warn("Expected to retrieve model %s by name, but no model was found. Check your -Dmodels inclusions.", (Object)swaggerName);
        }
    }

    @Override
    public void updateCodegenPropertyEnum(CodegenProperty var) {
        if (var.vendorExtensions == null) {
            var.vendorExtensions = new HashMap();
        }
        super.updateCodegenPropertyEnum(var);
        if (ExtensionHelper.getBooleanValue((VendorExtendable)var, "x-is-enum")) {
            if ("byte".equals(var.dataFormat)) {
                var.vendorExtensions.put("x-enum-byte", true);
                var.vendorExtensions.put("x-is-string", Boolean.FALSE);
                var.vendorExtensions.put("x-is-long", Boolean.FALSE);
                var.vendorExtensions.put("x-is-integer", Boolean.FALSE);
            } else if ("int32".equals(var.dataFormat)) {
                var.vendorExtensions.put("x-is-integer", Boolean.TRUE);
                var.vendorExtensions.put("x-is-string", Boolean.FALSE);
                var.vendorExtensions.put("x-is-long", Boolean.FALSE);
            } else if ("int64".equals(var.dataFormat)) {
                var.vendorExtensions.put("x-is-long", Boolean.TRUE);
                var.vendorExtensions.put("x-is-string", Boolean.FALSE);
                var.vendorExtensions.put("x-is-integer", Boolean.FALSE);
            } else {
                var.vendorExtensions.put("x-is-string", Boolean.TRUE);
                var.vendorExtensions.put("x-is-long", Boolean.FALSE);
                var.vendorExtensions.put("x-is-integer", Boolean.FALSE);
            }
        }
    }

    @Override
    public Map<String, Object> postProcessOperations(Map<String, Object> objs) {
        Map operations;
        super.postProcessOperations(objs);
        if (objs != null && (operations = (Map)objs.get("operations")) != null) {
            List ops = (List)operations.get("operation");
            for (CodegenOperation operation : ops) {
                if (operation.returnType != null) {
                    int namespaceEnd = operation.returnType.lastIndexOf(".");
                    String typeMapping = namespaceEnd > 0 ? operation.returnType.substring(namespaceEnd) : operation.returnType;
                    if (this.collectionTypes.contains(typeMapping)) {
                        int genericStart;
                        operation.getVendorExtensions().put("x-is-list-container", Boolean.TRUE);
                        operation.returnContainer = operation.returnType;
                        if (this.returnICollection && (typeMapping.startsWith("List") || typeMapping.startsWith("Collection")) && (genericStart = typeMapping.indexOf("<")) > 0) {
                            operation.returnType = "ICollection" + typeMapping.substring(genericStart);
                        }
                    } else {
                        operation.returnContainer = operation.returnType;
                        operation.getVendorExtensions().put("x-is-map-container", this.mapTypes.contains(typeMapping));
                    }
                }
                if (operation.examples != null) {
                    for (Map example : operation.examples) {
                        for (Map.Entry entry : example.entrySet()) {
                            String val = ((String)entry.getValue()).replace("\"", "\\\"").replace("\r", "\\r").replace("\n", "\\n");
                            entry.setValue(val);
                        }
                    }
                }
                this.processOperation(operation);
            }
        }
        return objs;
    }

    protected void processOperation(CodegenOperation operation) {
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separator + this.sourceFolder + File.separator + this.packageName + File.separator + this.apiPackage();
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + File.separator + this.sourceFolder + File.separator + this.packageName + File.separator + this.modelPackage();
    }

    @Override
    public String toModelFilename(String name) {
        return this.toModelName(name);
    }

    @Override
    public String toOperationId(String operationId) {
        if (StringUtils.isEmpty((CharSequence)operationId)) {
            throw new RuntimeException("Empty method name (operationId) not allowed");
        }
        if (this.isReservedWord(operationId)) {
            this.LOGGER.warn(operationId + " (reserved word) cannot be used as method name. Renamed to " + AbstractCSharpCodegen.camelize(this.sanitizeName("call_" + operationId)));
            operationId = "call_" + operationId;
        }
        return AbstractCSharpCodegen.camelize(this.sanitizeName(operationId));
    }

    @Override
    public String toVarName(String name) {
        if ((name = this.sanitizeName(name)).matches("^[A-Z_]*$")) {
            return name;
        }
        if (this.isReservedWord(name = AbstractCSharpCodegen.camelize(name)) || name.matches("^\\d.*")) {
            name = this.escapeReservedWord(name);
        }
        return name;
    }

    @Override
    public String toParamName(String name) {
        name = this.sanitizeName(name);
        if ((name = name.replaceAll("-", "_")).matches("^[A-Z_]*$")) {
            return name;
        }
        if (this.isReservedWord(name = AbstractCSharpCodegen.camelize(name, true)) || name.matches("^\\d.*")) {
            name = this.escapeReservedWord(name);
        }
        return name;
    }

    @Override
    public String escapeReservedWord(String name) {
        if (this.reservedWordsMappings().containsKey(name)) {
            return this.reservedWordsMappings().get(name);
        }
        return "_" + name;
    }

    @Override
    public String toExampleValue(Schema schema) {
        if (schema instanceof StringSchema && schema.getExample() != null) {
            return String.format("\"%s\"", schema.getExample().toString());
        }
        if (schema instanceof DateSchema || schema instanceof DateTimeSchema) {
            return null;
        }
        if (schema.getExample() != null) {
            return schema.getExample().toString();
        }
        return null;
    }

    @Override
    public String toDefaultValue(Schema schema) {
        if (schema instanceof StringSchema && schema.getDefault() != null) {
            String _default = schema.getDefault().toString();
            if (schema.getEnum() == null) {
                return String.format("\"%s\"", _default);
            }
            return _default;
        }
        if (schema instanceof DateSchema || schema instanceof DateTimeSchema) {
            return null;
        }
        if (schema.getDefault() != null) {
            if ("int64".equals(schema.getFormat())) {
                return String.format("%1$sF", schema.getDefault());
            }
            return schema.getDefault().toString();
        }
        return null;
    }

    @Override
    protected boolean isReservedWord(String word) {
        return this.reservedWords.contains(word);
    }

    @Override
    public String getSchemaType(Schema propertySchema) {
        String type;
        String swaggerType = super.getSchemaType(propertySchema);
        if (swaggerType == null) {
            swaggerType = "";
        }
        if (this.typeMapping.containsKey(swaggerType.toLowerCase())) {
            type = (String)this.typeMapping.get(swaggerType.toLowerCase());
            if (this.languageSpecificPrimitives.contains(type)) {
                return type;
            }
        } else {
            type = swaggerType;
        }
        return this.toModelName(type);
    }

    private String getArrayTypeDeclaration(ArraySchema arr) {
        String arrayType = (String)this.typeMapping.get("array");
        StringBuilder instantiationType = new StringBuilder(arrayType);
        Schema items = arr.getItems();
        String nestedType = this.getTypeDeclaration(items);
        instantiationType.append("<").append(nestedType).append(">");
        return instantiationType.toString();
    }

    @Override
    public String toInstantiationType(Schema schema) {
        if (schema instanceof ArraySchema) {
            return this.getArrayTypeDeclaration((ArraySchema)schema);
        }
        return super.toInstantiationType(schema);
    }

    @Override
    public String getTypeDeclaration(Schema propertySchema) {
        if (propertySchema instanceof ArraySchema) {
            Schema inner = ((ArraySchema)propertySchema).getItems();
            return String.format("%s<%s>", this.getSchemaType(propertySchema), this.getTypeDeclaration(inner));
        }
        if (propertySchema instanceof MapSchema && AbstractCSharpCodegen.hasSchemaProperties(propertySchema)) {
            Schema inner = (Schema)propertySchema.getAdditionalProperties();
            return String.format("%s<string, %s>", this.getSchemaType(propertySchema), this.getTypeDeclaration(inner));
        }
        if (propertySchema instanceof MapSchema && AbstractCSharpCodegen.hasTrueAdditionalProperties(propertySchema)) {
            ObjectSchema inner = new ObjectSchema();
            return String.format("%s<string, %s>", this.getSchemaType(propertySchema), this.getTypeDeclaration((Schema)inner));
        }
        return super.getTypeDeclaration(propertySchema);
    }

    @Override
    public String toModelName(String name) {
        if (this.importMapping.containsKey(name)) {
            return (String)this.importMapping.get(name);
        }
        if (!StringUtils.isEmpty((CharSequence)this.modelNamePrefix)) {
            name = this.modelNamePrefix + "_" + name;
        }
        if (!StringUtils.isEmpty((CharSequence)this.modelNameSuffix)) {
            name = name + "_" + this.modelNameSuffix;
        }
        if (this.isReservedWord(name = this.sanitizeName(name))) {
            this.LOGGER.warn(name + " (reserved word) cannot be used as model name. Renamed to " + AbstractCSharpCodegen.camelize("model_" + name));
            name = "model_" + name;
        }
        if (name.matches("^\\d.*")) {
            this.LOGGER.warn(name + " (model name starts with number) cannot be used as model name. Renamed to " + AbstractCSharpCodegen.camelize("model_" + name));
            name = "model_" + name;
        }
        return AbstractCSharpCodegen.camelize(name);
    }

    @Override
    public String apiTestFileFolder() {
        return this.outputFolder + ".Test";
    }

    @Override
    public String modelTestFileFolder() {
        return this.outputFolder + ".Test";
    }

    @Override
    public String toApiTestFilename(String name) {
        return this.toApiName(name) + "Tests";
    }

    @Override
    public String toModelTestFilename(String name) {
        return this.toModelName(name) + "Tests";
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void setPackageVersion(String packageVersion) {
        this.packageVersion = packageVersion;
    }

    public void setPackageTitle(String packageTitle) {
        this.packageTitle = packageTitle;
    }

    public void setPackageProductName(String packageProductName) {
        this.packageProductName = packageProductName;
    }

    public void setPackageDescription(String packageDescription) {
        this.packageDescription = packageDescription;
    }

    public void setPackageCompany(String packageCompany) {
        this.packageCompany = packageCompany;
    }

    public void setPackageCopyright(String packageCopyright) {
        this.packageCopyright = packageCopyright;
    }

    public void setPackageAuthors(String packageAuthors) {
        this.packageAuthors = packageAuthors;
    }

    public void setSourceFolder(String sourceFolder) {
        this.sourceFolder = sourceFolder;
    }

    public String getInterfacePrefix() {
        return this.interfacePrefix;
    }

    public void setInterfacePrefix(String interfacePrefix) {
        this.interfacePrefix = interfacePrefix;
    }

    @Override
    public CodegenModel fromModel(String name, Schema schema, Map<String, Schema> allDefinitions) {
        CodegenModel codegenModel = super.fromModel(name, schema, allDefinitions);
        if (this.typeMapping.containsKey(name.toLowerCase()) && this.isReservedWord(name.toLowerCase())) {
            this.typeMapping.remove(name.toLowerCase());
        }
        return codegenModel;
    }

    @Override
    public String toEnumValue(String value, String datatype) {
        if (datatype.startsWith("int") || datatype.startsWith("long") || datatype.startsWith("byte")) {
            return value;
        }
        return this.escapeText(value);
    }

    @Override
    public String toEnumVarName(String name, String datatype) {
        if (name.length() == 0) {
            return "Empty";
        }
        if (this.getSymbolName(name) != null) {
            return AbstractCSharpCodegen.camelize(this.getSymbolName(name));
        }
        String enumName = this.sanitizeName(name);
        enumName = enumName.replaceFirst("^_", "");
        enumName = enumName.replaceFirst("_$", "");
        if ((enumName = AbstractCSharpCodegen.camelize(enumName) + "Enum").matches("\\d.*")) {
            return "_" + enumName;
        }
        return enumName;
    }

    @Override
    public String toEnumName(CodegenProperty property) {
        return this.sanitizeName(AbstractCSharpCodegen.camelize(property.name)) + "Enum";
    }

    public String testPackageName() {
        return this.packageName + ".Test";
    }

    public boolean isPreserveNewLines() {
        return this.preserveNewLines;
    }

    public void setPreserveNewLines(boolean preserveNewLines) {
        this.preserveNewLines = preserveNewLines;
    }

    @Override
    public void preprocessOpenAPI(OpenAPI openAPI) {
        super.preprocessOpenAPI(openAPI);
        URL urlInfo = URLPathUtil.getServerURL((OpenAPI)openAPI);
        if (urlInfo != null && urlInfo.getPort() > 0) {
            this.additionalProperties.put("serverUrl", String.format("%s://%s:%s", urlInfo.getProtocol(), urlInfo.getHost(), urlInfo.getPort()));
            if (StringUtils.isNotBlank((CharSequence)urlInfo.getPath())) {
                this.additionalProperties.put("basePathWithoutHost", urlInfo.getPath());
            }
        } else {
            this.additionalProperties.put("serverUrl", "http://localhost:8080");
        }
        if (this.preserveNewLines) {
            Map schemaMap;
            Map map = schemaMap = openAPI.getComponents() != null ? openAPI.getComponents().getSchemas() : null;
            if (schemaMap != null) {
                for (String name : schemaMap.keySet()) {
                    Map propertiesMap;
                    Schema schema = (Schema)schemaMap.get(name);
                    if (StringUtils.isNotBlank((CharSequence)schema.getDescription())) {
                        schema.setDescription(this.preserveNewlines(schema.getDescription(), 1));
                    }
                    if ((propertiesMap = schema.getProperties()) == null || propertiesMap.isEmpty()) continue;
                    for (String propertyName : propertiesMap.keySet()) {
                        Schema propertySchema = (Schema)propertiesMap.get(propertyName);
                        if (!StringUtils.isNotBlank((CharSequence)propertySchema.getDescription())) continue;
                        propertySchema.setDescription(this.preserveNewlines(propertySchema.getDescription(), 2));
                    }
                }
            }
            for (String pathname : openAPI.getPaths().keySet()) {
                PathItem path = (PathItem)openAPI.getPaths().get((Object)pathname);
                for (Operation op : path.readOperations()) {
                    if (StringUtils.isNotBlank((CharSequence)op.getDescription())) {
                        op.setDescription(this.preserveNewlines(op.getDescription(), 2));
                    }
                    if (StringUtils.isNotBlank((CharSequence)op.getSummary())) {
                        op.setSummary(this.preserveNewlines(op.getSummary(), 2));
                    }
                    if (op.getParameters() != null) {
                        for (Parameter param : op.getParameters()) {
                            if (!StringUtils.isNotBlank((CharSequence)param.getDescription())) continue;
                            param.setDescription(this.preserveNewlines(param.getDescription(), 2));
                        }
                    }
                    if (op.getResponses() == null) continue;
                    for (String responseCode : op.getResponses().keySet()) {
                        ApiResponse response = (ApiResponse)op.getResponses().get((Object)responseCode);
                        if (!StringUtils.isNotBlank((CharSequence)response.getDescription())) continue;
                        response.setDescription(this.preserveNewlines(response.getDescription(), 2));
                    }
                }
            }
        }
    }

    @Override
    public String getDefaultTemplateDir() {
        return this.getName();
    }

    public String preserveNewlines(String input, int tabstops) {
        if (tabstops == 1) {
            return input.replaceAll("\\n", "~~N1");
        }
        return input.replaceAll("\\n", "~~N2");
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("\"", "");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        String intermediate = input.replace("*/", "*_/").replace("/*", "/_*").replace("--", "- -");
        intermediate = intermediate.replaceAll("~~N1", "\n    /// ");
        intermediate = intermediate.replaceAll("~~N2", "\n        /// ");
        return intermediate;
    }

    @Override
    public void addHandlebarHelpers(Handlebars handlebars) {
        super.addHandlebarHelpers(handlebars);
        handlebars.registerHelpers((Object)new CsharpHelper());
    }
}

