/*
 * Decompiled with CFR 0.152.
 */
package springfox.bean.validators.plugins.schema;

import java.util.Optional;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import springfox.bean.validators.plugins.RangeAnnotations;
import springfox.bean.validators.plugins.Validators;
import springfox.documentation.common.Compatibility;
import springfox.documentation.schema.ElementFacet;
import springfox.documentation.schema.NumericElementFacet;
import springfox.documentation.service.AllowableRangeValues;
import springfox.documentation.service.AllowableValues;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.schema.ModelPropertyBuilderPlugin;
import springfox.documentation.spi.schema.contexts.ModelPropertyContext;

@Component
@Order(value=-2147483148)
public class MinMaxAnnotationPlugin
implements ModelPropertyBuilderPlugin {
    private static final Logger LOGGER = LoggerFactory.getLogger(MinMaxAnnotationPlugin.class);

    public boolean supports(DocumentationType delimiter) {
        return true;
    }

    public void apply(ModelPropertyContext context) {
        Optional<Min> min = this.extractMin(context);
        Optional<Max> max = this.extractMax(context);
        Compatibility<AllowableRangeValues, NumericElementFacet> values = RangeAnnotations.allowableRange(min, max);
        LOGGER.debug(String.format("Adding allowable Values: %s", values.getLegacy().map(AllowableRangeValues::toString).orElse("<none>")));
        context.getBuilder().allowableValues((AllowableValues)values.getLegacy().orElse(null));
        LOGGER.debug(String.format("Adding numeric element facet : %s", values.getModern().map(NumericElementFacet::toString).orElse("<none>")));
        values.getModern().ifPresent(facet -> context.getSpecificationBuilder().numericFacet(n -> n.copyOf((ElementFacet)facet)));
    }

    private Optional<Min> extractMin(ModelPropertyContext context) {
        return Validators.annotationFromBean(context, Min.class).map(Optional::of).orElse(Validators.annotationFromField(context, Min.class));
    }

    private Optional<Max> extractMax(ModelPropertyContext context) {
        return Validators.annotationFromBean(context, Max.class).map(Optional::of).orElse(Validators.annotationFromField(context, Max.class));
    }
}

